/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AgentInterfaceConfig;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.loader.total.StreamRegistry;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.parsers.ITFParser;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import storage.StorageException;
import storage.StorageItf;

public class Agent {
    private static final COMPSsRuntimeImpl RUNTIME;
    private static final Random APP_ID_GENERATOR;
    private static final List<AgentInterface<?>> INTERFACES;

    public static long runMain(COMPSsConstants.Lang lang, String ceiClass, String className, String methodName, Object[] params, AppMonitor monitor) throws AgentException {
        long appId = Math.abs(APP_ID_GENERATOR.nextLong());
        long mainAppId = Math.abs(APP_ID_GENERATOR.nextLong());
        monitor.setAppId(mainAppId);
        try {
            Class<?> cei = Class.forName(ceiClass);
            List<CoreElementDefinition> ceds = ITFParser.parseITFMethods(cei);
            for (CoreElementDefinition ced : ceds) {
                RUNTIME.registerCoreElement(ced);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new AgentException("Could not find class " + ceiClass + " to detect internal methods.");
        }
        Object[] paramsValues = new Object[]{RUNTIME, DataType.OBJECT_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "runtime", RUNTIME, DataType.OBJECT_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "api", ceiClass, DataType.STRING_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "ceiClass", appId, DataType.LONG_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "appId", className, DataType.STRING_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "className", methodName, DataType.STRING_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "methodName", params, DataType.OBJECT_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "params", new Object(), DataType.OBJECT_T, Direction.OUT, StdIOStream.UNSPECIFIED, "", "return"};
        RUNTIME.executeTask((Long)mainAppId, (TaskMonitor)monitor, lang, "es.bsc.compss.agent.loader.Loader", "load", false, 1, false, false, false, 8, OnFailure.RETRY, paramsValues);
        return mainAppId;
    }

    public static long runTask(COMPSsConstants.Lang lang, String className, String methodName, ApplicationParameter[] sarParams, ApplicationParameter target, boolean hasResult, AppMonitor monitor) throws AgentException {
        long appId = Math.abs(APP_ID_GENERATOR.nextLong());
        monitor.setAppId(appId);
        try {
            StringBuilder typesSB = new StringBuilder();
            int paramsCount = sarParams.length;
            if (target != null) {
                ++paramsCount;
            }
            if (hasResult) {
                ++paramsCount;
            }
            Object[] params = new Object[6 * paramsCount];
            int position = 0;
            for (ApplicationParameter param : sarParams) {
                if (typesSB.length() > 0) {
                    typesSB.append(",");
                }
                if (param.getType() != DataType.PSCO_T) {
                    typesSB.append(param.getType().toString());
                } else {
                    typesSB.append("OBJECT_T");
                }
                params[position] = param.getValueContent();
                params[position + 1] = param.getType();
                params[position + 2] = param.getDirection();
                params[position + 3] = StdIOStream.UNSPECIFIED;
                params[position + 4] = "";
                params[position + 5] = "";
                position += 6;
            }
            if (target != null) {
                params[position] = target.getValueContent();
                params[position + 1] = target.getType();
                params[position + 2] = target.getDirection();
                params[position + 3] = StdIOStream.UNSPECIFIED;
                params[position + 4] = "";
                params[position + 5] = "";
                position += 6;
            }
            if (hasResult) {
                params[position] = null;
                params[position + 1] = DataType.OBJECT_T;
                params[position + 2] = Direction.OUT;
                params[position + 3] = StdIOStream.UNSPECIFIED;
                params[position + 4] = "";
                params[position + 5] = "";
                position += 6;
            }
            String paramsTypes = typesSB.toString();
            String ceSignature = methodName + "(" + paramsTypes + ")";
            String implSignature = methodName + "(" + paramsTypes + ")" + className;
            CoreElementDefinition ced = new CoreElementDefinition();
            ced.setCeSignature(ceSignature);
            ImplementationDefinition<MethodResourceDescription> implDef = ImplementationDefinition.defineImplementation("METHOD", implSignature, new MethodResourceDescription(""), className, methodName);
            ced.addImplementation(implDef);
            RUNTIME.registerCoreElement(ced);
            RUNTIME.executeTask((Long)appId, (TaskMonitor)monitor, lang, className, methodName, false, 1, false, false, target != null, paramsCount, OnFailure.RETRY, params);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        return appId;
    }

    public static void addResources(Resource<?, ?> r) throws AgentException {
        String workerName = r.getName();
        String adaptor = r.getAdaptor();
        MethodResourceDescription description = r.getDescription();
        HashMap<String, Object> projectConf = new HashMap<String, Object>();
        projectConf.put("Properties", r.getProjectConf());
        HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
        resourcesConf.put("Properties", r.getResourceConf());
        DynamicMethodWorker worker = ResourceManager.getDynamicResource(workerName);
        if (worker != null) {
            ResourceManager.increasedDynamicWorker(worker, description);
        } else {
            MethodConfiguration mc;
            try {
                mc = (MethodConfiguration)Comm.constructConfiguration(adaptor, projectConf, resourcesConf);
            }
            catch (ConstructConfigurationException e) {
                throw new AgentException(e.getMessage(), e);
            }
            int limitOfTasks = mc.getLimitOfTasks();
            int computingUnits = description.getTotalCPUComputingUnits();
            if (limitOfTasks < 0 && computingUnits < 0) {
                mc.setLimitOfTasks(0);
                mc.setTotalComputingUnits(0);
            } else {
                mc.setLimitOfTasks(Math.max(limitOfTasks, computingUnits));
                mc.setTotalComputingUnits(Math.max(limitOfTasks, computingUnits));
            }
            mc.setLimitOfGPUTasks(description.getTotalGPUComputingUnits());
            mc.setTotalGPUComputingUnits(description.getTotalGPUComputingUnits());
            mc.setLimitOfFPGATasks(description.getTotalFPGAComputingUnits());
            mc.setTotalFPGAComputingUnits(description.getTotalFPGAComputingUnits());
            mc.setLimitOfOTHERsTasks(description.getTotalOTHERComputingUnits());
            mc.setTotalOTHERComputingUnits(description.getTotalOTHERComputingUnits());
            mc.setHost(workerName);
            DynamicMethodWorker mw = new DynamicMethodWorker(workerName, description, mc, new HashMap<String, String>());
            ResourceManager.addDynamicWorker(mw, description);
        }
    }

    public static void removeResources(String workerName, MethodResourceDescription reduction) throws AgentException {
        DynamicMethodWorker worker = ResourceManager.getDynamicResource(workerName);
        if (worker == null) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
        ResourceManager.requestWorkerReduction(worker, reduction);
    }

    public static void removeNode(String workerName) throws AgentException {
        try {
            ResourceManager.requestWholeWorkerReduction(workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static void lostNode(String workerName) throws AgentException {
        try {
            ResourceManager.notifyWholeWorkerReduction(workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static final void startInterface(AgentInterfaceConfig conf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        Class<?> agentClass = Class.forName(conf.getInterfaceClass());
        AgentInterface itf = (AgentInterface)agentClass.newInstance();
        itf.start(conf);
        INTERFACES.add(itf);
    }

    private static AgentInterfaceConfig getConfig(String className, String arguments) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        Class<?> agentClass = Class.forName(className);
        AgentInterface itf = (AgentInterface)agentClass.newInstance();
        return itf.configure(arguments);
    }

    public static final void main(String[] args) throws Exception {
        LinkedList<AgentInterfaceConfig> agents = new LinkedList<AgentInterfaceConfig>();
        agents.add(Agent.getConfig("es.bsc.compss.agent.rest.RESTAgent", args[0]));
        for (AgentInterfaceConfig agent : agents) {
            try {
                Agent.startInterface(agent);
            }
            catch (Exception e) {
                ErrorManager.warn("Could not start Agent", e);
            }
        }
        if (INTERFACES.isEmpty()) {
            ErrorManager.fatal("Could not start any interface");
        }
    }

    static {
        APP_ID_GENERATOR = new Random();
        String dcConfigPath = System.getProperty("dataclay.configpath");
        System.out.println("DataClay configuration: " + dcConfigPath);
        if (dcConfigPath != null) {
            try {
                StorageItf.init(dcConfigPath);
            }
            catch (StorageException se) {
                se.printStackTrace(System.err);
                System.err.println("Continuing...");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        StorageItf.finish();
                    }
                    catch (StorageException se) {
                        se.printStackTrace(System.err);
                        System.err.println("Continuing...");
                    }
                }
            });
        }
        RUNTIME = new COMPSsRuntimeImpl();
        RUNTIME.setObjectRegistry(new ObjectRegistry(RUNTIME));
        RUNTIME.setStreamRegistry(new StreamRegistry(RUNTIME));
        RUNTIME.startIT();
        CoreElementDefinition ced = new CoreElementDefinition();
        ced.setCeSignature("load(OBJECT_T,OBJECT_T,STRING_T,LONG_T,STRING_T,STRING_T,OBJECT_T)");
        MethodResourceDescription mrd = new MethodResourceDescription("");
        for (Processor p : mrd.getProcessors()) {
            p.setName("LocalProcessor");
        }
        ImplementationDefinition<MethodResourceDescription> implDef = ImplementationDefinition.defineImplementation("METHOD", "load(OBJECT_T,OBJECT_T,STRING_T,LONG_T,STRING_T,STRING_T,OBJECT_T)es.bsc.compss.agent.loader.Loader", new MethodResourceDescription(""), "es.bsc.compss.agent.loader.Loader", "load");
        ced.addImplementation(implDef);
        RUNTIME.registerCoreElement(ced);
        String hostName = System.getProperty("compss.agent.name");
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                hostName = "localhost";
            }
        }
        System.setProperty("compss.agent.name", hostName);
        INTERFACES = new LinkedList();
    }
}

