/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.rest.AppMainMonitor;
import es.bsc.compss.agent.rest.AppTaskMonitor;
import es.bsc.compss.agent.rest.RESTAgentConf;
import es.bsc.compss.agent.rest.RESTServiceLauncher;
import es.bsc.compss.agent.rest.types.ApplicationParameterImpl;
import es.bsc.compss.agent.rest.types.Orchestrator;
import es.bsc.compss.agent.rest.types.messages.EndApplicationNotification;
import es.bsc.compss.agent.rest.types.messages.IncreaseNodeNotification;
import es.bsc.compss.agent.rest.types.messages.LostNodeNotification;
import es.bsc.compss.agent.rest.types.messages.ReduceNodeRequest;
import es.bsc.compss.agent.rest.types.messages.RemoveNodeRequest;
import es.bsc.compss.agent.rest.types.messages.StartApplicationRequest;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.agent.util.RemoteJobsRegistry;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.util.ErrorManager;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Server;

@Path(value="/COMPSs")
public class RESTAgent
implements AgentInterface<RESTAgentConf> {
    private int port;
    private Server server = null;

    @Override
    public RESTAgentConf configure(String arguments) throws AgentException {
        RESTAgentConf conf;
        try {
            int port = Integer.parseInt(arguments);
            conf = new RESTAgentConf(port);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        return conf;
    }

    @Override
    public synchronized void start(RESTAgentConf args) throws AgentException {
        if (this.server != null) {
            return;
        }
        RESTServiceLauncher launcher = null;
        try {
            this.port = args.getPort();
            System.setProperty("compss.agent.port", Integer.toString(this.port));
            launcher = new RESTServiceLauncher(this.port);
            new Thread(launcher).start();
            launcher.waitForBoot();
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        if (launcher.getStartError() != null) {
            throw new AgentException(launcher.getStartError());
        }
        this.server = launcher.getServer();
    }

    @Override
    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                ErrorManager.warn("Could not stop the REST server for the Agent at port " + this.port, ex);
            }
            finally {
                this.server.destroy();
                this.server = null;
            }
        }
    }

    @GET
    @Path(value="test/")
    public Response test() {
        System.out.println("test invoked");
        return Response.ok().build();
    }

    @PUT
    @Path(value="addResources/")
    @Consumes(value={"application/xml"})
    public Response addResource(IncreaseNodeNotification notification) {
        Resource r = notification.getResource();
        MethodResourceDescription description = r.getDescription();
        List<Processor> procs = description.getProcessors();
        description.setProcessors(procs);
        try {
            Agent.addResources(r);
        }
        catch (AgentException ex) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(ex.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="removeResources/")
    @Consumes(value={"application/xml"})
    public Response removeResources(ReduceNodeRequest request) {
        String name = request.getWorkerName();
        MethodResourceDescription mrd = request.getResources();
        List<Processor> procs = mrd.getProcessors();
        mrd.setProcessors(procs);
        try {
            Agent.removeResources(name, mrd);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="removeNode/")
    @Consumes(value={"application/xml"})
    public Response removeResource(RemoveNodeRequest request) {
        String name = request.getWorkerName();
        try {
            Agent.removeNode(name);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="lostNode/")
    @Consumes(value={"application/xml"})
    public Response lostResource(LostNodeNotification notification) {
        String name = notification.getWorkerName();
        try {
            Agent.lostNode(name);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="startApplication/")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response startApplication(StartApplicationRequest request) {
        String ceiClass = request.getCeiClass();
        Response response = ceiClass != null ? RESTAgent.runMain(request) : RESTAgent.runTask(request);
        return response;
    }

    private static Response runMain(StartApplicationRequest request) {
        long appId;
        Object[] params;
        String serviceInstanceId = request.getServiceInstanceId();
        String ceiClass = request.getCeiClass();
        String className = request.getClassName();
        String methodName = request.getMethodName();
        try {
            params = request.getParamsValuesContent();
        }
        catch (Exception cnfe) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("Could not recover an input parameter value. " + cnfe.getLocalizedMessage()).build();
        }
        AppMainMonitor monitor = new AppMainMonitor();
        try {
            appId = Agent.runMain(COMPSsConstants.Lang.JAVA, ceiClass, className, methodName, params, monitor);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok((Object)appId, "text/plain").build();
    }

    private static Response runTask(StartApplicationRequest request) {
        long appId;
        String className = request.getClassName();
        String methodName = request.getMethodName();
        ApplicationParameter[] sarParams = request.getParams();
        ApplicationParameterImpl target = request.getTarget();
        boolean hasResult = request.isHasResult();
        Orchestrator orchestrator = request.getOrchestrator();
        int numParams = sarParams.length;
        if (target != null) {
            ++numParams;
        }
        if (hasResult) {
            ++numParams;
        }
        AppTaskMonitor monitor = new AppTaskMonitor(numParams, orchestrator);
        try {
            appId = Agent.runTask(COMPSsConstants.Lang.JAVA, className, methodName, sarParams, target, hasResult, monitor);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok((Object)appId, "text/plain").build();
    }

    @PUT
    @Path(value="endApplication/")
    @Consumes(value={"application/xml"})
    public Response endApplication(EndApplicationNotification notification) {
        String jobId = notification.getJobId();
        JobEndStatus endStatus = notification.getEndStatus();
        DataType[] resultTypes = notification.getParamTypes();
        String[] resultLocations = notification.getParamLocations();
        RemoteJobsRegistry.notifyJobEnd(jobId, endStatus, resultTypes, resultLocations);
        return Response.ok().build();
    }

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        RESTAgentConf config = new RESTAgentConf(port);
        Agent.startInterface(config);
    }
}

