/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.types.messages;

import es.bsc.compss.agent.rest.types.ApplicationParameterImpl;
import es.bsc.compss.agent.rest.types.ApplicationParameterValue;
import es.bsc.compss.agent.rest.types.Orchestrator;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.parameter.Parameter;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="startApplication")
public class StartApplicationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceInstanceId;
    private String ceiClass;
    private String className;
    private String methodName;
    private ApplicationParameterImpl[] params = new ApplicationParameterImpl[0];
    private ApplicationParameterImpl target;
    private boolean hasResult;
    private Orchestrator orchestrator;

    public void setServiceInstanceId(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public String getCeiClass() {
        return this.ceiClass;
    }

    public void setCeiClass(String ceiClass) {
        this.ceiClass = ceiClass;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public ApplicationParameterImpl getTarget() {
        return this.target;
    }

    public void setTarget(ApplicationParameterImpl target) {
        this.target = target;
    }

    public void addParameter(boolean value) {
        this.addParameter(value, Direction.IN, DataType.BOOLEAN_T);
    }

    public void addParameter(byte value) {
        this.addParameter(value, Direction.IN, DataType.BYTE_T);
    }

    public void addParameter(char value) {
        this.addParameter(Character.valueOf(value), Direction.IN, DataType.CHAR_T);
    }

    public void addParameter(short value) {
        this.addParameter(value, Direction.IN, DataType.SHORT_T);
    }

    public void addParameter(int value) {
        this.addParameter(value, Direction.IN, DataType.INT_T);
    }

    public void addParameter(long value) {
        this.addParameter(value, Direction.IN, DataType.LONG_T);
    }

    public void addParameter(float value) {
        this.addParameter(Float.valueOf(value), Direction.IN, DataType.FLOAT_T);
    }

    public void addParameter(double value) {
        this.addParameter(value, Direction.IN, DataType.DOUBLE_T);
    }

    public void addParameter(String value) {
        this.addParameter(value, Direction.IN, DataType.STRING_T);
    }

    public void addParameter(Object value) {
        this.addParameter(value, Direction.IN);
    }

    public void addParameter(Object value, Direction direction) {
        this.addParameter(value, Direction.IN, DataType.OBJECT_T);
    }

    public void addPersistedParameter(String id) {
        this.addPersistedParameter(id, Direction.IN);
    }

    public void addPersistedParameter(String id, Direction direction) {
        ApplicationParameterImpl p = this.addParameter(id, direction, DataType.PSCO_T);
        ((ApplicationParameterValue.ElementParameter)p.getValue()).setClassName("storage.StubItf");
    }

    public void addParameter(Parameter p, Object value) {
        this.addParameter(value, p.getDirection(), p.getType());
    }

    private ApplicationParameterImpl addParameter(Object value, Direction direction, DataType type) {
        ApplicationParameterImpl p = new ApplicationParameterImpl(value, direction, type, StdIOStream.UNSPECIFIED);
        p.setParamId(this.params.length);
        ApplicationParameterImpl[] oldParams = this.params;
        this.params = new ApplicationParameterImpl[oldParams.length + 1];
        if (oldParams.length > 0) {
            System.arraycopy(oldParams, 0, this.params, 0, oldParams.length);
        }
        this.params[oldParams.length] = p;
        return p;
    }

    @XmlElementWrapper(name="parameters")
    public ApplicationParameterImpl[] getParams() {
        return this.params;
    }

    public void setParams(ApplicationParameterImpl[] params) {
        this.params = params;
    }

    public ApplicationParameterValue[] getParamsValues() throws ClassNotFoundException {
        int paramsCount = this.params.length;
        ApplicationParameterValue[] paramValues = new ApplicationParameterValue[paramsCount];
        for (ApplicationParameterImpl param : this.params) {
            int paramIdx = param.getParamId();
            paramValues[paramIdx] = param.getValue();
        }
        return paramValues;
    }

    public Object[] getParamsValuesContent() throws Exception {
        int paramsCount = this.params.length;
        Object[] paramValues = new Object[paramsCount];
        for (ApplicationParameterImpl param : this.params) {
            int paramIdx = param.getParamId();
            paramValues[paramIdx] = param.getValue().getContent();
        }
        return paramValues;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StartApplication ").append(this.className).append(".").append(this.methodName).append("(");
        int count = 0;
        for (ApplicationParameterImpl param : this.params) {
            if (count > 0) {
                sb.append(", ");
            }
            ++count;
            if (param.getValue() instanceof ApplicationParameterValue.ArrayParameter) {
                sb.append((Object)param.getType());
                continue;
            }
            sb.append((Object)param.getType());
        }
        sb.append(") defined in CEI ").append(this.ceiClass);
        return sb.toString();
    }

    public void setOrchestrator(String host, Orchestrator.HttpMethod method, String operation) {
        this.orchestrator = new Orchestrator(host, method, operation);
    }

    public void setOrchestrator(Orchestrator orchestrator) {
        this.orchestrator = orchestrator;
    }

    public Orchestrator getOrchestrator() {
        return this.orchestrator;
    }
}

