/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CommutativeIdentifier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.ExternalStreamParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.parameter.StreamParameter;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.WaitForConcurrentRequest;
import es.bsc.compss.types.request.ap.WaitForTaskRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class TaskAnalyser {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String TASK_FAILED = "Task failed: ";
    private static final String TASK_CANCELED = "Task canceled: ";
    private DataInfoProvider dip;
    private GraphGenerator gm;
    private TreeMap<Integer, WritersInfo> writers;
    private HashMap<Integer, Integer> currentTaskCount = new HashMap();
    private HashMap<Long, Integer> appIdToTotalTaskCount;
    private HashMap<Long, Integer> appIdToTaskCount;
    private HashMap<Long, Semaphore> appIdToSemaphore;
    private HashSet<Long> appIdBarrierFlags;
    private HashMap<Long, TreeSet<Integer>> appIdToWrittenFiles;
    private HashMap<Long, TreeSet<Integer>> appIdToSCOWrittenIds;
    private Hashtable<AbstractTask, List<Semaphore>> waitedTasks;
    private TreeMap<Integer, List<Task>> concurrentAccessMap;
    private TreeMap<String, CommutativeGroupTask> commutativeGroup;
    private TreeMap<String, LinkedList<Task>> pendingToDrawCommutative;
    private static final boolean IS_DRAW_GRAPH = GraphGenerator.isEnabled();
    private int synchronizationId = 0;
    private boolean taskDetectedAfterSync = false;

    public TaskAnalyser() {
        this.writers = new TreeMap();
        this.appIdToTaskCount = new HashMap();
        this.appIdToTotalTaskCount = new HashMap();
        this.appIdToSemaphore = new HashMap();
        this.appIdBarrierFlags = new HashSet();
        this.appIdToWrittenFiles = new HashMap();
        this.appIdToSCOWrittenIds = new HashMap();
        this.waitedTasks = new Hashtable();
        this.concurrentAccessMap = new TreeMap();
        this.commutativeGroup = new TreeMap();
        this.pendingToDrawCommutative = new TreeMap();
        LOGGER.info("Initialization finished");
    }

    public void setCoWorkers(DataInfoProvider dip) {
        this.dip = dip;
    }

    public void setGM(GraphGenerator gm) {
        this.gm = gm;
    }

    private DataAccessId registerParameterAccessAndAddDependencies(Task currentTask, boolean isConstraining, Parameter p) {
        AccessParams.AccessMode am = AccessParams.AccessMode.R;
        switch (p.getDirection()) {
            case IN: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        DataAccessId firstRegistered = null;
        DataAccessId daId = null;
        int coreId = 0;
        switch (p.getType()) {
            case FILE_T: {
                FileParameter fp = (FileParameter)p;
                daId = this.dip.registerFileAccess(am, fp.getLocation());
                break;
            }
            case PSCO_T: {
                ObjectParameter pscop = (ObjectParameter)p;
                pscop.setType(DataType.PSCO_T);
                daId = this.dip.registerObjectAccess(am, pscop.getValue(), pscop.getCode());
                break;
            }
            case EXTERNAL_PSCO_T: {
                ExternalPSCOParameter externalPSCOparam = (ExternalPSCOParameter)p;
                externalPSCOparam.setType(DataType.EXTERNAL_PSCO_T);
                daId = this.dip.registerExternalPSCOAccess(am, externalPSCOparam.getId(), externalPSCOparam.getCode());
                break;
            }
            case BINDING_OBJECT_T: {
                BindingObjectParameter bindingObjectparam = (BindingObjectParameter)p;
                bindingObjectparam.setType(DataType.BINDING_OBJECT_T);
                daId = this.dip.registerBindingObjectAccess(am, bindingObjectparam.getBindingObject(), bindingObjectparam.getCode());
                break;
            }
            case OBJECT_T: {
                ObjectParameter op = (ObjectParameter)p;
                if (op.getValue() instanceof StubItf && ((StubItf)op.getValue()).getID() != null) {
                    op.setType(DataType.PSCO_T);
                }
                daId = this.dip.registerObjectAccess(am, op.getValue(), op.getCode());
                break;
            }
            case STREAM_T: {
                StreamParameter sp = (StreamParameter)p;
                daId = this.dip.registerStreamAccess(am, sp.getValue(), sp.getCode());
                break;
            }
            case EXTERNAL_STREAM_T: {
                ExternalStreamParameter esp = (ExternalStreamParameter)p;
                daId = this.dip.registerExternalStreamAccess(am, esp.getLocation());
                break;
            }
            case COLLECTION_T: {
                CollectionParameter cp = (CollectionParameter)p;
                for (Parameter content : cp.getParameters()) {
                    this.registerParameterAccessAndAddDependencies(currentTask, isConstraining, content);
                }
                daId = this.dip.registerCollectionAccess(am, cp);
                break;
            }
            default: {
                return null;
            }
        }
        if (am == AccessParams.AccessMode.CV) {
            coreId = currentTask.getTaskDescription().getCoreId();
            CommutativeIdentifier comId = new CommutativeIdentifier(coreId, daId.getDataId());
            CommutativeGroupTask com = null;
            for (CommutativeGroupTask cgt : this.commutativeGroup.values()) {
                if (cgt.getCommutativeIdentifier().compareTo(comId) != 1) continue;
                com = cgt;
            }
            if (com == null) {
                firstRegistered = daId;
                LOGGER.debug("The FIRST registered daId in the commutative group " + comId.toString() + " is " + daId);
            } else {
                com.addVersionToList(daId);
                daId = com.getRegisteredVersion();
                LOGGER.debug("Registering daId " + daId + " in commutative group " + comId.toString());
            }
        }
        DependencyParameter dp = (DependencyParameter)p;
        dp.setDataAccessId(daId);
        this.addDependencies(am, currentTask, isConstraining, dp, firstRegistered, coreId);
        return daId;
    }

    private void addDependencies(AccessParams.AccessMode am, Task currentTask, boolean isConstraining, DependencyParameter dp, DataAccessId firstRegistered, int coreId) {
        DataAccessId daId = dp.getDataAccessId();
        block0 : switch (am) {
            case R: {
                WritersInfo wi;
                RAccessId raId;
                DataInstanceId dependingDataId;
                if (!this.dataWasAccessedConcurrent(daId.getDataId())) {
                    this.checkDependencyForRead(currentTask, dp);
                } else {
                    this.checkDependencyForConcurrent(currentTask, dp);
                }
                if (!isConstraining || (dependingDataId = (raId = (RAccessId)dp.getDataAccessId()).getReadDataInstance()) == null || dependingDataId.getVersionId() <= 1 || (wi = this.writers.get(dependingDataId.getDataId())) == null) break;
                switch (wi.getDataType()) {
                    case STREAM_T: 
                    case EXTERNAL_STREAM_T: {
                        List<AbstractTask> lastWriters = wi.getStreamWriters();
                        if (lastWriters.isEmpty()) break block0;
                        currentTask.setEnforcingTask((Task)lastWriters.get(0));
                        break block0;
                    }
                    default: {
                        AbstractTask lastWriter = wi.getDataWriter();
                        if (lastWriter == null) break block0;
                        currentTask.setEnforcingTask((Task)lastWriter);
                    }
                }
                break;
            }
            case RW: {
                WritersInfo wi;
                RWAccessId raId;
                DataInstanceId dependingDataId;
                if (!this.dataWasAccessedConcurrent(daId.getDataId())) {
                    this.checkDependencyForRead(currentTask, dp);
                } else {
                    this.checkDependencyForConcurrent(currentTask, dp);
                    this.removeFromConcurrentAccess(dp.getDataAccessId().getDataId());
                }
                if (isConstraining && (dependingDataId = (raId = (RWAccessId)dp.getDataAccessId()).getReadDataInstance()) != null && dependingDataId.getVersionId() > 1 && (wi = this.writers.get(dependingDataId.getDataId())) != null) {
                    switch (wi.getDataType()) {
                        case STREAM_T: {
                            List<AbstractTask> lastWriters = wi.getStreamWriters();
                            if (lastWriters.isEmpty()) break;
                            currentTask.setEnforcingTask((Task)lastWriters.get(0));
                            break;
                        }
                        default: {
                            AbstractTask lastWriter = wi.getDataWriter();
                            if (lastWriter == null) break;
                            currentTask.setEnforcingTask((Task)lastWriter);
                        }
                    }
                }
                this.registerOutputValues(currentTask, dp);
                break;
            }
            case W: {
                if (this.dataWasAccessedConcurrent(daId.getDataId())) {
                    this.removeFromConcurrentAccess(dp.getDataAccessId().getDataId());
                }
                this.registerOutputValues(currentTask, dp);
                break;
            }
            case C: {
                this.checkDependencyForRead(currentTask, dp);
                List<Task> tasks = this.concurrentAccessMap.get(daId.getDataId());
                if (tasks == null) {
                    tasks = new LinkedList<Task>();
                    this.concurrentAccessMap.put(daId.getDataId(), tasks);
                }
                tasks.add(currentTask);
                break;
            }
            case CV: {
                CommutativeIdentifier comId = new CommutativeIdentifier(coreId, daId.getDataId());
                CommutativeGroupTask com = null;
                LinkedList<Task> pendingToDraw = null;
                for (CommutativeGroupTask cgt : this.commutativeGroup.values()) {
                    if (cgt.getCommutativeIdentifier().compareTo(comId) != 1) continue;
                    com = cgt;
                    if (!IS_DRAW_GRAPH) continue;
                    pendingToDraw = this.pendingToDrawCommutative.get(comId.toString());
                }
                if (IS_DRAW_GRAPH) {
                    if (pendingToDraw == null) {
                        pendingToDraw = new LinkedList<Task>();
                    }
                    pendingToDraw.add(currentTask);
                    this.pendingToDrawCommutative.put(comId.toString(), pendingToDraw);
                }
                if (com == null) {
                    WritersInfo wi;
                    LOGGER.info("Creating a new commutative group " + comId);
                    com = new CommutativeGroupTask(currentTask.getAppId(), comId);
                    if (IS_DRAW_GRAPH) {
                        LOGGER.debug("Checking if previous group in graph");
                        this.checkIfPreviousGroupInGraph(daId.getDataId(), currentTask);
                    }
                    if ((wi = this.writers.get(daId.getDataId())) != null) {
                        AbstractTask predecessor = wi.getDataWriter();
                        com.setParentDataDependency(predecessor);
                        LOGGER.debug("Setting parent data dependency");
                    }
                    this.commutativeGroup.put(comId.toString(), com);
                    com.setRegisteredVersion(firstRegistered);
                    this.registerOutputValues(com, dp);
                }
                com.setFinalVersion(((RWAccessId)daId).getWVersionId());
                this.checkDependencyForCommutative(currentTask, dp, com);
                this.registerOutputValues(com, dp);
            }
        }
    }

    public void processTask(Task currentTask) {
        Integer methodId;
        Integer actualCount;
        TaskDescription params = currentTask.getTaskDescription();
        LOGGER.info("New " + (params.getType() == TaskType.METHOD ? "method" : "service") + " task(" + params.getName() + "), ID = " + currentTask.getId());
        if (IS_DRAW_GRAPH) {
            this.addNewTask(currentTask);
        }
        if ((actualCount = this.currentTaskCount.get(methodId = params.getCoreId())) == null) {
            actualCount = 0;
        }
        this.currentTaskCount.put(methodId, actualCount + 1);
        Long appId = currentTask.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId);
        if (taskCount == null) {
            taskCount = 0;
        }
        Integer n = taskCount;
        Integer n2 = taskCount = Integer.valueOf(taskCount + 1);
        this.appIdToTaskCount.put(appId, taskCount);
        Integer totalTaskCount = this.appIdToTotalTaskCount.get(appId);
        if (totalTaskCount == null) {
            totalTaskCount = 0;
        }
        n2 = totalTaskCount;
        Integer n3 = totalTaskCount = Integer.valueOf(totalTaskCount + 1);
        this.appIdToTotalTaskCount.put(appId, totalTaskCount);
        int constrainingParam = -1;
        if (params.getType() == TaskType.SERVICE && params.hasTargetObject()) {
            constrainingParam = params.getParameters().size() - 1 - params.getNumReturns();
        }
        List<Parameter> parameters = params.getParameters();
        for (int paramIdx = 0; paramIdx < parameters.size(); ++paramIdx) {
            this.registerParameterAccessAndAddDependencies(currentTask, paramIdx == constrainingParam, parameters.get(paramIdx));
        }
    }

    private void updateParameterAccess(Task t, Parameter p) {
        DataType type = p.getType();
        if (type == DataType.COLLECTION_T) {
            for (Parameter subParam : ((CollectionParameter)p).getParameters()) {
                this.updateParameterAccess(t, subParam);
            }
        }
        if (type == DataType.FILE_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.STREAM_T || type == DataType.EXTERNAL_STREAM_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T || type == DataType.COLLECTION_T) {
            DependencyParameter dPar = (DependencyParameter)p;
            DataAccessId dAccId = dPar.getDataAccessId();
            if (DEBUG) {
                LOGGER.debug("Treating that data " + dAccId + " has been accessed at " + dPar.getDataTarget());
            }
            if (t.getOnFailure() == OnFailure.CANCEL_SUCCESSORS && (t.getStatus() == TaskState.FAILED || t.getStatus() == TaskState.CANCELED)) {
                this.dip.dataAccessHasBeenCanceled(dAccId);
            } else {
                this.dip.dataHasBeenAccessed(dAccId);
            }
        }
    }

    public void endTask(AbstractTask task) {
        if (task instanceof Task) {
            List<Semaphore> sems;
            int taskId = task.getId();
            boolean isFree = ((Task)task).isFree();
            TaskState taskState = task.getStatus();
            OnFailure onFailure = ((Task)task).getOnFailure();
            LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
            if (!isFree) {
                LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
                return;
            }
            TaskMonitor registeredMonitor = ((Task)task).getTaskMonitor();
            switch (taskState) {
                case FAILED: {
                    registeredMonitor.onFailure();
                    if (onFailure == OnFailure.RETRY || onFailure == OnFailure.FAIL) {
                        ErrorManager.error(TASK_FAILED + task);
                        return;
                    }
                    if (onFailure != OnFailure.IGNORE && onFailure != OnFailure.CANCEL_SUCCESSORS) break;
                    ErrorManager.warn(TASK_FAILED + task);
                    break;
                }
                case CANCELED: {
                    registeredMonitor.onCancellation();
                    ErrorManager.warn(TASK_CANCELED + task);
                    break;
                }
                default: {
                    registeredMonitor.onCompletion();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Freeing barriers for task " + taskId);
                LOGGER.debug("Ending task " + taskId);
            }
            Long appId = task.getAppId();
            Integer taskCount = this.appIdToTaskCount.get(appId) - 1;
            this.appIdToTaskCount.put(appId, taskCount);
            if (taskCount == 0) {
                this.appIdBarrierFlags.remove(appId);
                Semaphore sem = this.appIdToSemaphore.remove(appId);
                if (sem != null) {
                    this.appIdToTaskCount.remove(appId);
                    sem.release();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Releasing waiting tasks for task " + taskId);
            }
            if ((sems = this.waitedTasks.remove(task)) != null) {
                for (Semaphore sem : sems) {
                    sem.release();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Marking accessed parameters for task " + taskId);
            }
            for (Parameter param : ((Task)task).getTaskDescription().getParameters()) {
                this.updateParameterAccess((Task)task, param);
            }
            if (DEBUG) {
                LOGGER.debug("Checking result file transfers for task " + taskId);
            }
            if (this.appIdToSemaphore.get(appId) != null && !this.appIdBarrierFlags.contains(appId)) {
                this.checkResultFileTransfer((Task)task);
            }
            if (DEBUG) {
                LOGGER.debug("Releasing data dependant tasks for task " + taskId);
            }
            this.releaseCommutativeGroups(task);
        }
        task.releaseDataDependents();
    }

    private void releaseCommutativeGroups(AbstractTask task) {
        if (!((Task)task).getCommutativeGroupList().isEmpty()) {
            for (CommutativeGroupTask group2 : ((Task)task).getCommutativeGroupList()) {
                group2.setStatus(TaskState.FINISHED);
                group2.removePredecessor((Task)task);
                if (!group2.getPredecessors().isEmpty()) continue;
                group2.releaseDataDependents();
                List<Semaphore> sems = this.waitedTasks.remove(group2);
                if (sems != null) {
                    for (Semaphore sem : sems) {
                        sem.release();
                    }
                }
                if (!DEBUG) continue;
                LOGGER.debug("Group " + group2.getId() + " ended execution");
                LOGGER.debug("Data dependents of group " + group2.getCommutativeIdentifier() + " released ");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkResultFileTransfer(Task t) {
        LinkedList<DataInstanceId> fileIds = new LinkedList<DataInstanceId>();
        block14: for (Parameter p : t.getTaskDescription().getParameters()) {
            switch (p.getType()) {
                case FILE_T: {
                    FileParameter fp = (FileParameter)p;
                    switch (fp.getDirection()) {
                        case IN: 
                        case CONCURRENT: {
                            continue block14;
                        }
                        case INOUT: 
                        case COMMUTATIVE: {
                            DataInstanceId dId = ((RWAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            WritersInfo wi = this.writers.get(dId.getDataId());
                            if (wi == null) break;
                            switch (wi.getDataType()) {
                                case STREAM_T: 
                                case EXTERNAL_STREAM_T: {
                                    continue block14;
                                }
                            }
                            AbstractTask lastWriter = wi.getDataWriter();
                            if (lastWriter == null || lastWriter != t) continue block14;
                            fileIds.add(dId);
                            continue block14;
                        }
                        case OUT: {
                            DataInstanceId dId = ((WAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            WritersInfo wi = this.writers.get(dId.getDataId());
                            if (wi == null) break;
                            switch (wi.getDataType()) {
                                case STREAM_T: {
                                    continue block14;
                                }
                            }
                            AbstractTask lastWriter = wi.getDataWriter();
                            if (lastWriter == null || lastWriter != t) break;
                            fileIds.add(dId);
                        }
                    }
                    continue block14;
                }
            }
        }
        int numFT = fileIds.size();
        if (numFT > 0) {
            if (DEBUG) {
                LOGGER.debug("Ordering transfers for result files of task " + t.getId());
            }
            for (DataInstanceId fileId : fileIds) {
                int id = fileId.getDataId();
                if (DEBUG) {
                    LOGGER.debug("- Requesting result file " + id + " because of task " + t.getId());
                }
                this.dip.blockDataAndGetResultFile(id, new ResultListener(new Semaphore(0)));
                this.dip.unblockDataId(id);
            }
        }
    }

    public void findWaitedTask(WaitForTaskRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        Semaphore sem = request.getSemaphore();
        WritersInfo wi = this.writers.get(dataId);
        if (wi != null) {
            switch (wi.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    List<AbstractTask> lastStreamWriters = wi.getStreamWriters();
                    for (AbstractTask lastWriter : lastStreamWriters) {
                        this.treatDataAccess(lastWriter, am, dataId);
                    }
                    sem.release();
                    break;
                }
                default: {
                    AbstractTask lastWriter = wi.getDataWriter();
                    if (lastWriter != null) {
                        this.treatDataAccess(lastWriter, am, dataId);
                    }
                    if (lastWriter == null || lastWriter.getStatus() == TaskState.FINISHED) {
                        sem.release();
                        break;
                    }
                    List<Semaphore> list = this.waitedTasks.get(lastWriter);
                    if (list == null) {
                        list = new LinkedList<Semaphore>();
                    }
                    list.add(sem);
                    this.waitedTasks.put(lastWriter, list);
                    break;
                }
            }
        } else {
            sem.release();
        }
    }

    private void treatDataAccess(AbstractTask lastWriter, AccessParams.AccessMode am, int dataId) {
        if (am == AccessParams.AccessMode.RW) {
            WritersInfo wi = this.writers.get(dataId);
            if (wi != null) {
                switch (wi.getDataType()) {
                    case STREAM_T: 
                    case EXTERNAL_STREAM_T: {
                        break;
                    }
                    default: {
                        this.writers.put(dataId, null);
                        break;
                    }
                }
            } else {
                this.writers.put(dataId, null);
            }
        }
        if (IS_DRAW_GRAPH) {
            TreeSet<Integer> toPass = new TreeSet<Integer>();
            toPass.add(dataId);
            DataInstanceId dii = this.dip.getLastVersions(toPass).get(0);
            int dataVersion = dii.getVersionId();
            this.addEdgeFromTaskToMain(lastWriter, EdgeType.DATA_DEPENDENCY, dataId, dataVersion);
        }
    }

    public boolean dataWasAccessedConcurrent(int daId) {
        List<Task> concurrentAccess = this.concurrentAccessMap.get(daId);
        return concurrentAccess != null;
    }

    public void findWaitedConcurrent(WaitForConcurrentRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        List<Task> concurrentAccess = this.concurrentAccessMap.get(dataId);
        if (concurrentAccess != null) {
            this.concurrentAccessMap.put(dataId, null);
        }
        Semaphore semTasks = request.getTaskSemaphore();
        int n = 0;
        for (Task task : concurrentAccess) {
            this.treatDataAccess(task, am, dataId);
            if (task.getStatus() == TaskState.FINISHED) continue;
            ++n;
            List<Semaphore> list = this.waitedTasks.get(task);
            if (list == null) {
                list = new LinkedList<Semaphore>();
            }
            list.add(semTasks);
            this.waitedTasks.put(task, list);
        }
        request.setNumWaitedTasks(n);
        request.getSemaphore().release();
    }

    public void barrier(BarrierRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.addNewBarrier();
            this.gm.commitGraph();
        }
        if (count == null || count == 0) {
            request.getSemaphore().release();
        } else {
            this.appIdBarrierFlags.add(appId);
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public void noMoreTasks(EndOfAppRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.gm.commitGraph();
        }
        if (count == null || count == 0) {
            this.appIdToTaskCount.remove(appId);
            request.getSemaphore().release();
        } else {
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public TreeSet<Integer> getAndRemoveWrittenFiles(Long appId) {
        return this.appIdToWrittenFiles.remove(appId);
    }

    public void shutdown() {
        if (IS_DRAW_GRAPH) {
            GraphGenerator.removeTemporaryGraph();
        }
    }

    private void addMissingCommutativeTasksToGraph() {
        LinkedList<String> identifiers = new LinkedList<String>();
        for (String identifier : this.pendingToDrawCommutative.keySet()) {
            this.addCommutativeGroupTaskToGraph(identifier);
            identifiers.add(identifier);
        }
        for (String identifier : identifiers) {
            this.pendingToDrawCommutative.remove(identifier);
        }
    }

    public String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t").append("<TasksInfo>").append("\n");
        for (Map.Entry<Long, Integer> e : this.appIdToTotalTaskCount.entrySet()) {
            Long appId = e.getKey();
            Integer totalTaskCount = e.getValue();
            Integer taskCount = this.appIdToTaskCount.get(appId);
            if (taskCount == null) {
                taskCount = 0;
            }
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t").append("<Application id=\"").append(appId).append("\">").append("\n");
            sb.append("\t\t\t").append("<TotalCount>").append(totalTaskCount).append("</TotalCount>").append("\n");
            sb.append("\t\t\t").append("<InProgress>").append(taskCount).append("</InProgress>").append("\n");
            sb.append("\t\t\t").append("<Completed>").append(completed).append("</Completed>").append("\n");
            sb.append("\t\t").append("</Application>").append("\n");
        }
        sb.append("\t").append("</TasksInfo>").append("\n");
        return sb.toString();
    }

    public void deleteData(DataInfo dataInfo) {
        int dataId = dataInfo.getDataId();
        LOGGER.debug("Deleting data with id " + dataId);
        WritersInfo wi = this.writers.remove(dataId);
        if (wi != null) {
            switch (wi.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    break;
                }
                default: {
                    AbstractTask task = wi.getDataWriter();
                    if (task != null) {
                        return;
                    }
                    LOGGER.debug("Removing " + dataInfo.getDataId() + " from written files");
                    for (TreeSet<Integer> files : this.appIdToWrittenFiles.values()) {
                        files.remove(dataInfo.getDataId());
                    }
                }
            }
        }
    }

    public void removeFromConcurrentAccess(int dataId) {
        List<Task> returnedValue = this.concurrentAccessMap.remove(dataId);
        if (returnedValue == null) {
            LOGGER.debug("The concurrent list could not be removed");
        }
    }

    private void checkDependencyForRead(Task currentTask, DependencyParameter dp) {
        WritersInfo wi;
        int dataId = dp.getDataAccessId().getDataId();
        if (DEBUG) {
            LOGGER.debug("Checking READ dependency for datum " + dataId + " and task " + currentTask.getId());
        }
        if ((wi = this.writers.get(dataId)) != null) {
            switch (wi.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    this.addStreamDependency(currentTask, dp, wi);
                    break;
                }
                default: {
                    this.addRegularDependency(currentTask, dp, wi);
                    break;
                }
            }
        } else if (DEBUG) {
            LOGGER.debug("There is no last writer for datum " + dataId);
        }
    }

    private void addStreamDependency(Task currentTask, DependencyParameter dp, WritersInfo wi) {
        int dataId = dp.getDataAccessId().getDataId();
        List<AbstractTask> lastStreamWriters = wi.getStreamWriters();
        if (!lastStreamWriters.isEmpty()) {
            if (DEBUG) {
                StringBuilder sb = new StringBuilder();
                if (lastStreamWriters.size() > 1) {
                    sb.append("Last writers for stream datum ");
                    sb.append(dataId);
                    sb.append(" are tasks ");
                } else {
                    sb.append("Last writer for stream datum ");
                    sb.append(dataId);
                    sb.append(" is task ");
                }
                for (AbstractTask lastWriter : lastStreamWriters) {
                    sb.append(lastWriter.getId());
                    sb.append(" ");
                }
                LOGGER.debug(sb.toString());
            }
            for (AbstractTask lastWriter : lastStreamWriters) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream dependency between task " + lastWriter.getId() + " and task " + currentTask.getId());
                }
                currentTask.addStreamDataDependency(lastWriter);
                if (!IS_DRAW_GRAPH) continue;
                this.drawEdges(currentTask, dp, lastWriter);
                this.checkIfPreviousGroupInGraph(dataId, currentTask);
            }
        } else if (DEBUG) {
            LOGGER.debug("There is no last stream writer for datum " + dataId);
        }
    }

    private void addRegularDependency(Task currentTask, DependencyParameter dp, WritersInfo wi) {
        int dataId = dp.getDataAccessId().getDataId();
        AbstractTask lastWriter = wi.getDataWriter();
        if (lastWriter != null && lastWriter != currentTask) {
            if (DEBUG) {
                LOGGER.debug("Last writer for datum " + dataId + " is task " + lastWriter.getId());
                LOGGER.debug("Adding dependency between task " + lastWriter.getId() + " and task " + currentTask.getId());
            }
            if (lastWriter instanceof Task && ((Task)lastWriter).getCommutativeGroup(dp.getDataAccessId().getDataId()) != null) {
                currentTask.addDataDependency(((Task)lastWriter).getCommutativeGroup(dp.getDataAccessId().getDataId()));
            }
            currentTask.addDataDependency(lastWriter);
        } else if (DEBUG) {
            LOGGER.debug("There is no last writer for datum " + dataId);
        }
        if (IS_DRAW_GRAPH) {
            this.drawEdges(currentTask, dp, lastWriter);
            this.checkIfPreviousGroupInGraph(dataId, currentTask);
        }
    }

    private void checkDependencyForCommutative(Task currentTask, DependencyParameter dp, CommutativeGroupTask commutativeGroup) {
        AbstractTask t = commutativeGroup.getParentDataDependency();
        if (t != null) {
            LOGGER.debug("Adding dependency with parent task of commutative group");
            currentTask.addDataDependency(t);
        }
        if (IS_DRAW_GRAPH) {
            this.drawEdges(currentTask, dp, t);
        }
        commutativeGroup.addDataDependency(currentTask);
        commutativeGroup.addCommutativeTask(currentTask);
        currentTask.setCommutativeGroup(commutativeGroup, dp.getDataAccessId());
    }

    private void drawEdges(Task currentTask, DependencyParameter dp, AbstractTask lastWriter) {
        int dataVersion;
        int dataId = dp.getDataAccessId().getDataId();
        DataAccessId.Direction d = dp.getDataAccessId().getDirection();
        switch (d) {
            case C: 
            case R: {
                dataVersion = ((RAccessId)dp.getDataAccessId()).getRVersionId();
                break;
            }
            case W: {
                dataVersion = ((WAccessId)dp.getDataAccessId()).getWVersionId();
                break;
            }
            default: {
                dataVersion = ((RWAccessId)dp.getDataAccessId()).getRVersionId();
            }
        }
        switch (dp.getType()) {
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                this.addStreamEdgeFromTaskToTask(lastWriter, currentTask, dataId, dataVersion);
                break;
            }
            default: {
                if (lastWriter != null && lastWriter != currentTask) {
                    if (lastWriter instanceof Task) {
                        if (lastWriter.getSuccessors().contains(currentTask.getCommutativeGroup(dataId))) {
                            this.addEdgeFromCommutativeToTask(currentTask, dataId, dataVersion, (CommutativeGroupTask)lastWriter, false);
                            break;
                        }
                        this.addDataEdgeFromTaskToTask((Task)lastWriter, currentTask, dataId, dataVersion);
                        break;
                    }
                    if (lastWriter instanceof Task && !currentTask.hasCommutativeParams()) break;
                    this.addEdgeFromCommutativeToTask(currentTask, dataId, dataVersion, (CommutativeGroupTask)lastWriter, true);
                    break;
                }
                this.addDataEdgeFromMainToTask(currentTask, dataId, dataVersion);
            }
        }
    }

    private void checkDependencyForConcurrent(Task currentTask, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        List<Task> tasks = this.concurrentAccessMap.get(dataId);
        if (this.concurrentAccessMap != null && !tasks.contains(currentTask)) {
            if (DEBUG) {
                LOGGER.debug("There was a concurrent access for datum " + dataId);
                LOGGER.debug("Adding dependency between list and task " + currentTask.getId());
            }
            for (Task t : tasks) {
                currentTask.addDataDependency(t);
                if (!IS_DRAW_GRAPH) continue;
                this.drawEdges(currentTask, dp, t);
            }
        } else if (DEBUG) {
            LOGGER.debug("There is no last writer for datum " + dataId);
        }
    }

    private void registerOutputValues(AbstractTask currentTask, DependencyParameter dp) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Long appId = currentTask.getAppId();
        if (DEBUG) {
            LOGGER.debug("Checking WRITE dependency for datum " + dataId + " and task " + currentTaskId);
        }
        switch (dp.getType()) {
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                WritersInfo wi = this.writers.get(dataId);
                if (wi != null) {
                    wi.addStreamWriter(currentTask);
                } else {
                    wi = new WritersInfo(dp.getType(), Arrays.asList(currentTask));
                }
                this.writers.put(dataId, wi);
                break;
            }
            default: {
                WritersInfo newWi = new WritersInfo(dp.getType(), currentTask);
                this.writers.put(dataId, newWi);
            }
        }
        switch (dp.getType()) {
            case FILE_T: {
                TreeSet<Integer> fileIdsWritten = this.appIdToWrittenFiles.get(appId);
                if (fileIdsWritten == null) {
                    fileIdsWritten = new TreeSet();
                    this.appIdToWrittenFiles.put(appId, fileIdsWritten);
                }
                fileIdsWritten.add(dataId);
                break;
            }
            case PSCO_T: {
                TreeSet<Integer> pscoIdsWritten = this.appIdToSCOWrittenIds.get(appId);
                if (pscoIdsWritten == null) {
                    pscoIdsWritten = new TreeSet();
                    this.appIdToSCOWrittenIds.put(appId, pscoIdsWritten);
                }
                pscoIdsWritten.add(dataId);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dataId + " is task " + currentTaskId);
        }
    }

    private void addNewTask(Task task) {
        if (!task.hasCommutativeParams()) {
            this.addTaskToGraph(task);
        }
        task.setSynchronizationId(this.synchronizationId);
        this.taskDetectedAfterSync = true;
    }

    private void addTaskToGraph(Task task) {
        this.gm.addTaskToGraph(task);
    }

    private void addCommutativeGroupTaskToGraph(String identifier) {
        LOGGER.debug("Adding commutative group to graph");
        this.gm.addCommutativeGroupToGraph(identifier);
        for (Task t : this.pendingToDrawCommutative.get(identifier)) {
            this.addTaskToGraph(t);
        }
        this.gm.closeGroupInGraph();
    }

    private void checkIfPreviousGroupInGraph(int dataId, Task currentTask) {
        AbstractTask lastWriter;
        WritersInfo wi = this.writers.get(dataId);
        if (wi != null && (lastWriter = wi.getDataWriter()) instanceof CommutativeGroupTask && !((CommutativeGroupTask)lastWriter).getGraphDrawn()) {
            CommutativeIdentifier comId = ((CommutativeGroupTask)lastWriter).getCommutativeIdentifier();
            this.addCommutativeGroupTaskToGraph(comId.toString());
            ((CommutativeGroupTask)lastWriter).setGraphDrawn();
            this.pendingToDrawCommutative.remove(((CommutativeGroupTask)lastWriter).getCommutativeIdentifier().toString());
        }
    }

    private void addDataEdgeFromTaskToTask(Task source, Task dest, int dataId, int dataVersion) {
        if (source.getSynchronizationId() == dest.getSynchronizationId()) {
            String src = String.valueOf(source.getId());
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        } else {
            String src = "Synchro" + dest.getSynchronizationId();
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        }
    }

    private void addStreamEdgeFromTaskToTask(AbstractTask lastWriter, Task dest, int dataId, int dataVersion) {
        String src = String.valueOf(lastWriter.getId());
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        this.gm.addEdgeToGraph(src, dst, EdgeType.STREAM_DEPENDENCY, dep);
    }

    private void addDataEdgeFromMainToTask(Task dest, int dataId, int dataVersion) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    private void addEdgeFromTaskToMain(AbstractTask task, EdgeType edgeType, int dataId, int dataVersion) {
        String src;
        if (this.taskDetectedAfterSync) {
            this.taskDetectedAfterSync = false;
            int oldSyncId = this.synchronizationId++;
            this.gm.addSynchroToGraph(this.synchronizationId);
            if (this.synchronizationId > 1) {
                String oldSync = "Synchro" + oldSyncId;
                String currentSync = "Synchro" + this.synchronizationId;
                this.gm.addEdgeToGraph(oldSync, currentSync, edgeType, "");
            }
        }
        String dest = "Synchro" + this.synchronizationId;
        if (task instanceof CommutativeGroupTask && !((CommutativeGroupTask)task).getCommutativeTasks().isEmpty()) {
            src = String.valueOf(((CommutativeGroupTask)task).getCommutativeTasks().get(0).getId());
            this.gm.addEdgeToGraphFromCommutative(src, dest, String.valueOf(dataId) + "v" + String.valueOf(dataVersion), ((CommutativeGroupTask)task).getCommutativeIdentifier().toString());
        } else {
            src = String.valueOf(task.getId());
            this.gm.addEdgeToGraph(src, dest, edgeType, String.valueOf(dataId) + "v" + String.valueOf(dataVersion));
        }
    }

    private void addEdgeFromCommutativeToTask(Task dest, int dataId, int dataVersion, CommutativeGroupTask cgt, boolean comToTask) {
        String src = String.valueOf(cgt.getCommutativeTasks().get(0).getId());
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        String comId = cgt.getCommutativeIdentifier().toString();
        if (comToTask) {
            this.gm.addEdgeToGraphFromCommutative(src, dst, dep, comId);
        } else {
            this.gm.addEdgeToGraphFromCommutative(dst, src, dep, comId);
        }
    }

    private void addNewBarrier() {
        int oldSync = this.synchronizationId++;
        String oldSyncStr = "Synchro" + oldSync;
        this.taskDetectedAfterSync = false;
        this.gm.addBarrierToGraph(this.synchronizationId);
        String newSyncStr = "Synchro" + this.synchronizationId;
        if (this.synchronizationId > 1) {
            this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        }
        HashSet<AbstractTask> uniqueWriters = new HashSet<AbstractTask>();
        for (WritersInfo wi : this.writers.values()) {
            if (wi == null) continue;
            AbstractTask dataWriter = wi.getDataWriter();
            if (dataWriter != null) {
                uniqueWriters.add(dataWriter);
            }
            uniqueWriters.addAll(wi.getStreamWriters());
        }
        for (AbstractTask writer : uniqueWriters) {
            if (writer == null || writer.getSynchronizationId() != oldSync) continue;
            String taskId = String.valueOf(writer.getId());
            this.gm.addEdgeToGraph(taskId, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        }
    }

    private static class WritersInfo {
        private final DataType dataType;
        private final AbstractTask dataWriter;
        private final List<AbstractTask> streamWriters;

        public WritersInfo(DataType dataType, AbstractTask dataWriter) {
            this.dataType = dataType;
            this.dataWriter = dataWriter;
            this.streamWriters = new ArrayList<AbstractTask>();
        }

        public WritersInfo(DataType dataType, List<AbstractTask> streamWriters) {
            this.dataType = dataType;
            this.dataWriter = null;
            this.streamWriters = new ArrayList<AbstractTask>();
            if (streamWriters != null) {
                this.streamWriters.addAll(streamWriters);
            }
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public AbstractTask getDataWriter() {
            return this.dataWriter;
        }

        public List<AbstractTask> getStreamWriters() {
            return this.streamWriters;
        }

        public void addStreamWriter(AbstractTask writerTask) {
            if (writerTask != null) {
                this.streamWriters.add(writerTask);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("WI [ ");
            sb.append("dataType = ").append((Object)this.dataType).append(", ");
            sb.append("dataWriter = ").append(this.dataWriter != null ? Integer.valueOf(this.dataWriter.getId()) : "null").append(", ");
            sb.append("streamWriters = [");
            for (AbstractTask t : this.streamWriters) {
                sb.append(t.getId()).append(" ");
            }
            sb.append("]");
            sb.append("]");
            return sb.toString();
        }
    }
}

