/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external;

import es.bsc.compss.executor.external.commands.ExecuteTaskExternalCommand;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class ExternalInvoker
extends Invoker {
    private static final String ERROR_UNSUPPORTED_JOB_TYPE = "Bindings don't support non-native tasks";
    protected static final String SUFFIX_OUT = ".out";
    protected static final String SUFFIX_ERR = ".err";
    protected final ExecuteTaskExternalCommand command;

    public ExternalInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        this.command = this.getTaskExecutionCommand(context, invocation, taskSandboxWorkingDir.getAbsolutePath(), assignedResources);
        this.command.appendAllArguments(ExternalInvoker.getExternalCommand(invocation, context, assignedResources));
        String streamsName = context.getStandardStreamsPath(invocation);
        this.command.prependArgument(streamsName + SUFFIX_ERR);
        this.command.prependArgument(streamsName + SUFFIX_OUT);
    }

    protected abstract ExecuteTaskExternalCommand getTaskExecutionCommand(InvocationContext var1, Invocation var2, String var3, InvocationResources var4);

    private static ArrayList<String> getExternalCommand(Invocation invocation, InvocationContext context, InvocationResources assignedResources) throws JobExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(ExternalInvoker.addArguments(context, invocation));
        args.addAll(ExternalInvoker.addThreadAffinity(assignedResources));
        args.addAll(ExternalInvoker.addGPUAffinity(assignedResources));
        args.addAll(ExternalInvoker.addHostlist(context, invocation));
        return args;
    }

    private static ArrayList<String> addArguments(InvocationContext context, Invocation invocation) throws JobExecutionException {
        String methodName;
        String methodClass;
        if (invocation.getMethodImplementation().getMethodType() != MethodType.METHOD && invocation.getMethodImplementation().getMethodType() != MethodType.MULTI_NODE) {
            throw new JobExecutionException(ERROR_UNSUPPORTED_JOB_TYPE);
        }
        ArrayList<String> lArgs = new ArrayList<String>();
        lArgs.add(Integer.toString(Tracer.getLevel()));
        lArgs.add(Integer.toString(invocation.getTaskId()));
        lArgs.add(Boolean.toString(invocation.isDebugEnabled()));
        lArgs.add(context.getStorageConf());
        MethodType methodType = invocation.getMethodImplementation().getMethodType();
        switch (methodType) {
            case METHOD: {
                MethodImplementation methodImpl = (MethodImplementation)invocation.getMethodImplementation();
                methodClass = methodImpl.getDeclaringClass();
                methodName = methodImpl.getAlternativeMethodName();
                break;
            }
            case MULTI_NODE: {
                MultiNodeImplementation multiNodeImpl = (MultiNodeImplementation)invocation.getMethodImplementation();
                methodClass = multiNodeImpl.getDeclaringClass();
                methodName = multiNodeImpl.getMethodName();
                break;
            }
            default: {
                throw new JobExecutionException(ERROR_UNSUPPORTED_JOB_TYPE);
            }
        }
        lArgs.add(String.valueOf((Object)methodType));
        lArgs.add(methodClass);
        lArgs.add(methodName);
        lArgs.add(String.valueOf(invocation.getSlaveNodesNames().size()));
        lArgs.addAll(invocation.getSlaveNodesNames());
        MethodResourceDescription requirements = (MethodResourceDescription)invocation.getRequirements();
        lArgs.add(String.valueOf(requirements.getTotalCPUComputingUnits()));
        lArgs.add(Boolean.toString(invocation.getTarget() != null));
        if (!invocation.getResults().isEmpty()) {
            DataType returnType = invocation.getResults().get(0).getType();
            lArgs.add(Integer.toString(returnType.ordinal()));
        } else {
            lArgs.add("null");
        }
        lArgs.add(Integer.toString(invocation.getResults().size()));
        ArrayList<String> invArgs = new ArrayList<String>();
        int numParams = invocation.getParams().size();
        for (InvocationParam invocationParam : invocation.getParams()) {
            invArgs.addAll(ExternalInvoker.convertParameter(invocationParam));
        }
        if (invocation.getTarget() != null) {
            ++numParams;
            invArgs.addAll(ExternalInvoker.convertParameter(invocation.getTarget()));
        }
        for (InvocationParam invocationParam : invocation.getResults()) {
            ++numParams;
            invArgs.addAll(ExternalInvoker.convertParameter(invocationParam));
        }
        lArgs.add(Integer.toString(numParams));
        lArgs.addAll(invArgs);
        return lArgs;
    }

    private static ArrayList<String> convertParameter(InvocationParam np) {
        ArrayList<String> paramArgs = new ArrayList<String>();
        DataType type = np.getType();
        paramArgs.add(Integer.toString(type.ordinal()));
        paramArgs.add(Integer.toString(np.getStdIOStream().ordinal()));
        paramArgs.add(np.getPrefix());
        paramArgs.add(np.getName());
        switch (type) {
            case FILE_T: {
                String originalFile = np.getOriginalName();
                String destFile = new File(np.getRenamedName()).getName();
                if (!ExternalInvoker.isRuntimeRenamed(destFile)) {
                    destFile = originalFile;
                }
                paramArgs.add(originalFile + ":" + destFile + ":" + np.isPreserveSourceData() + ":" + np.isWriteFinalValue() + ":" + np.getOriginalName());
                break;
            }
            case OBJECT_T: 
            case PSCO_T: 
            case STREAM_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: {
                paramArgs.add(np.getValue().toString());
                paramArgs.add(np.isWriteFinalValue() ? "W" : "R");
                break;
            }
            case BINDING_OBJECT_T: {
                String destData;
                String extObjValue = np.getValue().toString();
                LOGGER.debug("Generating command args for Binding_object " + extObjValue);
                BindingObject bo = BindingObject.generate(extObjValue);
                String originalData = "";
                if (np.getSourceDataId() != null) {
                    originalData = np.getSourceDataId();
                }
                if (!ExternalInvoker.isRuntimeRenamed(destData = bo.getName())) {
                    destData = originalData;
                }
                paramArgs.add(originalData + ":" + destData + ":" + np.isPreserveSourceData() + ":" + np.isWriteFinalValue() + ":" + np.getOriginalName());
                paramArgs.add(Integer.toString(bo.getType()));
                paramArgs.add(Integer.toString(bo.getElements()));
                break;
            }
            case STRING_T: {
                String value = np.getValue().toString();
                String[] vals = value.split(" ");
                int numSubStrings = vals.length;
                paramArgs.add(Integer.toString(numSubStrings));
                for (String v : vals) {
                    paramArgs.add(v);
                }
                break;
            }
            default: {
                paramArgs.add(np.getValue().toString());
            }
        }
        return paramArgs;
    }

    private static boolean isRuntimeRenamed(String filename) {
        return filename.startsWith("d") && filename.endsWith(".IT");
    }

    private static ArrayList<String> addThreadAffinity(InvocationResources assignedResources) {
        String computingUnits;
        ArrayList<String> args = new ArrayList<String>();
        int[] assignedCoreUnits = assignedResources.getAssignedCPUs();
        if (assignedCoreUnits.length == 0) {
            computingUnits = "-";
        } else {
            computingUnits = String.valueOf(assignedCoreUnits[0]);
            for (int i = 1; i < assignedCoreUnits.length; ++i) {
                computingUnits = computingUnits + "," + assignedCoreUnits[i];
            }
        }
        args.add(computingUnits);
        return args;
    }

    private static ArrayList<String> addGPUAffinity(InvocationResources assignedResources) {
        String computingUnits;
        ArrayList<String> args = new ArrayList<String>();
        int[] assignedGPUs = assignedResources.getAssignedGPUs();
        if (assignedGPUs.length == 0) {
            computingUnits = "-";
        } else {
            computingUnits = String.valueOf(assignedGPUs[0]);
            for (int i = 1; i < assignedGPUs.length; ++i) {
                computingUnits = computingUnits + "," + assignedGPUs[i];
            }
        }
        args.add(computingUnits);
        return args;
    }

    private static ArrayList<String> addHostlist(InvocationContext context, Invocation invocation) {
        ArrayList<String> args = new ArrayList<String>();
        List<String> hostnames = invocation.getSlaveNodesNames();
        hostnames.add(context.getHostName());
        ResourceDescription rd = invocation.getRequirements();
        int computingUnits = invocation.getTaskType() == TaskType.METHOD ? ((MethodResourceDescription)rd).getTotalCPUComputingUnits() : 0;
        boolean firstElement = true;
        StringBuilder hostnamesSTR = new StringBuilder();
        for (String hostname : hostnames) {
            int i;
            if (hostname.endsWith("-ib0")) {
                hostname = hostname.substring(0, hostname.lastIndexOf("-ib0"));
            }
            if (firstElement) {
                firstElement = false;
                hostnamesSTR.append(hostname);
                for (i = 1; i < computingUnits; ++i) {
                    hostnamesSTR.append(",").append(hostname);
                }
                continue;
            }
            for (i = 0; i < computingUnits; ++i) {
                hostnamesSTR.append(",").append(hostname);
            }
        }
        String workers = hostnamesSTR.toString();
        if (workers != null && !workers.isEmpty()) {
            args.add(workers);
        } else {
            args.add("-");
        }
        return args;
    }
}

