/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.colors.ColorConfiguration;
import es.bsc.compss.types.colors.ColorNode;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.util.CoreManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Task
extends AbstractTask {
    private final TaskDescription taskDescription;
    private Task enforcingTask;
    private int executionCount;
    private final TaskMonitor taskMonitor;
    private final OnFailure onFailure;
    private TreeMap<Integer, CommutativeGroupTask> commutativeGroup;

    public Task(Long appId, COMPSsConstants.Lang lang, String signature, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, List<Parameter> parameters, TaskMonitor monitor, OnFailure onFailure) {
        super(appId);
        int coreId = CoreManager.getCoreId(signature);
        this.taskDescription = new TaskDescription(TaskType.METHOD, lang, signature, coreId, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, numReturns, parameters);
        this.taskMonitor = monitor;
        this.onFailure = onFailure;
        this.commutativeGroup = new TreeMap();
    }

    public Task(Long appId, String namespace, String service, String port, String operation, boolean isPrioritary, boolean hasTarget, int numReturns, List<Parameter> parameters, TaskMonitor monitor, OnFailure onFailure) {
        super(appId);
        String signature = ServiceImplementation.getSignature(namespace, service, port, operation, hasTarget, numReturns, parameters);
        int coreId = CoreManager.getCoreId(signature);
        int numNodes = 1;
        boolean isReplicated = Boolean.parseBoolean("false");
        boolean isDistributed = Boolean.parseBoolean("false");
        this.taskDescription = new TaskDescription(TaskType.SERVICE, COMPSsConstants.Lang.UNKNOWN, signature, coreId, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, numReturns, parameters);
        this.taskMonitor = monitor;
        this.onFailure = onFailure;
        this.commutativeGroup = new TreeMap();
    }

    public void setEnforcingTask(Task task) {
        this.enforcingTask = task;
    }

    public boolean isFree() {
        return this.executionCount == 0;
    }

    public void setExecutionCount(int executionCount) {
        this.executionCount = executionCount;
    }

    public void decreaseExecutionCount() {
        --this.executionCount;
    }

    public TaskDescription getTaskDescription() {
        return this.taskDescription;
    }

    public boolean isSchedulingForced() {
        return this.enforcingTask != null;
    }

    public Task getEnforcingTask() {
        return this.enforcingTask;
    }

    public void setCommutativeGroup(CommutativeGroupTask com, DataAccessId daId) {
        this.commutativeGroup.put(daId.getDataId(), com);
    }

    public CommutativeGroupTask getCommutativeGroup(Integer daId) {
        return this.commutativeGroup.get(daId);
    }

    public List<CommutativeGroupTask> getCommutativeGroupList() {
        LinkedList<CommutativeGroupTask> commutativeGroupList = new LinkedList<CommutativeGroupTask>();
        for (Map.Entry<Integer, CommutativeGroupTask> entry : this.commutativeGroup.entrySet()) {
            CommutativeGroupTask comTask = entry.getValue();
            commutativeGroupList.add(comTask);
        }
        return commutativeGroupList;
    }

    @Override
    public String getDotDescription() {
        int monitorTaskId = this.taskDescription.getCoreId() + 1;
        ColorNode color = ColorConfiguration.COLORS[monitorTaskId % ColorConfiguration.NUM_COLORS];
        String shape = this.taskDescription.getType() == TaskType.METHOD ? (this.taskDescription.isReplicated() ? "doublecircle" : (this.taskDescription.isDistributed() ? "circle" : "circle")) : "diamond";
        return this.getId() + "[shape=" + shape + ", " + "style=filled fillcolor=\"" + color.getFillColor() + "\" fontcolor=\"" + color.getFontColor() + "\"];";
    }

    @Override
    public String getLegendDescription() {
        StringBuilder information = new StringBuilder();
        information.append("<tr>").append("\n");
        information.append("<td align=\"right\">").append(this.getMethodName()).append("</td>").append("\n");
        information.append("<td bgcolor=\"").append(this.getColor()).append("\">&nbsp;</td>").append("\n");
        information.append("</tr>").append("\n");
        return information.toString();
    }

    public String getMethodName() {
        String methodName = this.taskDescription.getName();
        return methodName;
    }

    @Override
    public String getColor() {
        int monitorTaskId = this.taskDescription.getCoreId() + 1;
        ColorNode color = ColorConfiguration.COLORS[monitorTaskId % ColorConfiguration.NUM_COLORS];
        return color.getFillColor();
    }

    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    public boolean canBeExecuted() {
        if (!this.commutativeGroup.isEmpty()) {
            for (CommutativeGroupTask com : this.commutativeGroup.values()) {
                if (!com.processingExecution(this.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public void setVersion(DataAccessId daId) {
        for (Parameter p : this.getTaskDescription().getParameters()) {
            if (!(p instanceof DependencyParameter) || ((DependencyParameter)p).getDataAccessId().getDataId() != daId.getDataId()) continue;
            ((DependencyParameter)p).setDataAccessId(daId);
        }
    }

    public boolean hasCommutativeParams() {
        for (Parameter p : this.getTaskDescription().getParameters()) {
            if (!(p instanceof DependencyParameter) || p.getDirection() != Direction.COMMUTATIVE) continue;
            return true;
        }
        return false;
    }

    public OnFailure getOnFailure() {
        return this.onFailure;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Task id: ").append(this.getId()).append("]");
        buffer.append(", [Status: ").append((Object)this.getStatus()).append("]");
        buffer.append(", ").append(this.getTaskDescription().toString()).append("]");
        return buffer.toString();
    }
}

