/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.util.ErrorManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class TaskDescription
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private TaskType type;
    private COMPSsConstants.Lang lang;
    private String signature;
    private Integer coreId;
    private boolean priority;
    private int numNodes;
    private boolean mustReplicate;
    private boolean mustDistribute;
    private List<Parameter> parameters;
    private boolean hasTarget;
    private int numReturns;

    public TaskDescription() {
        this.type = null;
        this.lang = null;
        this.signature = null;
        this.coreId = null;
        this.priority = false;
        this.numNodes = 0;
        this.mustReplicate = false;
        this.mustDistribute = false;
        this.parameters = null;
        this.hasTarget = false;
        this.numReturns = 0;
    }

    public TaskDescription(TaskType type, COMPSsConstants.Lang lang, String signature, int coreId, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, List<Parameter> parameters) {
        this.type = type;
        this.lang = lang;
        this.signature = signature;
        this.coreId = coreId;
        this.priority = isPrioritary;
        this.numNodes = numNodes;
        this.mustReplicate = isReplicated;
        this.mustDistribute = isDistributed;
        this.hasTarget = hasTarget;
        this.parameters = parameters;
        this.numReturns = numReturns;
        if (this.numNodes < 1) {
            ErrorManager.error("Invalid number of nodes " + this.numNodes + " on executeTask " + this.signature);
        }
    }

    public Integer getCoreId() {
        return this.coreId;
    }

    public COMPSsConstants.Lang getLang() {
        return this.lang;
    }

    public String getName() {
        String methodName = this.signature;
        int endIndex = methodName.indexOf(40);
        if (endIndex >= 0) {
            methodName = methodName.substring(0, endIndex);
        }
        return methodName;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public boolean isSingleNode() {
        return this.numNodes == 1;
    }

    public boolean isReplicated() {
        return this.mustReplicate;
    }

    public boolean isDistributed() {
        return this.mustDistribute;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean hasTargetObject() {
        return this.hasTarget;
    }

    public int getNumReturns() {
        return this.numReturns;
    }

    public TaskType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Core id: ").append(this.coreId).append("]");
        buffer.append(", [Priority: ").append(this.priority).append("]");
        buffer.append(", [NumNodes: ").append(this.numNodes).append("]");
        buffer.append(", [MustReplicate: ").append(this.mustReplicate).append("]");
        buffer.append(", [MustDistribute: ").append(this.mustDistribute).append("]");
        buffer.append(", [").append(this.getName()).append("(");
        int numParams = this.parameters.size();
        if (this.hasTarget) {
            --numParams;
        }
        if ((numParams -= this.numReturns) > 0) {
            buffer.append((Object)this.parameters.get(0).getType());
            for (int i = 1; i < numParams; ++i) {
                buffer.append(", ").append((Object)this.parameters.get(i).getType());
            }
        }
        buffer.append(")]");
        return buffer.toString();
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeInt(this.type.ordinal());
        oo.writeInt(this.lang.ordinal());
        oo.writeUTF(this.signature);
        oo.writeObject(this.coreId);
        oo.writeBoolean(this.priority);
        oo.writeInt(this.numNodes);
        oo.writeBoolean(this.mustReplicate);
        oo.writeBoolean(this.mustDistribute);
        oo.writeObject(this.parameters);
        oo.writeBoolean(this.hasTarget);
        oo.writeInt(this.numReturns);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.type = TaskType.values()[oi.readInt()];
        this.lang = COMPSsConstants.Lang.values()[oi.readInt()];
        this.signature = oi.readUTF();
        this.coreId = (Integer)oi.readObject();
        this.priority = oi.readBoolean();
        this.numNodes = oi.readInt();
        this.mustReplicate = oi.readBoolean();
        this.mustDistribute = oi.readBoolean();
        this.parameters = (List)oi.readObject();
        this.hasTarget = oi.readBoolean();
        this.numReturns = oi.readInt();
    }
}

