/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskProducer;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.allocatableactions.MultiNodeExecutionAction;
import es.bsc.compss.types.allocatableactions.MultiNodeGroup;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.request.td.TDRequestType;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.Collection;

public class ExecuteTasksRequest
extends TDRequest {
    private final TaskProducer producer;
    private final Task task;

    public ExecuteTasksRequest(TaskProducer producer, Task t) {
        this.producer = producer;
        this.task = t;
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        int coreId = this.task.getTaskDescription().getCoreId();
        if (DEBUG) {
            LOGGER.debug("Treating Scheduling request for task " + this.task.getId() + "(core " + coreId + ")");
        }
        this.task.setStatus(TaskState.TO_EXECUTE);
        int numNodes = this.task.getTaskDescription().getNumNodes();
        boolean isReplicated = this.task.getTaskDescription().isReplicated();
        boolean isDistributed = this.task.getTaskDescription().isDistributed();
        if (isReplicated) {
            if (DEBUG) {
                LOGGER.debug("Replicating task " + this.task.getId());
            }
            Collection<ResourceScheduler<? extends WorkerResourceDescription>> resources = ts.getWorkers();
            this.task.setExecutionCount(resources.size() * numNodes);
            for (ResourceScheduler<? extends WorkerResourceDescription> rs : resources) {
                this.submitTask(ts, numNodes, rs);
            }
        } else if (isDistributed) {
            if (DEBUG) {
                LOGGER.debug("Distributing task " + this.task.getId());
            }
            ResourceScheduler<? extends WorkerResourceDescription> selectedResource = null;
            int minNumTasksOfSameType = Integer.MAX_VALUE;
            Collection<ResourceScheduler<? extends WorkerResourceDescription>> resources = ts.getWorkers();
            for (ResourceScheduler<? extends WorkerResourceDescription> rs : resources) {
                int numTasks = rs.getNumTasks(this.task.getTaskDescription().getCoreId());
                if (numTasks >= minNumTasksOfSameType) continue;
                minNumTasksOfSameType = numTasks;
                selectedResource = rs;
            }
            this.task.setExecutionCount(numNodes);
            this.submitTask(ts, numNodes, selectedResource);
        } else {
            if (DEBUG) {
                LOGGER.debug("Submitting task " + this.task.getId());
            }
            this.task.setExecutionCount(numNodes);
            this.submitTask(ts, numNodes, null);
        }
        if (DEBUG) {
            LOGGER.debug("Treated Scheduling request for task " + this.task.getId() + " (core " + coreId + ")");
        }
    }

    private <T extends WorkerResourceDescription> void submitTask(TaskScheduler ts, int numNodes, ResourceScheduler<T> specificResource) {
        if (numNodes == 1) {
            this.submitSingleTask(ts, specificResource);
        } else {
            this.submitMultiNodeTask(ts, numNodes, specificResource);
        }
    }

    private <T extends WorkerResourceDescription> void submitSingleTask(TaskScheduler ts, ResourceScheduler<T> specificResource) {
        LOGGER.debug("Scheduling request for task " + this.task.getId() + " treated as singleTask");
        ExecutionAction action = new ExecutionAction(ts.generateSchedulingInformation(specificResource), ts.getOrchestrator(), this.producer, this.task);
        ts.newAllocatableAction(action);
    }

    private <T extends WorkerResourceDescription> void submitMultiNodeTask(TaskScheduler ts, int numNodes, ResourceScheduler<T> specificResource) {
        LOGGER.debug("Scheduling request for task " + this.task.getId() + " treated as multiNodeTask with " + numNodes + " nodes");
        MultiNodeGroup group2 = new MultiNodeGroup(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            MultiNodeExecutionAction action = new MultiNodeExecutionAction(ts.generateSchedulingInformation(specificResource), ts.getOrchestrator(), this.producer, this.task, group2);
            ts.newAllocatableAction(action);
        }
    }

    @Override
    public TDRequestType getType() {
        return TDRequestType.EXECUTE_TASKS;
    }
}

