/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.exceptions.LangNotDefinedException;
import es.bsc.compss.types.exceptions.UndefinedConstraintsSourceException;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.parsers.IDLParser;
import es.bsc.compss.util.parsers.ITFParser;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CEIParser {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private static final COMPSsConstants.Lang LANG;

    public static void parse() {
        switch (LANG) {
            case JAVA: {
                String appName = System.getProperty("compss.appName");
                if (appName != null) {
                    try {
                        CEIParser.loadJava(Class.forName(appName + "Itf"));
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new UndefinedConstraintsSourceException(appName + "Itf class cannot be found.");
                    }
                }
                LOGGER.warn("No defined Application Name. COMPSs is not loading any CEI.");
                break;
            }
            case C: {
                String constraintsFile = System.getProperty("compss.constraints.file");
                CEIParser.loadC(constraintsFile);
                break;
            }
            case PYTHON: {
                CEIParser.loadPython();
                break;
            }
            default: {
                throw new LangNotDefinedException();
            }
        }
    }

    public static List<Integer> loadJava(Class<?> annotItfClass) {
        LOGGER.debug("Loading Java Annotation Interface");
        LinkedList<Integer> updatedCEs = new LinkedList<Integer>();
        List<CoreElementDefinition> ceds = ITFParser.parseITFMethods(annotItfClass);
        for (CoreElementDefinition ced : ceds) {
            Integer methodId = CoreManager.registerNewCoreElement(ced);
            updatedCEs.add(methodId);
        }
        return updatedCEs;
    }

    private static void loadC(String constraintsFile) {
        LOGGER.debug("Loading C Annotation Interface");
        IDLParser.parseIDLMethods(constraintsFile);
    }

    private static void loadPython() {
        LOGGER.debug("Loading Python Annotation Interface");
    }

    static {
        COMPSsConstants.Lang l = COMPSsConstants.Lang.JAVA;
        String langProperty = System.getProperty("compss.lang");
        if (langProperty != null) {
            if (langProperty.equalsIgnoreCase(COMPSsConstants.Lang.PYTHON.name())) {
                l = COMPSsConstants.Lang.PYTHON;
            } else if (langProperty.equalsIgnoreCase(COMPSsConstants.Lang.C.name())) {
                l = COMPSsConstants.Lang.C;
            }
        }
        LANG = l;
    }
}

