/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.RESTAgentConfig;
import es.bsc.compss.agent.rest.AppMainMonitor;
import es.bsc.compss.agent.rest.AppTaskMonitor;
import es.bsc.compss.agent.rest.RESTAgentConf;
import es.bsc.compss.agent.rest.RESTServiceLauncher;
import es.bsc.compss.agent.rest.types.ApplicationParameterImpl;
import es.bsc.compss.agent.rest.types.Orchestrator;
import es.bsc.compss.agent.rest.types.messages.EndApplicationNotification;
import es.bsc.compss.agent.rest.types.messages.IncreaseNodeNotification;
import es.bsc.compss.agent.rest.types.messages.LostNodeNotification;
import es.bsc.compss.agent.rest.types.messages.ReduceNodeRequest;
import es.bsc.compss.agent.rest.types.messages.RemoveNodeRequest;
import es.bsc.compss.agent.rest.types.messages.StartApplicationRequest;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.agent.util.RemoteJobsRegistry;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/COMPSs")
public class RESTAgent
implements AgentInterface<RESTAgentConf> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Agent");
    private int port;
    private Server server = null;

    @Override
    public RESTAgentConf configure(JSONObject confJSON) throws AgentException {
        RESTAgentConf conf;
        try {
            String portSTR = confJSON.getString("PORT");
            portSTR = EnvironmentLoader.loadFromEnvironment(portSTR);
            int port = Integer.valueOf(portSTR);
            if (port <= 0) {
                throw new AgentException("Invalid port number for REST agent's interface.");
            }
            conf = new RESTAgentConf(this, port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AgentException(e);
        }
        return conf;
    }

    @Override
    public synchronized void start(RESTAgentConf args) throws AgentException {
        if (this.server != null) {
            return;
        }
        RESTServiceLauncher launcher = null;
        try {
            this.port = args.getPort();
            RESTAgentConfig.localAgentPort = this.port;
            launcher = new RESTServiceLauncher(this.port);
            new Thread(launcher).start();
            launcher.waitForBoot();
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        if (launcher.getStartError() != null) {
            throw new AgentException(launcher.getStartError());
        }
        this.server = launcher.getServer();
    }

    @Override
    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                ErrorManager.warn("Could not stop the REST server for the Agent at port " + this.port, ex);
            }
            finally {
                this.server.destroy();
                this.server = null;
            }
        }
    }

    @GET
    @Path(value="test/")
    public Response test() {
        System.out.println("test invoked");
        return Response.ok().build();
    }

    @GET
    @Path(value="resources/")
    @Produces(value={"application/json"})
    public Response getResources() {
        System.out.println("Requested current resource configuraction");
        JSONObject root = new JSONObject();
        root.put("time", System.currentTimeMillis());
        JSONArray resources = new JSONArray();
        root.put("resources", resources);
        for (Worker<? extends WorkerResourceDescription> worker : ResourceManager.getAllWorkers()) {
            JSONObject workerJSON = new JSONObject();
            resources.put(workerJSON);
            workerJSON.put("name", worker.getName());
            JSONObject descriptionJSON = new JSONObject();
            workerJSON.put("description", descriptionJSON);
            WorkerResourceDescription description = worker.getDescription();
            if (description instanceof MethodResourceDescription) {
                MethodResourceDescription mrd = (MethodResourceDescription)description;
                JSONArray processors = new JSONArray();
                descriptionJSON.put("processors", processors);
                for (Processor processor : mrd.getProcessors()) {
                    JSONObject processorJSON = new JSONObject();
                    processors.put(processorJSON);
                    processorJSON.put("name", processor.getName());
                    processorJSON.put("architecture", processor.getArchitecture());
                    processorJSON.put("units", processor.getComputingUnits());
                }
                descriptionJSON.put("memory_size", mrd.getMemorySize());
                descriptionJSON.put("memory_type", mrd.getMemoryType());
                descriptionJSON.put("storage_size", mrd.getStorageSize());
                descriptionJSON.put("storage_type", mrd.getStorageType());
                descriptionJSON.put("storage_bandwidth", mrd.getStorageBW());
            }
            workerJSON.put("adaptor", worker.getNode().getClass().getCanonicalName());
        }
        return Response.ok((Object)root.toString(), "text/plain").build();
    }

    @GET
    @Path(value="printResources/")
    public Response printResources() {
        System.out.println(ResourceManager.getCurrentState(""));
        return Response.ok().build();
    }

    @PUT
    @Path(value="addResources/")
    @Consumes(value={"application/xml"})
    public Response addResource(IncreaseNodeNotification nodeRequest) {
        Resource<?, ?> r = nodeRequest.getResource();
        MethodResourceDescription description = r.getDescription();
        List<Processor> procs = description.getProcessors();
        description.setProcessors(procs);
        try {
            Agent.addResources(r);
        }
        catch (AgentException ex) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(ex.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="removeResources/")
    @Consumes(value={"application/xml"})
    public Response removeResources(ReduceNodeRequest request) {
        String name = request.getWorkerName();
        MethodResourceDescription mrd = request.getResources();
        List<Processor> procs = mrd.getProcessors();
        mrd.setProcessors(procs);
        try {
            Agent.removeResources(name, mrd);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="removeNode/")
    @Consumes(value={"application/xml"})
    public Response removeResource(RemoveNodeRequest request) {
        String name = request.getWorkerName();
        try {
            Agent.removeNode(name);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="lostNode/")
    @Consumes(value={"application/xml"})
    public Response lostResource(LostNodeNotification notification) {
        String name = notification.getWorkerName();
        try {
            Agent.lostNode(name);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="startApplication/")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response startApplication(StartApplicationRequest request) {
        String ceiClass = request.getCeiClass();
        Response response = ceiClass != null ? RESTAgent.runMain(request) : RESTAgent.runTask(request);
        return response;
    }

    private static Response runMain(StartApplicationRequest request) {
        long appId;
        String ceiClass = request.getCeiClass();
        String className = request.getClassName();
        String methodName = request.getMethodName();
        ApplicationParameter[] params = request.getParams();
        AppMainMonitor monitor = new AppMainMonitor();
        try {
            appId = Agent.runMain(COMPSsConstants.Lang.JAVA, ceiClass, className, methodName, params, null, new ApplicationParameter[0], monitor);
        }
        catch (AgentException e) {
            LOGGER.error("ERROR IN runMain : ", (Throwable)e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok((Object)appId, "text/plain").build();
    }

    private static Response runTask(StartApplicationRequest request) {
        long appId;
        ApplicationParameter[] results;
        String className = request.getClassName();
        String methodName = request.getMethodName();
        ApplicationParameter[] arguments = request.getParams();
        ApplicationParameterImpl target = request.getTarget();
        boolean hasResult = request.isHasResult();
        if (hasResult) {
            results = new ApplicationParameterImpl[1];
            results[1] = new ApplicationParameterImpl(null, Direction.IN, DataType.OBJECT_T, StdIOStream.UNSPECIFIED, "", "result", "");
        } else {
            results = new ApplicationParameterImpl[]{};
        }
        Orchestrator orchestrator = request.getOrchestrator();
        int numParams = arguments.length;
        if (target != null) {
            ++numParams;
        }
        if (hasResult) {
            ++numParams;
        }
        AppTaskMonitor monitor = new AppTaskMonitor(numParams, orchestrator);
        try {
            appId = Agent.runTask(COMPSsConstants.Lang.JAVA, className, methodName, arguments, target, results, MethodResourceDescription.EMPTY_FOR_CONSTRAINTS, monitor);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok((Object)appId, "text/plain").build();
    }

    @PUT
    @Path(value="endApplication/")
    @Consumes(value={"application/xml"})
    public Response endApplication(EndApplicationNotification notification) {
        String jobId = notification.getJobId();
        JobEndStatus endStatus = notification.getEndStatus();
        DataType[] resultTypes = notification.getParamTypes();
        String[] resultLocations = notification.getParamLocations();
        RemoteJobsRegistry.notifyJobEnd(jobId, endStatus, resultTypes, resultLocations);
        return Response.ok().build();
    }

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        RESTAgent ra = new RESTAgent();
        RESTAgentConf config = new RESTAgentConf(ra, port);
        Agent.startInterface(config);
        Agent.start();
    }
}

