/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.listener;

import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.operation.DataOperation;
import java.util.concurrent.Semaphore;

public class WorkersDebugInformationListener
extends EventListener {
    private int operation = 0;
    private int errors = 0;
    private boolean enabled = false;
    private final Semaphore sem;

    public WorkersDebugInformationListener(Semaphore sem) {
        this.sem = sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        boolean failed;
        boolean finished;
        WorkersDebugInformationListener workersDebugInformationListener = this;
        synchronized (workersDebugInformationListener) {
            this.enabled = true;
            finished = this.operation == 0;
            failed = this.errors > 0;
        }
        if (finished) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEnd(DataOperation fOp) {
        boolean enabled;
        boolean failed;
        boolean finished;
        WorkersDebugInformationListener workersDebugInformationListener = this;
        synchronized (workersDebugInformationListener) {
            --this.operation;
            finished = this.operation == 0;
            failed = this.errors > 0;
            enabled = this.enabled;
        }
        if (finished && enabled) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFailure(DataOperation fOp, Exception e) {
        boolean enabled;
        boolean finished;
        WorkersDebugInformationListener workersDebugInformationListener = this;
        synchronized (workersDebugInformationListener) {
            ++this.errors;
            --this.operation;
            finished = this.operation == 0;
            enabled = this.enabled;
        }
        if (enabled && finished) {
            this.doFailures();
        }
    }

    private void doReady() {
        this.sem.release();
    }

    private void doFailures() {
        this.sem.release();
    }
}

