/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest;

import es.bsc.compss.agent.rest.RESTAgent;
import java.util.concurrent.Semaphore;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;

public class RESTServiceLauncher
implements Runnable {
    private final int port;
    private final Semaphore sem;
    private Server server;
    private Exception startError = null;

    public RESTServiceLauncher(int port) {
        this.port = port;
        this.sem = new Semaphore(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("REST Agent Service");
        try {
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.server = new Server(this.port);
            this.server.setHandler(context);
            ServletHolder jerseyServlet = context.addServlet(ServletContainer.class, "/*");
            jerseyServlet.setInitOrder(0);
            jerseyServlet.setInitParameter("jersey.config.server.provider.classnames", RESTAgent.class.getCanonicalName());
            try {
                this.server.start();
            }
            catch (Exception e) {
                this.startError = e;
                this.server.destroy();
                this.server = null;
            }
        }
        catch (Exception e) {
            this.startError = e;
            this.server = null;
        }
        this.sem.release();
        if (this.server != null) {
            try {
                this.server.join();
            }
            catch (Exception exception) {
            }
            finally {
                while (!this.server.isStopped()) {
                }
                this.server.destroy();
                this.server = null;
            }
        }
    }

    public Server getServer() {
        return this.server;
    }

    public Exception getStartError() {
        return this.startError;
    }

    public void waitForBoot() throws InterruptedException {
        this.sem.acquire();
    }
}

