/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest;

import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.rest.types.Orchestrator;
import es.bsc.compss.agent.rest.types.TaskProfile;
import es.bsc.compss.agent.rest.types.messages.EndApplicationNotification;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.util.ErrorManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;

public class AppTaskMonitor
extends AppMonitor {
    private static final Client CLIENT = ClientBuilder.newClient(new ClientConfig());
    private final Orchestrator orchestrator;
    private boolean successful;
    private final TaskProfile profile;

    public AppTaskMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results, Orchestrator orchestrator) {
        super(args, target, results);
        this.orchestrator = orchestrator;
        this.successful = false;
        this.profile = new TaskProfile();
    }

    public void onCreation() {
        super.onCreation();
        this.profile.created();
    }

    public void onAccessesProcessed() {
        super.onAccessesProcessed();
        this.profile.processedAccesses();
    }

    public void onSchedule() {
        super.onSchedule();
        this.profile.scheduled();
    }

    public void onSubmission() {
        super.onSubmission();
        this.profile.submitted();
    }

    public void onDataReception() {
        super.onDataReception();
    }

    public void valueGenerated(int paramId, String paramName, DataType paramType, String dataId, Object dataLocation) {
        super.valueGenerated(paramId, paramName, paramType, dataId, dataLocation);
    }

    public void onAbortedExecution() {
        super.onAbortedExecution();
        this.profile.finished();
    }

    public void onErrorExecution() {
        super.onAbortedExecution();
        this.profile.finished();
    }

    public void onFailedExecution() {
        super.onFailedExecution();
        this.profile.finished();
        this.successful = false;
    }

    public void onException() {
        super.onException();
        this.profile.finished();
    }

    public void onSuccesfulExecution() {
        super.onSuccesfulExecution();
        this.profile.finished();
        this.successful = true;
    }

    public void onCancellation() {
        super.onCancellation();
        this.profile.end();
        System.out.println("Job cancelled after " + this.profile.getTotalTime());
    }

    public void onCompletion() {
        super.onCompletion();
        this.profile.end();
        if (this.orchestrator != null) {
            String masterId = this.orchestrator.getHost();
            String operation = this.orchestrator.getOperation();
            WebTarget target = CLIENT.target(masterId);
            WebTarget wt = target.path(operation);
            EndApplicationNotification ean = new EndApplicationNotification("" + this.getAppId(), this.successful ? JobEndStatus.OK : JobEndStatus.EXECUTION_FAILED, this.getParamTypes(), this.getParamLocations());
            Response response = wt.request("application/json").put(Entity.xml(ean), Response.class);
            if (response.getStatusInfo().getStatusCode() != 200) {
                ErrorManager.warn((String)("AGENT Could not notify Application " + this.getAppId() + " end to " + wt));
            }
        }
        System.out.println("Job completed after " + this.profile.getTotalTime());
    }

    public void onFailure() {
        super.onFailure();
        this.profile.end();
        System.out.println("Job failed after " + this.profile.getTotalTime());
    }
}

