/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest;

import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.rest.RESTAgent;
import es.bsc.compss.agent.rest.types.OrchestratorNotification;
import es.bsc.compss.agent.rest.types.RESTAgentRequestHandler;
import es.bsc.compss.agent.rest.types.RESTAgentRequestListener;
import es.bsc.compss.agent.rest.types.TaskProfile;
import es.bsc.compss.agent.rest.types.messages.EndApplicationNotification;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.worker.COMPSsException;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;

public class AppTaskMonitor
extends AppMonitor
implements RESTAgentRequestHandler {
    private static final Client CLIENT = ClientBuilder.newClient(new ClientConfig());
    private final RESTAgent owner;
    private final RESTAgentRequestListener requestListener;
    private boolean successful;
    private final TaskProfile profile;
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Agent");

    public AppTaskMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results, RESTAgent owner, RESTAgentRequestListener requestListener) {
        super(args, target, results);
        this.requestListener = requestListener;
        this.successful = false;
        this.profile = new TaskProfile();
        this.owner = owner;
    }

    public void onCreation() {
        super.onCreation();
        this.profile.setTaskCreated(System.currentTimeMillis());
    }

    public void onAccessesProcessed() {
        super.onAccessesProcessed();
        this.profile.setTaskAnalyzed(System.currentTimeMillis());
    }

    public void onSchedule() {
        super.onSchedule();
        this.profile.setTaskScheduled(System.currentTimeMillis());
    }

    public void onSubmission() {
        super.onSubmission();
        this.profile.setTaskSubmitted(System.currentTimeMillis());
    }

    public void onDataReception() {
        super.onDataReception();
    }

    public void valueGenerated(int paramId, TaskMonitor.TaskResult result) {
        super.valueGenerated(paramId, result);
    }

    public void onExecutionStart() {
        this.profile.setExecutionStart(System.currentTimeMillis());
    }

    public void onExecutionStartAt(long ts) {
        this.profile.setExecutionStart(ts);
    }

    public void onExecutionEnd() {
        this.profile.setExecutionEnd(System.currentTimeMillis());
    }

    public void onExecutionEndAt(long ts) {
        this.profile.setExecutionEnd(ts);
    }

    public void onAbortedExecution() {
        super.onAbortedExecution();
        this.profile.setEndNotification(System.currentTimeMillis());
    }

    public void onErrorExecution() {
        super.onAbortedExecution();
        this.profile.setEndNotification(System.currentTimeMillis());
    }

    public void onFailedExecution() {
        super.onFailedExecution();
        this.profile.setEndNotification(System.currentTimeMillis());
        this.successful = false;
    }

    public void onException(COMPSsException e) {
        super.onException(e);
        this.profile.setEndNotification(System.currentTimeMillis());
    }

    public void onSuccesfulExecution() {
        super.onSuccesfulExecution();
        this.profile.setEndNotification(System.currentTimeMillis());
        this.successful = true;
    }

    public void onCancellation() {
        super.onCancellation();
        this.profile.setTaskEnd(System.currentTimeMillis());
        if (this.requestListener != null) {
            this.requestListener.requestCompleted(this);
        }
        System.out.println("Job cancelled after " + this.profile.getTotalTime());
    }

    public void onCompletion() {
        super.onCompletion();
        this.profile.setTaskEnd(System.currentTimeMillis());
        if (this.requestListener != null) {
            this.requestListener.requestCompleted(this);
        }
        System.out.println("Job completed after " + this.profile.getTotalTime());
    }

    public void onFailure() {
        super.onFailure();
        this.profile.setTaskEnd(System.currentTimeMillis());
        if (this.requestListener != null) {
            this.requestListener.requestCompleted(this);
        }
        System.out.println("Job failed after " + this.profile.getTotalTime());
    }

    @Override
    public void notifyOrchestrator(String host, OrchestratorNotification.HttpMethod method, String operation) {
        WebTarget target = CLIENT.target(host);
        WebTarget wt = target.path(operation);
        TaskMonitor.TaskResult[] results = this.getResults();
        DataType[] paramTypes = new DataType[results.length];
        String[] paramLocations = new String[results.length];
        int i = 0;
        for (TaskMonitor.TaskResult result : results) {
            paramTypes[i] = result.getType();
            paramLocations[i] = result.getDataLocation();
            ++i;
        }
        EndApplicationNotification ean = new EndApplicationNotification("" + this.getAppId(), this.successful ? JobEndStatus.OK : JobEndStatus.EXECUTION_FAILED, paramTypes, paramLocations, this.profile);
        Response response = wt.request("application/json").put(Entity.xml(ean), Response.class);
        if (response.getStatusInfo().getStatusCode() != 200) {
            ErrorManager.warn((String)("AGENT Could not notify Application " + this.getAppId() + " end to " + wt));
        }
    }

    @Override
    public void powerOff(List<String> forwardToHosts) {
        LOGGER.debug("AppTaskRequest completion initiates agent shutdown");
        if (forwardToHosts != null) {
            for (String host : forwardToHosts) {
                WebTarget target = CLIENT.target(host);
                LOGGER.debug("Forwarding stop action to: " + (target != null ? target.toString() : "null"));
                WebTarget wt = target.path("COMPSs/");
                Response response = wt.request().delete(Response.class);
                if (response.getStatusInfo().getStatusCode() == 200) continue;
                ErrorManager.warn((String)("AGENT Could not forward stop action to " + wt + ", returned code: " + response.getStatusInfo().getStatusCode()));
            }
        }
        new Thread(){

            @Override
            public void run() {
                AppTaskMonitor.this.owner.powerOff();
            }
        }.start();
    }
}

