/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest;

import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.rest.RESTAgent;
import es.bsc.compss.agent.rest.types.OrchestratorNotification;
import es.bsc.compss.agent.rest.types.RESTAgentRequestHandler;
import es.bsc.compss.agent.rest.types.RESTAgentRequestListener;
import es.bsc.compss.agent.rest.types.RESTResult;
import es.bsc.compss.agent.rest.types.TaskProfile;
import es.bsc.compss.agent.rest.types.messages.EndApplicationNotification;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.PrivateRemoteDataLocation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.worker.COMPSsException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;

public class RESTAppMonitor
extends AppMonitor
implements RESTAgentRequestHandler {
    private static final Client CLIENT = ClientBuilder.newClient(new ClientConfig());
    private final RESTAgent owner;
    private final RESTAgentRequestListener requestListener;
    private boolean successful;
    private final TaskProfile profile;
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Agent");

    public RESTAppMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results, RESTAgent owner, RESTAgentRequestListener requestListener) {
        super(args, target, results);
        this.requestListener = requestListener;
        this.successful = false;
        this.profile = new TaskProfile();
        this.owner = owner;
    }

    public AppMonitor.UniqueTaskMonitor getTaskMonitor() {
        return new RESTTaskMonitor();
    }

    public void specificOnCancellation() {
        if (this.requestListener != null) {
            this.requestListener.requestCompleted(this);
        }
        System.out.println("App cancelled after " + this.profile.getTotalTime());
    }

    public void specificOnCompletion() {
        if (this.requestListener != null) {
            this.requestListener.requestCompleted(this);
        }
        System.out.println("App completed after " + this.profile.getTotalTime());
    }

    public void specificOnException(COMPSsException e) {
    }

    public void specificOnFailure() {
        if (this.requestListener != null) {
            this.requestListener.requestCompleted(this);
        }
        System.out.println("App failed after " + this.profile.getTotalTime());
    }

    @Override
    public void notifyOrchestrator(String host, OrchestratorNotification.HttpMethod method, String operation) {
        WebTarget target = CLIENT.target(host);
        WebTarget wt = target.path(operation);
        AppMonitor.TaskResult[] taskResults = this.getResults();
        RESTResult[] restResults = new RESTResult[taskResults.length];
        int i = 0;
        for (AppMonitor.TaskResult result : taskResults) {
            Collection remoteLocations = result.getLocations();
            String[] locs = this.remoteDataInfoToStringArray(remoteLocations);
            restResults[i] = new RESTResult(locs);
            ++i;
        }
        EndApplicationNotification ean = new EndApplicationNotification("" + this.getAppId(), this.successful ? JobEndStatus.OK : JobEndStatus.EXECUTION_FAILED, restResults, this.profile);
        Response response = wt.request("application/json").put(Entity.xml(ean), Response.class);
        if (response.getStatusInfo().getStatusCode() != 200) {
            ErrorManager.warn((String)("AGENT Could not notify Application " + this.getAppId() + " end to " + wt));
        }
    }

    private String[] remoteDataInfoToStringArray(Collection<RemoteDataLocation> remoteLocations) {
        String[] res = new String[remoteLocations.size()];
        int i = 0;
        for (RemoteDataLocation remoteLoc : remoteLocations) {
            res[i] = ((PrivateRemoteDataLocation)remoteLoc).getPath();
            ++i;
        }
        return res;
    }

    @Override
    public void powerOff(final List<String> forwardToHosts) {
        new Thread(){

            @Override
            public void run() {
                LOGGER.debug("AppTaskRequest completion initiates agent shutdown");
                if (forwardToHosts != null) {
                    final Semaphore sem = new Semaphore(0);
                    for (final String host : forwardToHosts) {
                        new Thread(){

                            @Override
                            public void run() {
                                WebTarget target = CLIENT.target(host);
                                if (target != null) {
                                    LOGGER.debug("Forwarding stop action to: " + host);
                                    WebTarget wt = target.path("COMPSs/");
                                    Response response = wt.request().delete(Response.class);
                                    if (response.getStatusInfo().getStatusCode() != 200) {
                                        ErrorManager.warn((String)("AGENT Could not forward stop action to " + wt + ", returned code: " + response.getStatusInfo().getStatusCode()));
                                    }
                                    LOGGER.debug(host + " has been stopped");
                                } else {
                                    LOGGER.warn("Could not contact " + host + " to stop it");
                                }
                                sem.release();
                            }
                        }.start();
                    }
                    sem.acquireUninterruptibly(forwardToHosts.size());
                }
                RESTAppMonitor.this.owner.powerOff();
            }
        }.start();
    }

    protected class RESTTaskMonitor
    extends AppMonitor.UniqueTaskMonitor {
        protected RESTTaskMonitor() {
            super((AppMonitor)RESTAppMonitor.this);
        }

        public void specificOnCreation() {
            RESTAppMonitor.this.profile.setTaskCreated(System.currentTimeMillis());
        }

        public void specificOnAccessesProcessed() {
            RESTAppMonitor.this.profile.setTaskAnalyzed(System.currentTimeMillis());
        }

        public void specificOnSchedule() {
            RESTAppMonitor.this.profile.setTaskScheduled(System.currentTimeMillis());
        }

        public void specificOnSubmission() {
            RESTAppMonitor.this.profile.setTaskSubmitted(System.currentTimeMillis());
        }

        public void specificOnDataReception() {
        }

        public void specificOnExecutionStart() {
            RESTAppMonitor.this.profile.setExecutionStart(System.currentTimeMillis());
        }

        public void specificOnExecutionStartAt(long ts) {
            RESTAppMonitor.this.profile.setExecutionStart(ts);
        }

        public void specificOnExecutionEnd() {
            RESTAppMonitor.this.profile.setExecutionEnd(System.currentTimeMillis());
        }

        public void specificOnExecutionEndAt(long ts) {
            RESTAppMonitor.this.profile.setExecutionEnd(ts);
        }

        public void specificOnAbortedExecution() {
            RESTAppMonitor.this.profile.setEndNotification(System.currentTimeMillis());
        }

        public void specificOnErrorExecution() {
            RESTAppMonitor.this.profile.setEndNotification(System.currentTimeMillis());
        }

        public void specificOnFailedExecution() {
            RESTAppMonitor.this.profile.setEndNotification(System.currentTimeMillis());
            RESTAppMonitor.this.successful = false;
        }

        public void specificOnException(COMPSsException e) {
            RESTAppMonitor.this.profile.setEndNotification(System.currentTimeMillis());
        }

        public void specificOnSuccessfulExecution() {
            RESTAppMonitor.this.profile.setEndNotification(System.currentTimeMillis());
            RESTAppMonitor.this.successful = true;
        }

        public void specificOnCancellation() {
            RESTAppMonitor.this.profile.setTaskEnd(System.currentTimeMillis());
        }

        public void specificOnCompletion() {
            RESTAppMonitor.this.profile.setTaskEnd(System.currentTimeMillis());
        }

        public void specificOnFailure() {
            RESTAppMonitor.this.profile.setTaskEnd(System.currentTimeMillis());
        }
    }
}

