/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.types.messages;

import es.bsc.compss.agent.rest.types.ActionTrigger;
import es.bsc.compss.agent.rest.types.ApplicationParameterImpl;
import es.bsc.compss.agent.rest.types.ApplicationParameterValue;
import es.bsc.compss.agent.rest.types.OrchestratorNotification;
import es.bsc.compss.agent.rest.types.RESTAgentRequestListener;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.implementations.ExecType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement(name="startApplication")
public class StartApplicationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceInstanceId;
    private String lang;
    private String ceiClass;
    private String className;
    private String methodName;
    private ApplicationParameterImpl[] params = new ApplicationParameterImpl[0];
    private ApplicationParameterImpl target;
    private boolean hasResult;
    private RESTAgentRequestListener requestListener;
    private ExecType prolog;
    private ExecType epilog;

    public void setServiceInstanceId(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        String returnLang = this.lang;
        if (returnLang == null) {
            returnLang = "JAVA";
        }
        return returnLang;
    }

    public String getCeiClass() {
        return this.ceiClass;
    }

    public void setCeiClass(String ceiClass) {
        this.ceiClass = ceiClass;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public ApplicationParameterImpl getTarget() {
        return this.target;
    }

    public void setTarget(ApplicationParameterImpl target) {
        this.target = target;
    }

    public ExecType getProlog() {
        return this.prolog;
    }

    public void setProlog(ExecType prolog) {
        this.prolog = prolog;
    }

    public ExecType getEpilog() {
        return this.epilog;
    }

    public void setEpilog(ExecType epilog) {
        this.epilog = epilog;
    }

    public void addParameter(String name, String prefix, boolean value) {
        this.addParameter(value, Direction.IN, DataType.BOOLEAN_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String name, String prefix, byte value) {
        this.addParameter(value, Direction.IN, DataType.BYTE_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String name, String prefix, char value) {
        this.addParameter(Character.valueOf(value), Direction.IN, DataType.CHAR_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String name, String prefix, short value) {
        this.addParameter(value, Direction.IN, DataType.SHORT_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String name, String prefix, int value) {
        this.addParameter(value, Direction.IN, DataType.INT_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String name, String prefix, long value) {
        this.addParameter(value, Direction.IN, DataType.LONG_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String name, String prefix, float value) {
        this.addParameter(Float.valueOf(value), Direction.IN, DataType.FLOAT_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String name, String prefix, double value) {
        this.addParameter(value, Direction.IN, DataType.DOUBLE_T, StdIOStream.UNSPECIFIED, prefix, name, "", 1.0, false);
    }

    public void addParameter(String value) {
        this.addParameter(value, Direction.IN, DataType.STRING_T, StdIOStream.UNSPECIFIED, "", "", "", 1.0, false);
    }

    public void addParameter(Object value) {
        this.addParameter(Direction.IN, value);
    }

    public void addParameter(Direction direction, Object value) {
        this.addParameter(value, Direction.IN, DataType.OBJECT_T, StdIOStream.UNSPECIFIED, "", "", "", 1.0, false);
    }

    public ApplicationParameterImpl addParameter(Object value, Direction direction, DataType type, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename) {
        ApplicationParameterImpl p = new ApplicationParameterImpl(value, direction, type, stream, prefix, name, contentType, weight, keepRename);
        p.setParamId(this.params.length);
        ApplicationParameterImpl[] oldParams = this.params;
        this.params = new ApplicationParameterImpl[oldParams.length + 1];
        if (oldParams.length > 0) {
            System.arraycopy(oldParams, 0, this.params, 0, oldParams.length);
        }
        this.params[oldParams.length] = p;
        return p;
    }

    public void addPersistedParameter(String id) {
        this.addPersistedParameter(Direction.IN, id);
    }

    public void addPersistedParameter(Direction direction, String id) {
        ApplicationParameterImpl p = this.addParameter(id, direction, DataType.PSCO_T, StdIOStream.UNSPECIFIED, "", "", "", 1.0, false);
        ((ApplicationParameterValue.ElementParameter)p.getValue()).setClassName("storage.StubItf");
    }

    @XmlElementWrapper(name="parameters")
    public ApplicationParameterImpl[] getParams() {
        return this.params;
    }

    public void setParams(ApplicationParameterImpl[] params) {
        this.params = params;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StartApplication ").append(this.className).append(".").append(this.methodName).append("(");
        int count = 0;
        for (ApplicationParameterImpl param : this.params) {
            if (count > 0) {
                sb.append(", ");
            }
            ++count;
            if (param.getValue() instanceof ApplicationParameterValue.ArrayParameter) {
                sb.append(param.getType());
                continue;
            }
            sb.append(param.getType());
        }
        sb.append(") defined in CEI ").append(this.ceiClass);
        return sb.toString();
    }

    public void setOrchestratorNotification(String host, OrchestratorNotification.HttpMethod method, String operation) {
        this.requestListener = new OrchestratorNotification(host, method, operation);
    }

    @XmlElements(value={@XmlElement(name="action", type=ActionTrigger.class, required=false), @XmlElement(name="orchestrator", type=OrchestratorNotification.class, required=false)})
    public RESTAgentRequestListener getRequestListener() {
        return this.requestListener;
    }

    public void setRequestListener(RESTAgentRequestListener requestListener) {
        this.requestListener = requestListener;
    }
}

