/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class ExpressionSQLPrinter {
    private static final String NULL_STRING = "NULL";
    protected AbstractSession session;
    protected DatabasePlatform platform;
    protected SQLCall call;
    protected AbstractRecord translationRow;
    protected boolean shouldPrintQualifiedNames;
    protected Writer writer;
    protected boolean requiresDistinct;
    protected boolean isFirstElementPrinted;

    public ExpressionSQLPrinter(AbstractSession session, AbstractRecord translationRow, SQLCall call, boolean printQualifiedNames, ExpressionBuilder builder) {
        this.session = session;
        this.translationRow = translationRow;
        this.call = call;
        this.shouldPrintQualifiedNames = printQualifiedNames;
        this.platform = builder == null || builder.getDescriptor() == null ? this.getSession().getPlatform() : (DatabasePlatform)this.getSession().getPlatform(builder.getDescriptor().getJavaClass());
        this.requiresDistinct = false;
        this.isFirstElementPrinted = false;
    }

    public SQLCall getCall() {
        return this.call;
    }

    public DatabasePlatform getPlatform() {
        return this.platform;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isFirstElementPrinted() {
        return this.isFirstElementPrinted;
    }

    public void printExpression(Expression expression) {
        this.translateExpression(expression);
    }

    public void printField(DatabaseField field) {
        if (field == null) {
            return;
        }
        try {
            if (this.shouldPrintQualifiedNames()) {
                this.getWriter().write(field.getQualifiedNameDelimited(this.platform));
            } else {
                this.getWriter().write(field.getNameDelimited(this.platform));
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printField(DatabaseField field, DatabaseTable tableAlias) {
        if (field == null) {
            return;
        }
        try {
            if (this.shouldPrintQualifiedNames()) {
                this.getWriter().write(tableAlias.getQualifiedNameDelimited(this.platform));
                this.getWriter().write(".");
                this.getWriter().write(field.getNameDelimited(this.platform));
            } else {
                this.getWriter().write(field.getNameDelimited(this.platform));
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printParameter(ParameterExpression expression) {
        try {
            this.getCall().appendTranslationParameter(this.getWriter(), expression, this.getPlatform(), this.getTranslationRow());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printParameter(DatabaseField field) {
        this.getCall().appendTranslation(this.getWriter(), field);
    }

    public void printPrimitive(Object value, Boolean canBind) {
        if (value instanceof Collection) {
            this.printValuelist((Collection)value, canBind);
            return;
        }
        this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value, canBind);
    }

    public void printNull(ConstantExpression nullValueExpression) {
        if (this.session.getPlatform().shouldBindLiterals()) {
            DatabaseField field = null;
            Expression localBase = nullValueExpression.getLocalBase();
            if (localBase != null && (localBase.isFieldExpression() || localBase.isQueryKeyExpression())) {
                field = ((DataExpression)localBase).getField();
            }
            this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), field, nullValueExpression.canBind());
        } else {
            this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), null, nullValueExpression.canBind());
        }
    }

    public void printString(String value) {
        try {
            this.getWriter().write(value);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printValuelist(Collection<Object> values, Boolean canBind) {
        try {
            this.getWriter().write("(");
            if (values == null || values.isEmpty()) {
                this.getWriter().write(NULL_STRING);
            } else {
                Iterator<Object> valuesEnum = values.iterator();
                while (valuesEnum.hasNext()) {
                    Object value = valuesEnum.next();
                    if (value instanceof Collection) {
                        this.printValuelist((Collection)value, canBind);
                    } else if (value instanceof Expression) {
                        ((Expression)value).printSQL(this);
                    } else {
                        this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value, canBind);
                    }
                    if (!valuesEnum.hasNext()) continue;
                    this.getWriter().write(", ");
                }
            }
            this.getWriter().write(")");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printList(Collection<Object> values, Boolean canBind) {
        try {
            this.getWriter().write("(");
            if (values == null || values.isEmpty()) {
                this.getWriter().write(NULL_STRING);
            } else {
                Iterator<Object> valuesEnum = values.iterator();
                while (valuesEnum.hasNext()) {
                    Object value = valuesEnum.next();
                    if (value instanceof Expression) {
                        ((Expression)value).printSQL(this);
                    } else {
                        this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value, canBind);
                    }
                    if (!valuesEnum.hasNext()) continue;
                    this.getWriter().write(", ");
                }
            }
            this.getWriter().write(")");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public boolean requiresDistinct() {
        return this.requiresDistinct;
    }

    protected void setCall(SQLCall call) {
        this.call = call;
    }

    public void setIsFirstElementPrinted(boolean isFirstElementPrinted) {
        this.isFirstElementPrinted = isFirstElementPrinted;
    }

    public void setRequiresDistinct(boolean requiresDistinct) {
        this.requiresDistinct = requiresDistinct;
    }

    protected void setSession(AbstractSession theSession) {
        this.session = theSession;
    }

    protected void setShouldPrintQualifiedNames(boolean shouldPrintQualifiedNames) {
        this.shouldPrintQualifiedNames = shouldPrintQualifiedNames;
    }

    protected void setTranslationRow(AbstractRecord theRow) {
        this.translationRow = theRow;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean shouldPrintParameterValues() {
        return this.getTranslationRow() != null;
    }

    protected boolean shouldPrintQualifiedNames() {
        return this.shouldPrintQualifiedNames;
    }

    protected void translateExpression(Expression theExpression) {
        theExpression.printSQL(this);
    }
}

