/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class GenericsClassHelper {
    public static Type[] getParameterizedTypeArguments(Class<?> concrete, Class<?> classOrIface) {
        DeclaringClassInterfacePair declaringClassInterfacePair = GenericsClassHelper.getClass(concrete, classOrIface);
        if (null != declaringClassInterfacePair) {
            return GenericsClassHelper.getParameterizedTypeArguments(declaringClassInterfacePair);
        }
        return null;
    }

    private static Type[] getParameterizedTypeArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as = pt.getActualTypeArguments();
            Type[] ras = new Type[as.length];
            for (int i = 0; i < as.length; ++i) {
                ClassTypePair ctp;
                Type a = as[i];
                if (a instanceof Class) {
                    ras[i] = a;
                    continue;
                }
                if (a instanceof ParameterizedType) {
                    pt = (ParameterizedType)a;
                    ras[i] = a;
                    continue;
                }
                if (!(a instanceof TypeVariable) || null == (ctp = GenericsClassHelper.resolveTypeVariable(p.concreteClass, p.declaringClass, (TypeVariable)a))) continue;
                ras[i] = ctp.t;
            }
            return ras;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getClass(Class<?> concrete, Class<?> classOrIface) {
        return GenericsClassHelper.getClass(concrete, classOrIface, concrete);
    }

    private static DeclaringClassInterfacePair getClass(Class<?> concrete, Class<?> classOrIface, Class<?> c) {
        DeclaringClassInterfacePair p;
        Type[] gis = null;
        if (null != c.getGenericSuperclass()) {
            gis = new Type[]{c.getGenericSuperclass()};
        }
        if (null == gis) {
            gis = c.getGenericInterfaces();
        }
        if ((p = GenericsClassHelper.getType(concrete, classOrIface, c, gis)) != null) {
            return p;
        }
        if ((c = c.getSuperclass()) == null || c == Object.class) {
            return null;
        }
        return GenericsClassHelper.getClass(concrete, classOrIface, c);
    }

    private static DeclaringClassInterfacePair getType(Class<?> concrete, Class<?> classOrIface, Class<?> c, Type[] ts) {
        for (Type t : ts) {
            DeclaringClassInterfacePair p = GenericsClassHelper.getType(concrete, classOrIface, c, t);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getType(Class<?> concrete, Class<?> classOrIface, Class<?> c, Type t) {
        if (t instanceof Class) {
            if (t == classOrIface) {
                return new DeclaringClassInterfacePair(concrete, c, t);
            }
            return GenericsClassHelper.getClass(concrete, classOrIface, (Class)t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType() == classOrIface) {
                return new DeclaringClassInterfacePair(concrete, c, t);
            }
            return GenericsClassHelper.getClass(concrete, classOrIface, (Class)pt.getRawType());
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(Class<?> c, Class<?> dc, TypeVariable tv) {
        return GenericsClassHelper.resolveTypeVariable(c, dc, tv, new HashMap<TypeVariable, Type>());
    }

    private static ClassTypePair resolveTypeVariable(Class<?> c, Class<?> dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] gis;
        for (Type gi : gis = c.getGenericInterfaces()) {
            ParameterizedType pt;
            ClassTypePair ctp;
            if (!(gi instanceof ParameterizedType) || (ctp = GenericsClassHelper.resolveTypeVariable(pt = (ParameterizedType)gi, (Class)pt.getRawType(), dc, tv, map)) == null) continue;
            return ctp;
        }
        Type gsc = c.getGenericSuperclass();
        if (gsc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gsc;
            return GenericsClassHelper.resolveTypeVariable(pt, c.getSuperclass(), dc, tv, map);
        }
        if (gsc instanceof Class) {
            return GenericsClassHelper.resolveTypeVariable(c.getSuperclass(), dc, tv, map);
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(ParameterizedType pt, Class<?> c, Class<?> dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] typeArguments = pt.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeParameters = c.getTypeParameters();
        HashMap<TypeVariable, Type> submap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] instanceof TypeVariable) {
                Type t2 = map.get(typeArguments[i]);
                submap.put(typeParameters[i], t2);
                continue;
            }
            submap.put(typeParameters[i], typeArguments[i]);
        }
        if (c == dc) {
            Type t = (Type)submap.get(tv);
            if (t instanceof Class) {
                return new ClassTypePair((Class)t);
            }
            if (t instanceof GenericArrayType) {
                if ((t = ((GenericArrayType)t).getGenericComponentType()) instanceof Class) {
                    c = (Class)t;
                    try {
                        return new ClassTypePair(GenericsClassHelper.getArrayClass(c));
                    }
                    catch (Exception t2) {
                        return null;
                    }
                }
                if (t instanceof ParameterizedType) {
                    Type rt = ((ParameterizedType)t).getRawType();
                    if (!(rt instanceof Class)) {
                        return null;
                    }
                    c = (Class)rt;
                    try {
                        return new ClassTypePair(GenericsClassHelper.getArrayClass(c), t);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
            if (t instanceof ParameterizedType) {
                pt = (ParameterizedType)t;
                if (pt.getRawType() instanceof Class) {
                    return new ClassTypePair((Class)pt.getRawType(), pt);
                }
                return null;
            }
            return null;
        }
        return GenericsClassHelper.resolveTypeVariable(c, dc, tv, submap);
    }

    protected static Class<?> getClassOfType(Type type) {
        ParameterizedType subType;
        Type t;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type t2 = arrayType.getGenericComponentType();
            if (t2 instanceof Class) {
                return GenericsClassHelper.getArrayClass((Class)t2);
            }
        } else if (type instanceof ParameterizedType && (t = (subType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    private static Class<?> getArrayClass(Class<?> c) {
        try {
            Object o = Array.newInstance(c, 0);
            return o.getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class ClassTypePair {
        public final Type t;

        public ClassTypePair(Class<?> c) {
            this(c, c);
        }

        public ClassTypePair(Class<?> c, Type t) {
            this.t = t;
        }
    }

    private static class DeclaringClassInterfacePair {
        public final Class<?> concreteClass;
        public final Class<?> declaringClass;
        public final Type genericInterface;

        private DeclaringClassInterfacePair(Class<?> concreteClass, Class<?> declaringClass, Type genericInteface) {
            this.concreteClass = concreteClass;
            this.declaringClass = declaringClass;
            this.genericInterface = genericInteface;
        }
    }
}

