/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.querykeys;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public class ForeignReferenceQueryKey
extends QueryKey {
    protected Class<?> referenceClass;
    protected String referenceClassName;
    protected Expression joinCriteria;

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class referenceClass = null;
        try {
            if (this.referenceClassName != null) {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.referenceClassName, true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.referenceClassName, exception.getException());
                    }
                } else {
                    referenceClass = PrivilegedAccessHelper.getClassForName(this.referenceClassName, true, classLoader);
                }
            }
            this.setReferenceClass(referenceClass);
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.referenceClassName, exc);
        }
    }

    public Expression getJoinCriteria() {
        return this.joinCriteria;
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    @Override
    public boolean isForeignReferenceQueryKey() {
        return true;
    }

    public void setJoinCriteria(Expression joinCriteria) {
        this.joinCriteria = joinCriteria;
    }

    public void setReferenceClass(Class<?> referenceClass) {
        this.referenceClass = referenceClass;
    }

    public void setReferenceClassName(String referenceClassName) {
        this.referenceClassName = referenceClassName;
    }

    public DatabaseTable getSourceTable() {
        return this.descriptor.getTables().firstElement();
    }

    public DatabaseTable getReferenceTable(ClassDescriptor desc) {
        return desc.getTables().firstElement();
    }

    public DatabaseTable getRelationTable(ClassDescriptor referenceDescriptor) {
        ExpressionIterator expIterator = new ExpressionIterator(){

            @Override
            public void iterate(Expression each) {
                DatabaseField field;
                if (each.isTableExpression()) {
                    ((Collection)this.getResult()).add(((TableExpression)each).getTable());
                } else if (each.isDataExpression()) {
                    DatabaseField field2 = ((DataExpression)each).getField();
                    if (field2 != null && field2.hasTableName()) {
                        ((Collection)this.getResult()).add(field2.getTable());
                    }
                } else if (each.isParameterExpression() && (field = ((ParameterExpression)each).getField()) != null && field.hasTableName()) {
                    ((Collection)this.getResult()).add(field.getTable());
                }
            }
        };
        expIterator.setResult(new HashSet());
        expIterator.iterateOn(this.joinCriteria);
        HashSet tables = (HashSet)expIterator.getResult();
        DatabaseTable relationTable = null;
        for (DatabaseTable table : tables) {
            if (this.descriptor.getTables().contains(table) || referenceDescriptor.getTables().contains(table)) continue;
            relationTable = table;
            break;
        }
        return relationTable;
    }
}

