/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.json;

import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.filtering.EntityFilteringFeature;
import org.glassfish.jersey.moxy.internal.MoxyFilteringFeature;
import org.glassfish.jersey.moxy.json.internal.ConfigurableMoxyJsonProvider;
import org.glassfish.jersey.moxy.json.internal.FilteringMoxyJsonProvider;

public class MoxyJsonFeature
implements Feature {
    private static final String JSON_FEATURE = MoxyJsonFeature.class.getSimpleName();

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        if (CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.disableMoxyJson", Boolean.FALSE, Boolean.class).booleanValue()) {
            return false;
        }
        String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.jsonFeature", JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        int workerPriority = 7000;
        if (EntityFilteringFeature.enabled(config)) {
            context.register(MoxyFilteringFeature.class);
            context.register(FilteringMoxyJsonProvider.class, 7000);
        } else {
            context.register(ConfigurableMoxyJsonProvider.class, 7000);
        }
        return true;
    }
}

