/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AgentInterfaceConfig;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.RESTAgentConfig;
import es.bsc.compss.agent.rest.RESTAgentConf;
import es.bsc.compss.agent.rest.RESTAppMonitor;
import es.bsc.compss.agent.rest.RESTServiceLauncher;
import es.bsc.compss.agent.rest.types.ApplicationParameterImpl;
import es.bsc.compss.agent.rest.types.RESTAgentRequestListener;
import es.bsc.compss.agent.rest.types.RESTResult;
import es.bsc.compss.agent.rest.types.TaskProfile;
import es.bsc.compss.agent.rest.types.messages.EndApplicationNotification;
import es.bsc.compss.agent.rest.types.messages.IncreaseNodeNotification;
import es.bsc.compss.agent.rest.types.messages.LostNodeNotification;
import es.bsc.compss.agent.rest.types.messages.ReduceNodeRequest;
import es.bsc.compss.agent.rest.types.messages.RemoveNodeRequest;
import es.bsc.compss.agent.rest.types.messages.StartApplicationRequest;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.agent.util.RemoteJobsRegistry;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.implementations.ExecType;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/COMPSs")
public class RESTAgent
implements AgentInterface<RESTAgentConf> {
    private static final String UNSUPPORTED_LANGUAGE_MSG = "Unsupported language.";
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Agent");
    private int port;
    private Server server = null;

    public RESTAgentConf configure(JSONObject confJSON) throws AgentException {
        RESTAgentConf conf;
        try {
            String portSTR = confJSON.getString("PORT");
            portSTR = EnvironmentLoader.loadFromEnvironment((String)portSTR);
            int port = Integer.parseInt(portSTR);
            if (port <= 0) {
                throw new AgentException("Invalid port number for REST agent's interface.");
            }
            conf = new RESTAgentConf(this, port);
        }
        catch (Exception e) {
            LOGGER.error("Error configuring agent", (Throwable)e);
            throw new AgentException((Throwable)e);
        }
        return conf;
    }

    public synchronized void start(RESTAgentConf args) throws AgentException {
        if (this.server != null) {
            return;
        }
        RESTServiceLauncher launcher = null;
        try {
            this.port = args.getPort();
            RESTAgentConfig.localAgentPort = this.port;
            launcher = new RESTServiceLauncher(this.port);
            new Thread(launcher).start();
            launcher.waitForBoot();
        }
        catch (Exception e) {
            throw new AgentException((Throwable)e);
        }
        if (launcher.getStartError() != null) {
            throw new AgentException((Throwable)launcher.getStartError());
        }
        this.server = launcher.getServer();
    }

    public synchronized void stop() {
        if (this.server != null) {
            new Thread(){

                @Override
                public void run() {
                    Thread.currentThread().setName("REST Agent Service Stopper");
                    try {
                        Thread.sleep(500L);
                        RESTAgent.this.server.stop();
                        LOGGER.debug("REST Service Agent Interface stopped");
                    }
                    catch (Exception ex) {
                        ErrorManager.warn((String)("Could not stop the REST server for the Agent at port " + RESTAgent.this.port), (Exception)ex);
                        if (!RESTAgent.this.server.isStopped()) {
                            RESTAgent.this.server.destroy();
                        }
                    }
                    finally {
                        RESTAgent.this.server = null;
                    }
                }
            }.start();
        }
    }

    @DELETE
    public Response powerOff() {
        Agent.stop();
        LOGGER.info("Agent was shutdown");
        return Response.ok().build();
    }

    @GET
    @Path(value="test/")
    public Response test() {
        System.out.println("test invoked");
        return Response.ok().build();
    }

    @GET
    @Path(value="resources/")
    @Produces(value={"application/json"})
    public Response getResources() {
        System.out.println("Requested current resource configuraction");
        JSONObject root = new JSONObject();
        root.put("time", System.currentTimeMillis());
        JSONArray resources = new JSONArray();
        root.put("resources", (Object)resources);
        for (Worker worker : ResourceManager.getAllWorkers()) {
            JSONObject workerJSON = new JSONObject();
            resources.put((Object)workerJSON);
            workerJSON.put("name", (Object)worker.getName());
            JSONObject descriptionJSON = new JSONObject();
            workerJSON.put("description", (Object)descriptionJSON);
            WorkerResourceDescription description = worker.getDescription();
            if (description instanceof MethodResourceDescription) {
                MethodResourceDescription mrd = (MethodResourceDescription)description;
                JSONArray processors = new JSONArray();
                descriptionJSON.put("processors", (Object)processors);
                for (Processor processor : mrd.getProcessors()) {
                    JSONObject processorJSON = new JSONObject();
                    processors.put((Object)processorJSON);
                    processorJSON.put("name", (Object)processor.getName());
                    processorJSON.put("architecture", (Object)processor.getArchitecture());
                    processorJSON.put("units", processor.getComputingUnits());
                }
                descriptionJSON.put("memory_size", mrd.getMemorySize());
                descriptionJSON.put("memory_type", (Object)mrd.getMemoryType());
                descriptionJSON.put("storage_size", mrd.getStorageSize());
                descriptionJSON.put("storage_type", (Object)mrd.getStorageType());
                descriptionJSON.put("storage_bandwidth", mrd.getStorageBW());
            }
            workerJSON.put("adaptor", (Object)worker.getNode().getClass().getCanonicalName());
        }
        return Response.ok((Object)root.toString(), "text/plain").build();
    }

    @GET
    @Path(value="printResources/")
    public Response printResources() {
        System.out.println(ResourceManager.getCurrentState((String)""));
        return Response.ok().build();
    }

    @PUT
    @Path(value="addResources/")
    @Consumes(value={"application/xml"})
    public Response addResource(IncreaseNodeNotification nodeRequest) {
        Resource<?, ?> r = nodeRequest.getResource();
        MethodResourceDescription description = r.getDescription();
        List procs = description.getProcessors();
        description.setProcessors(procs);
        try {
            Agent.addResources(r);
        }
        catch (AgentException ex) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(ex.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="removeResources/")
    @Consumes(value={"application/xml"})
    public Response removeResources(ReduceNodeRequest request) {
        String name = request.getWorkerName();
        MethodResourceDescription mrd = request.getResources();
        List procs = mrd.getProcessors();
        mrd.setProcessors(procs);
        try {
            Agent.removeResources((String)name, (MethodResourceDescription)mrd);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="removeNode/")
    @Consumes(value={"application/xml"})
    public Response removeResource(RemoveNodeRequest request) {
        String name = request.getWorkerName();
        try {
            Agent.removeNode((String)name);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="lostNode/")
    @Consumes(value={"application/xml"})
    public Response lostResource(LostNodeNotification notification) {
        String name = notification.getWorkerName();
        try {
            Agent.lostNode((String)name);
        }
        catch (AgentException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="startApplication/")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response startApplication(StartApplicationRequest request) {
        Response response;
        System.out.println("Received REST call to run a " + request.getLang() + " method");
        try {
            response = this.runTask(request);
        }
        catch (Exception e) {
            response = Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return response;
    }

    private Response runTask(StartApplicationRequest request) {
        long appId;
        ApplicationParameter[] results;
        COMPSsConstants.Lang lang;
        try {
            lang = COMPSsConstants.Lang.valueOf((String)request.getLang().toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return Response.status(Response.Status.NOT_ACCEPTABLE).entity(UNSUPPORTED_LANGUAGE_MSG).build();
        }
        String className = request.getClassName();
        String methodName = request.getMethodName();
        String ceiClass = request.getCeiClass();
        ApplicationParameter[] arguments = request.getParams();
        ApplicationParameterImpl target = request.getTarget();
        boolean hasResult = request.isHasResult();
        if (hasResult) {
            results = new ApplicationParameterImpl[1];
            results[1] = new ApplicationParameterImpl(null, Direction.IN, DataType.OBJECT_T, StdIOStream.UNSPECIFIED, "", "result", "", 1.0, false);
        } else {
            results = new ApplicationParameterImpl[]{};
        }
        RESTAgentRequestListener requestListener = request.getRequestListener();
        RESTAppMonitor monitor = new RESTAppMonitor(arguments, target, results, this, requestListener);
        StringBuilder typesSB = new StringBuilder();
        LOGGER.debug("Handles parameters:");
        for (ApplicationParameter param : arguments) {
            LOGGER.debug("\t Parameter:" + param.getParamName());
            if (typesSB.length() > 0) {
                typesSB.append(",");
            }
            if (param.getType() != DataType.PSCO_T) {
                typesSB.append(param.getType().toString());
                continue;
            }
            typesSB.append("OBJECT_T");
        }
        String paramsTypes = typesSB.toString();
        String ceSignature = methodName + "(" + paramsTypes + ")";
        String implSignature = methodName + "(" + paramsTypes + ")" + className;
        String[] typeArgs = new String[]{className, methodName};
        MethodResourceDescription requirements = MethodResourceDescription.EMPTY_FOR_CONSTRAINTS;
        CoreElementDefinition ced = new CoreElementDefinition();
        ced.setCeSignature(ceSignature);
        ImplementationDescription implDef = ImplementationDescription.defineImplementation((String)"METHOD", (String)implSignature, (boolean)false, (WorkerResourceDescription)requirements, (ExecType)request.getProlog(), (ExecType)request.getEpilog(), null, (String[])typeArgs);
        ced.addImplementation(implDef);
        try {
            appId = Agent.runTask((COMPSsConstants.Lang)lang, (CoreElementDefinition)ced, (String)ceiClass, (ApplicationParameter[])arguments, (ApplicationParameter)target, (ApplicationParameter[])results, (AppMonitor)monitor, (OnFailure)OnFailure.FAIL);
            LOGGER.info("External job - is app " + appId);
        }
        catch (AgentException e) {
            LOGGER.error("ERROR IN runTask : ", (Throwable)e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e.getMessage()).build();
        }
        return Response.ok((Object)appId, "text/plain").build();
    }

    @PUT
    @Path(value="endApplication/")
    @Consumes(value={"application/xml"})
    public Response endApplication(EndApplicationNotification notification) {
        try {
            String jobId = notification.getJobId();
            JobEndStatus endStatus = notification.getEndStatus();
            RESTResult[] resultsLocations = notification.getResults();
            TaskProfile profile = notification.getProfile();
            RemoteJobsRegistry.notifyJobEnd(jobId, endStatus, resultsLocations, profile);
            return Response.ok().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity(e).build();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        RESTAgent ra = new RESTAgent();
        RESTAgentConf config = new RESTAgentConf(ra, port);
        Agent.startInterface((AgentInterfaceConfig)config);
        Agent.start();
    }
}

