/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.types.COMPSsMaster;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class MasterResource
extends Resource {
    protected static final String ERROR_COMPSs_LOG_BASE_DIR = "ERROR: Cannot create .COMPSs base log directory";
    protected static final String ERROR_APP_OVERLOAD = "ERROR: Cannot erase overloaded directory";
    protected static final String ERROR_APP_LOG_DIR = "ERROR: Cannot create application log directory";
    protected static final String ERROR_TEMP_DIR = "ERROR: Cannot create temp directory";
    protected static final String ERROR_JOBS_DIR = "ERROR: Cannot create jobs directory";
    protected static final String ERROR_WORKERS_DIR = "ERROR: Cannot create workers directory";
    protected static final String WARN_FOLDER_OVERLOAD = "WARNING: Reached maximum number of executions for this application. To avoid this warning please clean .COMPSs folder";
    protected static final int MAX_OVERLOAD = 100;
    private final String userExecutionDirPath = System.getProperty("user.dir");
    private final String COMPSsLogBaseDirPath;
    private final String appLogDirPath;
    private final String tempDirPath;
    private final String jobsDirPath;
    private final String workersDirPath;

    public MasterResource() {
        super(new COMPSsMaster(), null);
        boolean mustCreateExecutionSandbox = true;
        String specificOpt = System.getProperty("compss.specificLogDir");
        if (specificOpt != null && !specificOpt.isEmpty()) {
            this.COMPSsLogBaseDirPath = specificOpt.endsWith(File.separator) ? specificOpt : specificOpt + File.separator;
            mustCreateExecutionSandbox = false;
        } else {
            String baseOpt = System.getProperty("compss.baseLogDir");
            if (baseOpt != null && !baseOpt.isEmpty()) {
                baseOpt = baseOpt.endsWith(File.separator) ? baseOpt : baseOpt + File.separator;
                this.COMPSsLogBaseDirPath = baseOpt + ".COMPSs" + File.separator;
            } else {
                this.COMPSsLogBaseDirPath = System.getProperty("user.home") + File.separator + ".COMPSs" + File.separator;
            }
        }
        if (!new File(this.COMPSsLogBaseDirPath).exists() && !new File(this.COMPSsLogBaseDirPath).mkdir()) {
            ErrorManager.error((String)ERROR_COMPSs_LOG_BASE_DIR);
        }
        if (mustCreateExecutionSandbox) {
            String appName = System.getProperty("compss.appName");
            if (System.getProperty("compss.serviceName") != null) {
                String appLog;
                String serviceName = System.getProperty("compss.serviceName");
                int overloadCode = 1;
                String oldest = appLog = this.COMPSsLogBaseDirPath + serviceName + "_0" + String.valueOf(overloadCode) + File.separator;
                while (new File(appLog).exists() && overloadCode <= 100) {
                    if (new File(oldest).lastModified() > new File(appLog).lastModified()) {
                        oldest = appLog;
                    }
                    if (++overloadCode < 10) {
                        appLog = this.COMPSsLogBaseDirPath + serviceName + "_0" + String.valueOf(overloadCode) + File.separator;
                        continue;
                    }
                    appLog = this.COMPSsLogBaseDirPath + serviceName + "_" + String.valueOf(overloadCode) + File.separator;
                }
                if (overloadCode > 100) {
                    appLog = oldest;
                    System.err.println(WARN_FOLDER_OVERLOAD);
                    System.err.println("Overwriting entry: " + appLog);
                    if (!this.deleteDirectory(new File(appLog))) {
                        ErrorManager.error((String)ERROR_APP_OVERLOAD);
                    }
                }
                this.appLogDirPath = appLog;
                if (!new File(this.appLogDirPath).mkdir()) {
                    ErrorManager.error((String)ERROR_APP_LOG_DIR);
                }
            } else {
                String appLog;
                int overloadCode = 1;
                String oldest = appLog = this.COMPSsLogBaseDirPath + appName + "_0" + String.valueOf(overloadCode) + File.separator;
                while (new File(appLog).exists() && overloadCode <= 100) {
                    if (new File(oldest).lastModified() > new File(appLog).lastModified()) {
                        oldest = appLog;
                    }
                    if (++overloadCode < 10) {
                        appLog = this.COMPSsLogBaseDirPath + appName + "_0" + String.valueOf(overloadCode) + File.separator;
                        continue;
                    }
                    appLog = this.COMPSsLogBaseDirPath + appName + "_" + String.valueOf(overloadCode) + File.separator;
                }
                if (overloadCode > 100) {
                    appLog = oldest;
                    System.err.println(WARN_FOLDER_OVERLOAD);
                    System.err.println("Overwriting entry: " + appLog);
                    if (!this.deleteDirectory(new File(appLog))) {
                        ErrorManager.error((String)ERROR_APP_OVERLOAD);
                    }
                }
                this.appLogDirPath = appLog;
                if (!new File(this.appLogDirPath).mkdir()) {
                    ErrorManager.error((String)ERROR_APP_LOG_DIR);
                }
            }
        } else {
            this.appLogDirPath = this.COMPSsLogBaseDirPath;
        }
        System.setProperty("compss.appLogDir", this.appLogDirPath);
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        this.tempDirPath = this.appLogDirPath + "tmpFiles" + File.separator;
        if (!new File(this.tempDirPath).mkdir()) {
            ErrorManager.error((String)ERROR_TEMP_DIR);
        }
        this.jobsDirPath = this.appLogDirPath + "jobs" + File.separator;
        if (!new File(this.jobsDirPath).mkdir()) {
            ErrorManager.error((String)ERROR_JOBS_DIR);
        }
        this.workersDirPath = this.appLogDirPath + "workers" + File.separator;
        if (!new File(this.workersDirPath).mkdir()) {
            System.err.println(ERROR_WORKERS_DIR);
            System.exit(1);
        }
    }

    private boolean deleteDirectory(File directory) {
        if (!directory.exists()) {
            return false;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    continue;
                }
                if (f.delete()) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public String getCOMPSsLogBaseDirPath() {
        return this.COMPSsLogBaseDirPath;
    }

    public String getWorkingDirectory() {
        return this.tempDirPath;
    }

    public String getUserExecutionDirPath() {
        return this.userExecutionDirPath;
    }

    public String getAppLogDirPath() {
        return this.appLogDirPath;
    }

    public String getTempDirPath() {
        return this.tempDirPath;
    }

    public String getJobsDirPath() {
        return this.jobsDirPath;
    }

    public String getWorkersDirPath() {
        return this.workersDirPath;
    }

    @Override
    public void setInternalURI(MultiURI u) {
        for (CommAdaptor adaptor : Comm.getAdaptors().values()) {
            adaptor.completeMasterURI(u);
        }
    }

    @Override
    public Resource.Type getType() {
        return Resource.Type.MASTER;
    }

    @Override
    public int compareTo(Resource t) {
        if (t.getType() == Resource.Type.MASTER) {
            return this.getName().compareTo(t.getName());
        }
        return 1;
    }

    public void updateSharedDisk(Map<String, String> sharedDisks) {
        this.sharedDisks = sharedDisks;
    }
}

