/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation.copy;

import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.util.ErrorManager;
import java.util.concurrent.Semaphore;

public abstract class Copy
extends DataOperation {
    protected final LogicalData srcData;
    protected final DataLocation srcLoc;
    protected final LogicalData tgtData;
    protected DataLocation tgtLoc;
    protected final Transferable reason;

    public Copy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, EventListener listener) {
        super(srcData, listener);
        this.srcData = srcData;
        this.srcLoc = prefSrc;
        this.tgtData = tgtData;
        this.tgtLoc = prefTgt;
        this.reason = reason;
        if (DEBUG) {
            LOGGER.debug("Created copy " + this.getName() + " (id: " + this.getId() + ")");
        }
    }

    public LogicalData getSourceData() {
        return this.srcData;
    }

    public DataLocation getPreferredSource() {
        return this.srcLoc;
    }

    public DataLocation getTargetLoc() {
        return this.tgtLoc;
    }

    public LogicalData getTargetData() {
        return this.tgtData;
    }

    public boolean isRegistered() {
        return this.tgtData != null;
    }

    public void setProposedSource(Object source) {
        this.reason.setDataSource(source);
    }

    public void setFinalTarget(String targetAbsolutePath) {
        if (DEBUG) {
            LOGGER.debug(" Setting copy final target to : " + targetAbsolutePath);
        }
        this.reason.setDataTarget(targetAbsolutePath);
    }

    public String getFinalTarget() {
        return this.reason.getDataTarget();
    }

    public DataType getType() {
        return this.reason.getType();
    }

    public static void waitForCopyTofinish(Copy copy, COMPSsNode resource) {
        Semaphore sem = new Semaphore(0);
        SafeCopyListener currentCopylistener = new SafeCopyListener(sem);
        copy.addEventListener(currentCopylistener);
        currentCopylistener.addOperation();
        currentCopylistener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            ErrorManager.warn((String)("Error waiting for files in resource " + resource.getName() + " to get saved"));
            Thread.currentThread().interrupt();
        }
        if (DEBUG) {
            LOGGER.debug("Copy " + copy.getName() + "(id: " + copy.getId() + ") is finished");
        }
    }
}

