/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.types;

import es.bsc.compss.util.types.PrvLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadTranslator {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    private List<Map<Integer, String>> machineRuntimeIdentifiers = new ArrayList<Map<Integer, String>>();
    private List<Set<String>> machineThreads = new ArrayList<Set<String>>();
    private List<Set<String>> machineExecutors = new ArrayList<Set<String>>();
    private List<Set<String>> translatedMachineUnknowns = new ArrayList<Set<String>>();
    public Map<String, String> threadTranslations;

    public void addThread(String threadId, String threadTypeIdString) {
        int machineId = Integer.parseInt(PrvLine.getNodeId(threadId));
        while (this.machineThreads.size() < machineId) {
            this.machineThreads.add(new HashSet());
            this.machineExecutors.add(new HashSet());
            this.translatedMachineUnknowns.add(new HashSet());
            this.machineRuntimeIdentifiers.add(new HashMap());
        }
        this.machineThreads.get(machineId - 1).add(threadId);
        if (threadTypeIdString != null) {
            Integer threadTypeId = new Integer(threadTypeIdString);
            if (threadTypeId == 8) {
                this.machineExecutors.get(machineId - 1).add(threadId);
            } else if (threadTypeId != 0) {
                this.machineRuntimeIdentifiers.get(machineId - 1).put(threadTypeId, threadId);
            }
        }
    }

    public Map<String, String> createThreadTranslationMap() {
        this.threadTranslations = new HashMap<String, String>();
        for (int i = 0; i < this.machineRuntimeIdentifiers.size(); ++i) {
            String newThread;
            String iString = Integer.toString(i + 1);
            this.threadTranslations.put("1:" + iString + ":1", iString + ":1:1");
            Map<Integer, String> runtimeIdentifiers = this.machineRuntimeIdentifiers.get(i);
            Set<String> runtimeList = this.machineThreads.get(i);
            Set<String> executorList = this.machineExecutors.get(i);
            Set<String> translatedUnknownList = this.translatedMachineUnknowns.get(i);
            int runtimeThreadsNum = 2;
            for (int ident = 0; ident < 8; ++ident) {
                if (!runtimeIdentifiers.containsKey(ident)) continue;
                String oldThread = runtimeIdentifiers.get(ident);
                String newThread2 = PrvLine.changeThreadNumber(oldThread, runtimeThreadsNum++);
                newThread2 = PrvLine.moveNodeIdToFirstPosition(newThread2);
                newThread2 = PrvLine.changeRuntimeNumber(newThread2, true);
                this.threadTranslations.put(oldThread, newThread2);
            }
            int executorsNum = 1;
            for (String oldThread : executorList) {
                newThread = PrvLine.changeThreadNumber(oldThread, executorsNum++);
                newThread = PrvLine.moveNodeIdToFirstPosition(newThread);
                newThread = PrvLine.changeRuntimeNumber(newThread, false);
                this.threadTranslations.put(oldThread, newThread);
            }
            for (String oldThread : runtimeList) {
                if (this.threadTranslations.containsKey(oldThread)) continue;
                newThread = PrvLine.changeThreadNumber(oldThread, runtimeThreadsNum++);
                newThread = PrvLine.moveNodeIdToFirstPosition(newThread);
                newThread = PrvLine.changeRuntimeNumber(newThread, true);
                translatedUnknownList.add(newThread);
                this.threadTranslations.put(oldThread, newThread);
            }
        }
        return this.threadTranslations;
    }

    private String createLabel(String threadId, int identifierEvent) {
        String label;
        switch (identifierEvent) {
            case 2: {
                label = "RUNTIME AP";
                break;
            }
            case 3: {
                label = "RUNTIME TD";
                break;
            }
            case 4: {
                label = "RUNTIME FS L";
                break;
            }
            case 5: {
                label = "RUNTIME FS H";
                break;
            }
            case 6: {
                label = "RUNTIME TIMER";
                break;
            }
            case 7: {
                label = "RUNTIME WALLCLOCK";
                break;
            }
            case 8: {
                label = "EXECUTOR";
                break;
            }
            default: {
                label = "";
            }
        }
        return label + " (" + threadId + ")";
    }

    public List<String> getRowLabels() throws Exception {
        if (this.threadTranslations == null) {
            throw new Exception("createThreadTranslationMap() must be created before invocking createLabelTranslationMap()");
        }
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("MAIN APP (1.1.1)");
        for (int i = 1; i < this.machineRuntimeIdentifiers.size(); ++i) {
            String string = Integer.toString(i + 1);
            labels.add("WORKER MAIN (" + string + ".1.1)");
        }
        for (Map<Integer, String> map : this.machineRuntimeIdentifiers) {
            for (Map.Entry<Integer, String> identifier : map.entrySet()) {
                int eventIdentifier = identifier.getKey();
                String newThreadId = this.threadTranslations.get(identifier.getValue()).replace(":", ".");
                String newLabel = this.createLabel(newThreadId, eventIdentifier);
                labels.add(newLabel);
            }
        }
        for (Set set : this.machineExecutors) {
            for (String exec : set) {
                String newThreadId = this.threadTranslations.get(exec).replace(":", ".");
                String newLabel = this.createLabel(newThreadId, 8);
                labels.add(newLabel);
            }
        }
        for (Set set : this.translatedMachineUnknowns) {
            for (String unkn : set) {
                labels.add("THREAD " + unkn.replace(":", "."));
            }
        }
        return labels;
    }

    public int[] createRuntimeThreadNumberPerApp() {
        int[] result = new int[this.machineRuntimeIdentifiers.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.machineThreads.get(i).size() - this.machineExecutors.get(i).size();
        }
        return result;
    }
}

