/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrvLine {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    public static final int EVENT_TYPE = 0;
    public static final int TIMESTAMP_POS = 5;
    public static final int STATE_MACHINE_POS = 2;
    public static final int STATE_RUNTIME_EXECUTOR_POS = 3;
    public static final int STATE_THREAD_NUMBER_POS = 4;
    public static final int STATE_EVENTS_START_POS = 6;
    public static final int COM_SEND_MACHINE_POS = 2;
    public static final int COM_SEND_RUNTIME_EXECUTOR_POS = 3;
    public static final int COM_SEND_THREAD_NUMBER_POS = 4;
    public static final int COM_RECIV_MACHINE_POS = 8;
    public static final int COM_RECIV_RUNTIME_EXECUTOR_POS = 9;
    public static final int COM_RECIV_THREAD_NUMBER_POS = 10;
    private String[] values;

    public PrvLine(String line) throws Exception {
        this.values = line.split(":");
    }

    public void setAgentNumber(String s) {
        this.values[2] = s;
    }

    public String getStateLineThreadIdentifier() {
        return this.values[2] + ":" + this.values[3] + ":" + this.values[4];
    }

    private void setStateLineThreadIdentifier(String s) throws Exception {
        String[] threadId = s.split(":");
        if (threadId.length != 3) {
            throw new Exception("Malformed thread identifier (wrong number of parts): " + s);
        }
        this.values[2] = threadId[0];
        this.values[3] = threadId[1];
        this.values[4] = threadId[2];
    }

    private String getComSenderThreadIdentifier() {
        return this.values[2] + ":" + this.values[3] + ":" + this.values[4];
    }

    private void setComSenderThreadIdentifier(String s) throws Exception {
        String[] threadId = s.split(":");
        if (threadId.length != 3) {
            throw new Exception("Malformed thread identifier (wrong number of parts): " + s);
        }
        this.values[2] = threadId[0];
        this.values[3] = threadId[1];
        this.values[4] = threadId[2];
    }

    private String getComRecivThreadIdentifier() {
        return this.values[8] + ":" + this.values[9] + ":" + this.values[10];
    }

    private void setComRecivThreadIdentifier(String s) throws Exception {
        String[] threadId = s.split(":");
        if (threadId.length != 3) {
            throw new Exception("Malformed thread identifier (wrong number of parts): " + s);
        }
        this.values[8] = threadId[0];
        this.values[9] = threadId[1];
        this.values[10] = threadId[2];
    }

    public Map<String, String> getEvents() {
        HashMap<String, String> result = new HashMap<String, String>();
        if ("3".equals(this.values[0])) {
            return result;
        }
        for (int i = 6; i < this.values.length; i += 2) {
            result.put(this.values[i], this.values[i + 1]);
        }
        return result;
    }

    public void translateLineToGlobalIndex(String eventGroupIdentifier, Map<String, String> globalIndex, Map<String, String> localIndex) {
        for (int i = 6; i < this.values.length; i += 2) {
            String globalValue;
            if (!eventGroupIdentifier.equals(this.values[i])) continue;
            String eventValue = this.values[i + 1];
            String eventIdentifier = localIndex.get(eventValue);
            this.values[i + 1] = globalValue = globalIndex.get(eventIdentifier);
        }
    }

    public static String moveNodeIdToFirstPosition(String threadId) {
        CharSequence[] thValues = threadId.split(":");
        thValues[0] = thValues[1];
        thValues[1] = "1";
        return String.join((CharSequence)":", thValues);
    }

    public String toString() {
        return String.join((CharSequence)":", this.values);
    }

    public void translateLineThreads(Map<String, String> translations) throws Exception {
        if (!"3".equals(this.values[0])) {
            String oldThreadId = this.getStateLineThreadIdentifier();
            if (translations.containsKey(oldThreadId)) {
                this.setStateLineThreadIdentifier(translations.get(oldThreadId));
            }
        } else {
            String recivThreadId;
            String senderThreadId = this.getComSenderThreadIdentifier();
            if (translations.containsKey(senderThreadId)) {
                this.setComSenderThreadIdentifier(translations.get(senderThreadId));
            }
            if (translations.containsKey(recivThreadId = this.getComRecivThreadIdentifier())) {
                this.setComRecivThreadIdentifier(translations.get(recivThreadId));
            }
        }
    }

    public boolean goesBefore(String otherLine) throws Exception {
        if (otherLine == null) {
            return false;
        }
        return this.goesBefore(new PrvLine(otherLine));
    }

    public boolean goesBefore(PrvLine otherLine) {
        int typeB;
        long timeB;
        long timeA = new Long(this.values[5]);
        if (timeA < (timeB = new Long(otherLine.values[5]).longValue())) {
            return true;
        }
        if (timeA > timeB) {
            return false;
        }
        int typeA = new Integer(this.values[0]);
        return typeA <= (typeB = new Integer(otherLine.values[0]).intValue());
    }

    public static String getNodeId(String threadId) {
        String[] threadValues = threadId.split(":");
        return threadValues[1];
    }

    public static String changeThreadNumber(String threadId, int n) {
        String[] threadValues = threadId.split(":");
        return threadValues[0] + ":" + threadValues[1] + ":" + Integer.toString(n);
    }

    public static String changeRuntimeNumber(String threadId, boolean b) {
        String[] threadValues = threadId.split(":");
        if (b) {
            return threadValues[0] + ":" + "1" + ":" + threadValues[2];
        }
        return threadValues[0] + ":" + "2" + ":" + threadValues[2];
    }
}

