/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation;

import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.operation.OperationEndState;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataOperation {
    private static int opCount = 0;
    private final int operationId;
    private final List<EventListener> listeners;
    private OperationEndState endState = null;
    private Exception endException = null;
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private String name;

    public DataOperation(LogicalData ld, EventListener listener) {
        this.name = ld.getName();
        this.listeners = new LinkedList<EventListener>();
        this.listeners.add(listener);
        this.operationId = opCount++;
    }

    public DataOperation(LogicalData ld, List<EventListener> eventListeners) {
        this.name = ld.getName();
        this.listeners = eventListeners;
        this.operationId = opCount++;
    }

    public int getId() {
        return this.operationId;
    }

    public String getName() {
        return this.name;
    }

    public List<EventListener> getEventListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener eventListener) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            if (this.endState == null) {
                this.listeners.add(eventListener);
            } else {
                switch (this.endState) {
                    case OP_OK: {
                        eventListener.notifyEnd(this);
                        break;
                    }
                    case OP_IN_PROGRESS: {
                        break;
                    }
                    case OP_WAITING_SOURCES: {
                        break;
                    }
                    default: {
                        eventListener.notifyFailure(this, this.endException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListeners(List<EventListener> eventListeners) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            if (this.endState == null) {
                this.listeners.addAll(eventListeners);
            } else {
                switch (this.endState) {
                    case OP_OK: {
                        for (EventListener eventListener : eventListeners) {
                            eventListener.notifyEnd(this);
                        }
                        break;
                    }
                    case OP_IN_PROGRESS: {
                        break;
                    }
                    case OP_WAITING_SOURCES: {
                        break;
                    }
                    default: {
                        for (EventListener eventListener : eventListeners) {
                            eventListener.notifyFailure(this, this.endException);
                        }
                    }
                }
            }
        }
    }

    public void end(OperationEndState state) {
        this.notifyEnd(state, null);
    }

    public void end(OperationEndState state, Exception e) {
        this.notifyEnd(state, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEnd(OperationEndState state, Exception e) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            this.endState = state;
            this.endException = e;
            switch (state) {
                case OP_OK: {
                    for (EventListener listener : this.listeners) {
                        listener.notifyEnd(this);
                    }
                    break;
                }
                case OP_IN_PROGRESS: {
                    break;
                }
                case OP_WAITING_SOURCES: {
                    break;
                }
                default: {
                    for (EventListener listener : this.listeners) {
                        listener.notifyFailure(this, e);
                    }
                }
            }
        }
    }

    public abstract void perform();
}

