/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.comm;

import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.exceptions.NonInstantiableException;
import es.bsc.compss.types.resources.MasterResource;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.Classpath;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.exceptions.DistroStreamClientInitException;
import es.bsc.distrostreamlib.requests.Request;
import es.bsc.distrostreamlib.requests.StopRequest;
import es.bsc.distrostreamlib.server.DistroStreamServer;
import es.bsc.distrostreamlib.server.types.StreamBackend;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public class Comm {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final StreamBackend STREAMING_BACKEND;
    private static final String STREAMING_MASTER_NAME;
    private static final int DEFAULT_STREAMING_PORT = 49049;
    private static final int STREAMING_PORT;
    private static final String STORAGE_CONF;
    private static final String ADAPTORS_REL_PATH;
    private static final Map<String, CommAdaptor> ADAPTORS;
    private static final Map<String, LogicalData> DATA;
    private static MasterResource appHost;

    private Comm() {
        throw new NonInstantiableException("Comm");
    }

    public static void init(MasterResource master) {
        appHost = master;
        Comm.loadAdaptorsJars();
        if (System.getProperty("compss.tracing") != null && Integer.parseInt(System.getProperty("compss.tracing")) != 0) {
            int tracingLevel = Integer.parseInt(System.getProperty("compss.tracing"));
            LOGGER.debug("Tracing is activated [" + tracingLevel + ']');
            Tracer.init((String)Comm.getAppHost().getAppLogDirPath(), (int)tracingLevel);
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent((long)TraceEvent.STATIC_IT.getId(), (int)TraceEvent.STATIC_IT.getType());
            }
        }
        if (STREAMING_BACKEND.equals((Object)StreamBackend.NONE)) {
            LOGGER.warn("No streaming backend passed");
        } else {
            String dsMaster;
            LOGGER.info("Initializing DS Library for type " + STREAMING_BACKEND.name());
            String compssMaster = appHost.getName();
            if (STREAMING_MASTER_NAME == null || STREAMING_MASTER_NAME == compssMaster) {
                dsMaster = compssMaster;
                LOGGER.debug("Initializing Streaming Server");
                DistroStreamServer.initAndStart((String)dsMaster, (Integer)STREAMING_PORT, (StreamBackend)STREAMING_BACKEND);
            } else {
                LOGGER.debug("Streaming Server marked as remote");
                LOGGER.debug("Skiping Streaming Server initialization");
                dsMaster = STREAMING_MASTER_NAME;
            }
            LOGGER.debug("Initializing Streaming Client");
            try {
                DistroStreamClient.initAndStart((String)dsMaster, (int)STREAMING_PORT);
            }
            catch (DistroStreamClientInitException dscie) {
                ErrorManager.fatal((String)"Error initializing DS client", (Exception)((Object)dscie));
            }
        }
        if (STORAGE_CONF == null) {
            LOGGER.warn("No storage configuration file passed");
        } else {
            LOGGER.debug("Initializing Storage with: " + STORAGE_CONF);
            try {
                StorageItf.init((String)STORAGE_CONF);
            }
            catch (StorageException e) {
                ErrorManager.fatal((String)("Error loading storage configuration file: " + STORAGE_CONF), (Exception)((Object)e));
            }
        }
    }

    public static void registerAdaptor(String adaptorName, CommAdaptor adaptor) {
        ADAPTORS.put(adaptorName, adaptor);
    }

    public static CommAdaptor getAdaptor(String adaptorName) {
        return ADAPTORS.get(adaptorName);
    }

    public static Map<String, CommAdaptor> getAdaptors() {
        return ADAPTORS;
    }

    public static Configuration constructConfiguration(String adaptorName, Map<String, Object> projectProperties, Map<String, Object> resourcesProperties) throws ConstructConfigurationException {
        CommAdaptor adaptor = ADAPTORS.get(adaptorName);
        if (adaptor == null) {
            try {
                Constructor<?> constrAdaptor = Class.forName(adaptorName).getConstructor(new Class[0]);
                adaptor = (CommAdaptor)constrAdaptor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ConstructConfigurationException(e);
            }
            adaptor.init();
            ADAPTORS.put(adaptorName, adaptor);
        }
        if (DEBUG) {
            LOGGER.debug("Adaptor Name: " + adaptorName);
        }
        return adaptor.constructConfiguration(projectProperties, resourcesProperties);
    }

    public static MasterResource getAppHost() {
        return appHost;
    }

    public static int getStreamingPort() {
        return STREAMING_PORT;
    }

    public static StreamBackend getStreamingBackend() {
        return STREAMING_BACKEND;
    }

    public static COMPSsWorker initWorker(Configuration config) {
        String adaptorName = config.getAdaptorName();
        CommAdaptor adaptor = ADAPTORS.get(adaptorName);
        return adaptor.initWorker(config);
    }

    public static void stop(Map<String, Integer> runtimeEvents) {
        appHost.deleteIntermediate();
        for (CommAdaptor adaptor : ADAPTORS.values()) {
            adaptor.stop();
        }
        if (!STREAMING_BACKEND.equals((Object)StreamBackend.NONE)) {
            LOGGER.info("Stopping Streaming...");
            LOGGER.debug("Stopping Streaming Client...");
            StopRequest stopRequest = new StopRequest();
            DistroStreamClient.request((Request)stopRequest);
            stopRequest.waitProcessed();
            int errorCode = stopRequest.getErrorCode();
            if (errorCode != 0) {
                LOGGER.error("Error stopping Streaming Client");
                LOGGER.error("Error Code: " + errorCode);
                LOGGER.error("Error Message: " + stopRequest.getErrorMessage());
            }
            if (STREAMING_MASTER_NAME == null || STREAMING_MASTER_NAME == appHost.getName()) {
                LOGGER.debug("Stopping Streaming Server...");
                DistroStreamServer.setStop();
            } else {
                LOGGER.debug("Current COMPSs Runtime does not own the Streaming Server");
                LOGGER.debug("Skipping stop Streaming Server");
            }
        }
        if (STORAGE_CONF != null) {
            try {
                LOGGER.info("Stopping Storage...");
                StorageItf.finish();
            }
            catch (StorageException se) {
                LOGGER.error("Error releasing storage library: " + se.getMessage(), (Throwable)se);
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)0L, (int)Tracer.getRuntimeEventsType());
        }
        if (Tracer.extraeEnabled() || Tracer.scorepEnabled() || Tracer.mapEnabled()) {
            Tracer.fini(runtimeEvents);
        }
    }

    public static synchronized LogicalData registerData(String dataId) {
        LOGGER.debug("Register new data " + dataId);
        LogicalData logicalData = new LogicalData(dataId);
        DATA.put(dataId, logicalData);
        return logicalData;
    }

    public static synchronized LogicalData registerLocation(String dataId, DataLocation location) {
        LOGGER.debug("Registering new Location for data " + dataId + ":");
        LOGGER.debug("  * Location: " + location);
        LogicalData logicalData = DATA.get(dataId);
        logicalData.addLocation(location);
        return logicalData;
    }

    public static synchronized LogicalData registerValue(String dataId, Object value) {
        String id;
        LOGGER.debug("Register value " + value + " for data " + dataId);
        String targetPath = ProtocolType.OBJECT_URI.getSchema() + dataId;
        DataLocation location = null;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            location = DataLocation.createLocation(appHost, uri);
        }
        catch (IOException e) {
            ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)e);
        }
        LogicalData logicalData = DATA.get(dataId);
        logicalData.addLocation(location);
        logicalData.setValue(value);
        if (value instanceof StubItf && (id = ((StubItf)value).getID()) != null) {
            Comm.registerPSCO(dataId, id);
        }
        return logicalData;
    }

    public static synchronized LogicalData registerCollection(String dataId, List<?> parameters) {
        return Comm.registerValue(dataId, parameters);
    }

    public static synchronized LogicalData registerExternalPSCO(String dataId, String id) {
        LogicalData ld = Comm.registerPSCO(dataId, id);
        ld.setValue(id);
        return ld;
    }

    public static synchronized LogicalData registerBindingObject(String dataId, BindingObject bo) {
        String targetPath = ProtocolType.BINDING_URI.getSchema() + bo.toString();
        DataLocation location = null;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            location = DataLocation.createLocation(appHost, uri);
        }
        catch (IOException ioe) {
            ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)ioe);
        }
        LogicalData logicalData = DATA.get(dataId);
        logicalData.addLocation(location);
        logicalData.setValue(dataId + "#" + bo.getType() + "#" + bo.getElements());
        return logicalData;
    }

    public static synchronized LogicalData registerPSCO(String dataId, String id) {
        String targetPath = ProtocolType.PERSISTENT_URI.getSchema() + id;
        DataLocation location = null;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            location = DataLocation.createLocation(appHost, uri);
        }
        catch (IOException ioe) {
            ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)ioe);
        }
        LogicalData logicalData = DATA.get(dataId);
        logicalData.addLocation(location);
        return logicalData;
    }

    public static synchronized LogicalData linkData(String dataId, String dataId2) {
        LogicalData ld = DATA.get(dataId);
        LogicalData ld2 = DATA.get(dataId2);
        if (ld != null) {
            if (ld2 != null) {
                for (DataLocation dloc : ld2.getLocations()) {
                    ld.addLocation(dloc);
                }
                DATA.put(dataId2, ld);
            } else {
                DATA.put(dataId2, ld);
            }
        } else if (ld2 != null) {
            DATA.put(dataId, ld2);
            ld = ld2;
        } else {
            ld = Comm.registerData(dataId);
            DATA.put(dataId2, ld);
        }
        return ld;
    }

    public static synchronized Object clearValue(String dataId) {
        LOGGER.debug("Clear value of data " + dataId);
        LogicalData logicalData = DATA.get(dataId);
        return logicalData.removeValue();
    }

    public static synchronized boolean existsData(String renaming) {
        return DATA.get(renaming) != null;
    }

    public static synchronized LogicalData getData(String dataId) {
        LogicalData retVal = DATA.get(dataId);
        if (retVal == null) {
            LOGGER.warn("Get data " + dataId + " is null.");
        }
        return retVal;
    }

    public static synchronized String dataDump() {
        StringBuilder sb = new StringBuilder("DATA DUMP\n");
        for (Map.Entry<String, LogicalData> lde : DATA.entrySet()) {
            sb.append("\t *").append(lde.getKey()).append(":\n");
            LogicalData ld = lde.getValue();
            for (MultiURI u : ld.getURIs()) {
                sb.append("\t\t + ").append(u.toString()).append("\n");
                for (String adaptor : ADAPTORS.keySet()) {
                    Object internal = null;
                    try {
                        internal = u.getInternalURI(adaptor);
                        if (internal == null) continue;
                        sb.append("\t\t\t - ").append(internal.toString()).append("\n");
                    }
                    catch (UnstartedNodeException unstartedNodeException) {}
                }
            }
        }
        return sb.toString();
    }

    public static Set<LogicalData> getAllData(Resource host) {
        return host.getAllDataFromHost();
    }

    public static synchronized void removeData(String renaming) {
        LOGGER.debug("Removing data " + renaming);
        LogicalData ld = DATA.remove(renaming);
        ld.isObsolete();
        for (DataLocation dl : ld.getLocations()) {
            File f;
            MultiURI uri = dl.getURIInHost(appHost);
            if (uri == null || !(f = new File(uri.getPath())).exists()) continue;
            LOGGER.info("Deleting file " + f.getAbsolutePath());
            if (f.delete()) continue;
            LOGGER.error("Cannot delete file " + f.getAbsolutePath());
        }
        ld.removeValue();
    }

    public static void stopSubmittedjobs() {
        for (CommAdaptor adaptor : ADAPTORS.values()) {
            adaptor.stopSubmittedJobs();
        }
    }

    private static void loadAdaptorsJars() {
        LOGGER.info("Loading Adaptors...");
        String compssHome = System.getenv("COMPSS_HOME");
        if (compssHome == null || compssHome.isEmpty()) {
            LOGGER.warn("WARN: COMPSS_HOME not defined, no adaptors loaded.");
            return;
        }
        try {
            Classpath.loadPath((String)(compssHome + ADAPTORS_REL_PATH), (Logger)LOGGER);
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("WARN_MSG = [Adaptors folder not defined, no adaptors loaded.]");
        }
    }

    static {
        ADAPTORS_REL_PATH = File.separator + "Runtime" + File.separator + "adaptors";
        String streamBackendProperty = System.getProperty("compss.streaming");
        String streamBackendPropertyFixed = streamBackendProperty == null || streamBackendProperty.isEmpty() || streamBackendProperty.toLowerCase().equals("null") || streamBackendProperty.toLowerCase().equals("none") ? "NONE" : streamBackendProperty.toUpperCase();
        STREAMING_BACKEND = StreamBackend.valueOf((String)streamBackendPropertyFixed);
        String streamMasterNameProperty = System.getProperty("compss.streaming.masterName");
        STREAMING_MASTER_NAME = streamMasterNameProperty == null || streamMasterNameProperty.isEmpty() || streamMasterNameProperty.equals("null") ? null : streamMasterNameProperty;
        String streamMasterPortProperty = System.getProperty("compss.streaming.masterPort");
        STREAMING_PORT = streamMasterPortProperty == null || streamMasterPortProperty.isEmpty() || streamMasterPortProperty.equals("null") ? 49049 : Integer.parseInt(streamMasterPortProperty);
        String storageCfgProperty = System.getProperty("compss.storage.conf");
        STORAGE_CONF = storageCfgProperty == null || storageCfgProperty.isEmpty() || storageCfgProperty.equals("null") ? null : storageCfgProperty;
        ADAPTORS = new ConcurrentHashMap<String, CommAdaptor>();
        DATA = Collections.synchronizedMap(new TreeMap());
    }
}

