/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourcesPool;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import java.util.LinkedList;
import java.util.List;
import storage.StorageException;
import storage.StorageItf;

public class PersistentLocation
extends DataLocation {
    private final String id;

    public PersistentLocation(String id) {
        this.id = id;
    }

    @Override
    public LocationType getType() {
        return LocationType.PERSISTENT;
    }

    @Override
    public ProtocolType getProtocol() {
        return ProtocolType.PERSISTENT_URI;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public List<MultiURI> getURIs() {
        List locations = null;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.STORAGE_GETLOCATIONS.getId(), (int)TraceEvent.STORAGE_GETLOCATIONS.getType());
        }
        try {
            locations = StorageItf.getLocations((String)this.id);
        }
        catch (StorageException e) {
            ErrorManager.error((String)("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end"));
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent((long)0L, (int)TraceEvent.STORAGE_GETLOCATIONS.getType());
            }
        }
        if (locations == null) {
            ErrorManager.error((String)("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end"));
        }
        LinkedList<MultiURI> uris = new LinkedList<MultiURI>();
        for (String hostName : locations) {
            Resource host = ResourcesPool.getResource(hostName);
            if (host != null) {
                uris.add(new MultiURI(ProtocolType.PERSISTENT_URI, host, this.id));
                continue;
            }
            LOGGER.warn("Storage Back-End returned non-registered host " + hostName + ". Skipping URI in host");
        }
        return uris;
    }

    @Override
    public List<Resource> getHosts() {
        LOGGER.debug("Get PSCO locations for " + this.id);
        List locations = null;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.STORAGE_GETLOCATIONS.getId(), (int)TraceEvent.STORAGE_GETLOCATIONS.getType());
        }
        try {
            locations = StorageItf.getLocations((String)this.id);
        }
        catch (StorageException e) {
            ErrorManager.error((String)("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end"));
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent((long)0L, (int)TraceEvent.STORAGE_GETLOCATIONS.getType());
            }
        }
        if (locations == null) {
            ErrorManager.error((String)("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end"));
        }
        LinkedList<Resource> hosts = new LinkedList<Resource>();
        for (String hostName : locations) {
            Resource host = ResourcesPool.getResource(hostName);
            if (host != null) {
                hosts.add(host);
                continue;
            }
            LOGGER.warn("Storage Back-End returned non-registered host " + hostName);
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiURI getURIInHost(Resource targetHost) {
        List locations = null;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.STORAGE_GETLOCATIONS.getId(), (int)TraceEvent.STORAGE_GETLOCATIONS.getType());
        }
        try {
            locations = StorageItf.getLocations((String)this.id);
        }
        catch (StorageException e) {
            ErrorManager.error((String)("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end"));
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent((long)0L, (int)TraceEvent.STORAGE_GETLOCATIONS.getType());
            }
        }
        if (locations == null) {
            ErrorManager.error((String)("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end"));
        }
        for (String hostName : locations) {
            if (!hostName.equals(targetHost.getName())) continue;
            return new MultiURI(ProtocolType.PERSISTENT_URI, targetHost, this.id);
        }
        return null;
    }

    @Override
    public boolean isTarget(DataLocation target) {
        if (target.getType() != LocationType.PERSISTENT) {
            return false;
        }
        return this.id.equals(((PersistentLocation)target).id);
    }

    public String toString() {
        return ProtocolType.PERSISTENT_URI.getSchema() + this.id;
    }

    @Override
    public String getSharedDisk() {
        return null;
    }

    @Override
    public String getPath() {
        return this.id;
    }

    @Override
    public String getLocationKey() {
        return this.id + ":persistent:" + "allHosts";
    }

    @Override
    public int compareTo(DataLocation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o.getClass() != PersistentLocation.class) {
            return this.getClass().getName().compareTo(PersistentLocation.class.toString());
        }
        return this.id.compareTo(((PersistentLocation)o).id);
    }

    @Override
    public void modifyPath(String path) {
    }
}

