/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.exceptions.NonInstantiableException;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoreManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher");
    private static final String ERROR_INVALID_SIGNATURE = "Invalid signature. Skipping addition";
    private static final String ERROR_UNREGISTERED_CORE_ELEMENT = "Unregistered CoreElement. Skipping addition of ";
    private static final String WARN_UNREGISTERED_IMPL = "Unregistered implementation. Skipping addition";
    private static final List<CoreElement> CORE_ELEMENTS = new ArrayList<CoreElement>();
    private static final Map<String, CoreElement> SIGNATURE_TO_CORE = new LinkedHashMap<String, CoreElement>();
    private static int coreCount = 0;

    private CoreManager() {
        throw new NonInstantiableException("CoreManager");
    }

    public static int getCoreCount() {
        return coreCount;
    }

    public static CoreElement registerNewCoreElement(CoreElementDefinition ced) {
        StringBuilder logString = new StringBuilder("Registering New CoreElement\n");
        String ceSignature = ced.getCeSignature();
        if (ceSignature == null || ceSignature.isEmpty()) {
            LOGGER.warn(ERROR_INVALID_SIGNATURE + ceSignature);
            return null;
        }
        logString.append("ceSignature = ").append(ceSignature).append("\n");
        CoreElement coreElement = SIGNATURE_TO_CORE.get(ceSignature);
        if (coreElement == null) {
            coreElement = CoreManager.insertCoreElement(ceSignature);
        }
        for (ImplementationDescription implDef : ced.getImplementations()) {
            boolean alreadyExisting;
            String implSignature = implDef.getSignature();
            logString.append("implSignature = ").append(implDef.getSignature()).append("\n");
            logString.append("implConstraints = ").append(implDef.getConstraints()).append("\n");
            if (implSignature == null || implSignature.isEmpty() || (alreadyExisting = coreElement.addImplementation(implDef))) continue;
            SIGNATURE_TO_CORE.put(implSignature, coreElement);
        }
        LOGGER.debug((CharSequence)logString);
        return coreElement;
    }

    private static CoreElement insertCoreElement(String signature) {
        Integer methodId = coreCount;
        CoreElement ce = new CoreElement(methodId, signature);
        SIGNATURE_TO_CORE.put(signature, ce);
        CORE_ELEMENTS.add(ce);
        ++coreCount;
        return ce;
    }

    public static List<CoreElement> getAllCores() {
        return CORE_ELEMENTS;
    }

    public static CoreElement getCore(String signature) {
        if (signature == null || signature.isEmpty()) {
            ErrorManager.error((String)ERROR_INVALID_SIGNATURE);
            return null;
        }
        CoreElement ce = SIGNATURE_TO_CORE.get(signature);
        if (ce == null) {
            ErrorManager.error((String)(ERROR_UNREGISTERED_CORE_ELEMENT + signature));
            return null;
        }
        return ce;
    }

    public static CoreElement getCore(int coreId) {
        if (coreId < 0 || coreId >= coreCount) {
            ErrorManager.error((String)(ERROR_UNREGISTERED_CORE_ELEMENT + coreId));
            return null;
        }
        return CORE_ELEMENTS.get(coreId);
    }

    public static String getSignature(int coreId, int implId) {
        if (coreId < 0 || coreId >= coreCount) {
            LOGGER.warn(ERROR_UNREGISTERED_CORE_ELEMENT);
            return null;
        }
        CoreElement ce = CORE_ELEMENTS.get(coreId);
        if (implId < 0 || implId >= ce.getImplementationsCount()) {
            LOGGER.warn(WARN_UNREGISTERED_IMPL);
            return null;
        }
        return ce.getImplementationSignature(implId);
    }

    public static Map<String, CoreElement> getSignaturesToCores() {
        return SIGNATURE_TO_CORE;
    }

    public static Map<String, Integer> getSignaturesToCeAndImpls() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, CoreElement> ceEntry : SIGNATURE_TO_CORE.entrySet()) {
            result.put(ceEntry.getKey(), ceEntry.getValue().getCoreId());
        }
        return result;
    }

    public static Map<String, Integer> getSignaturesToCEIds() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (CoreElement ce : CORE_ELEMENTS) {
            result.put(ce.getSignature(), ce.getCoreId());
        }
        return result;
    }

    public static void clear() {
        CORE_ELEMENTS.clear();
        SIGNATURE_TO_CORE.clear();
        coreCount = 0;
    }

    public static List<Implementation> getCoreImplementations(int coreId) {
        if (coreId < 0 || coreId >= coreCount) {
            ErrorManager.error((String)ERROR_UNREGISTERED_CORE_ELEMENT);
            return null;
        }
        return CORE_ELEMENTS.get(coreId).getImplementations();
    }

    public static int getNumberCoreImplementations(int coreId) {
        if (coreId < 0 || coreId >= coreCount) {
            ErrorManager.error((String)ERROR_UNREGISTERED_CORE_ELEMENT);
            return -1;
        }
        return CORE_ELEMENTS.get(coreId).getImplementationsCount();
    }

    public static List<CoreElement> findExecutableCores(ResourceDescription rd) {
        LinkedList<CoreElement> executableList = new LinkedList<CoreElement>();
        block0: for (CoreElement ce : CORE_ELEMENTS) {
            for (Implementation impl : ce.getImplementations()) {
                if (!rd.canHost(impl)) continue;
                executableList.add(ce);
                continue block0;
            }
        }
        return executableList;
    }

    public static String debugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Core Count: ").append(coreCount).append("\n");
        for (CoreElement ce : CORE_ELEMENTS) {
            sb.append("\tCore ").append(ce.getCoreId()).append(":\n");
            for (Implementation impl : ce.getImplementations()) {
                sb.append("\t\t -").append(impl.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    public static String debugSignaturesString() {
        StringBuilder sb = new StringBuilder();
        sb.append("REGISTERED SIGNATURES: \n");
        for (Map.Entry<String, CoreElement> entry : SIGNATURE_TO_CORE.entrySet()) {
            sb.append("Signature: ").append(entry.getKey());
            sb.append(" with MethodId ").append(entry.getValue().getCoreId());
            sb.append("\n");
        }
        return sb.toString();
    }
}

