/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessid;

import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;

public class RWAccessId
extends DataAccessId {
    private static final long serialVersionUID = 1L;
    private DataVersion readDataVersion;
    private DataVersion writtenDataVersion;

    public RWAccessId() {
    }

    public RWAccessId(DataVersion rdv, DataVersion wdv) {
        this.readDataVersion = rdv;
        this.writtenDataVersion = wdv;
    }

    @Override
    public int getDataId() {
        return this.readDataVersion.getDataInstanceId().getDataId();
    }

    @Override
    public DataAccessId.Direction getDirection() {
        return DataAccessId.Direction.RW;
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.readDataVersion.hasMoreReaders();
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    public DataVersion getReadDataVersion() {
        return this.readDataVersion;
    }

    public DataInstanceId getReadDataInstance() {
        return this.readDataVersion.getDataInstanceId();
    }

    public DataVersion getWrittenDataVersion() {
        return this.writtenDataVersion;
    }

    public DataInstanceId getWrittenDataInstance() {
        return this.writtenDataVersion.getDataInstanceId();
    }

    public int getRVersionId() {
        return this.readDataVersion.getDataInstanceId().getVersionId();
    }

    public int getWVersionId() {
        return this.writtenDataVersion.getDataInstanceId().getVersionId();
    }

    public String toString() {
        return "Read data: " + this.readDataVersion.getDataInstanceId() + ", Written data: " + this.writtenDataVersion.getDataInstanceId() + (this.isPreserveSourceData() ? ", Preserved" : ", Erased");
    }

    @Override
    public boolean isValidVersion() {
        return !this.writtenDataVersion.hasBeenCancelled();
    }
}

