/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.location.SharedDisk;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import java.util.LinkedList;
import java.util.List;

public class PrivateLocation
extends DataLocation {
    private MultiURI uri;

    public PrivateLocation(ProtocolType protocol, Resource host, String path) {
        this.uri = new MultiURI(protocol, host, path);
    }

    @Override
    public LocationType getType() {
        return LocationType.PRIVATE;
    }

    @Override
    public ProtocolType getProtocol() {
        return this.uri.getProtocol();
    }

    @Override
    public List<MultiURI> getURIs() {
        LinkedList<MultiURI> list = new LinkedList<MultiURI>();
        list.add(this.uri);
        return list;
    }

    @Override
    public List<Resource> getHosts() {
        LinkedList<Resource> list = new LinkedList<Resource>();
        list.add(this.uri.getHost());
        return list;
    }

    @Override
    public MultiURI getURIInHost(Resource targetHost) {
        if (this.uri.getHost().getNode().equals(targetHost.getNode())) {
            return this.uri;
        }
        return null;
    }

    @Override
    public boolean isTarget(DataLocation target) {
        if (target.getType() != LocationType.PRIVATE) {
            return false;
        }
        MultiURI targetURI = ((PrivateLocation)target).uri;
        return targetURI.getHost() == this.uri.getHost() && targetURI.getPath().contentEquals(this.uri.getPath());
    }

    @Override
    public SharedDisk getSharedDisk() {
        return null;
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    @Override
    public String getLocationKey() {
        return this.uri.getPath() + ":" + this.uri.getHost().getName();
    }

    @Override
    public int compareTo(DataLocation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o.getClass() != PrivateLocation.class) {
            return this.getClass().getName().compareTo(PrivateLocation.class.toString());
        }
        return this.uri.compareTo(((PrivateLocation)o).uri);
    }

    public String toString() {
        return this.uri.toString();
    }

    @Override
    public void modifyPath(String path) {
        this.uri = new MultiURI(this.uri.getProtocol(), this.uri.getHost(), path);
    }
}

