/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation.copy;

import es.bsc.compss.exceptions.CopyException;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.OperationEndState;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class ImmediateAsyncCopy
extends Copy {
    public ImmediateAsyncCopy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, EventListener listener) {
        super(srcData, prefSrc, prefTgt, tgtData, reason, listener);
        if (DEBUG) {
            LOGGER.debug("Created Immediate Async Copy " + this.getName() + " (id: " + this.getId() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        Resource targetHost = (Resource)((LinkedList)this.tgtLoc.getHosts()).getFirst();
        LOGGER.debug("THREAD " + Thread.currentThread().getName() + " - Copy file " + this.getName() + " to " + this.tgtLoc);
        LogicalData logicalData = this.srcData;
        synchronized (logicalData) {
            if (this.tgtData != null) {
                MultiURI u = this.srcData.alreadyAvailable(targetHost);
                if (u != null && this.srcData.getName().equals(this.tgtData.getName())) {
                    this.setFinalTarget(u.getPath());
                    this.end(OperationEndState.OP_OK);
                    LOGGER.debug("THREAD " + Thread.currentThread().getName() + " - A copy of " + this.getName() + " is already present at " + targetHost + " on path " + u.getPath());
                    return;
                }
                Copy copyInProgress = null;
                copyInProgress = this.srcData.alreadyCopying(this.tgtLoc);
                if (copyInProgress != null) {
                    String path = copyInProgress.tgtLoc.getURIInHost(targetHost).getPath();
                    this.setFinalTarget(path);
                    this.end(OperationEndState.OP_IN_PROGRESS);
                    List<EventListener> list = copyInProgress.getEventListeners();
                    synchronized (list) {
                        copyInProgress.addEventListeners(this.getEventListeners());
                    }
                    LOGGER.debug("THREAD " + Thread.currentThread().getName() + " - A copy to " + path + " is already in progress, skipping replication");
                    return;
                }
                if (this.srcData.getLocations().isEmpty()) {
                    Iterator<Copy> iterator = this.srcData.getCopiesInProgress().iterator();
                    if (iterator.hasNext()) {
                        Copy inProgressCopy = iterator.next();
                        LOGGER.debug("No source locations for copy " + this.getName() + ". Waiting for copy " + inProgressCopy.getName() + " to finish.");
                        inProgressCopy.addEventListener(new EventListener(){

                            @Override
                            public void notifyEnd(DataOperation fOp) {
                                ImmediateAsyncCopy.this.perform();
                            }

                            @Override
                            public void notifyFailure(DataOperation fOp, Exception e) {
                                ImmediateAsyncCopy.this.end(OperationEndState.OP_FAILED, e);
                            }
                        });
                        return;
                    }
                    this.end(OperationEndState.OP_FAILED, new Exception(" No source location nor copies in progress for copy " + this.getName()));
                }
            }
            this.srcData.startCopy(this, this.tgtLoc);
        }
        try {
            LOGGER.debug("[InmediateAsyncCopy] Performing Inmediate specific Copy for " + this.getName());
            this.specificCopy();
        }
        catch (CopyException e) {
            this.end(OperationEndState.OP_FAILED, (Exception)((Object)e));
            return;
        }
        String path = this.tgtLoc.getURIInHost(targetHost).getPath();
        this.setFinalTarget(path);
        LOGGER.debug("[InmediateAsyncCopy] Immediate Async Copy for " + this.getName() + " launched.");
    }

    public abstract void specificCopy() throws CopyException;

    public abstract void notifyEndAsyncCopy(OperationEndState var1, CopyException var2);
}

