/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.data.BindingDataManager;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.LocationMonitor;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.location.SharedDisk;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.FileOpsManager;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.util.serializers.Serializer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class LogicalData {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String DBG_PREFIX = "[LogicalData] ";
    private final String name;
    private Object[] value;
    private String[] pscoId;
    private String[] bindingId;
    private Set<String> knownAlias = new TreeSet<String>();
    private Set<DataLocation> locations = new TreeSet<DataLocation>();
    private List<CopyInProgress> inProgress = new LinkedList<CopyInProgress>();
    private float size;
    private boolean isBeingSaved;
    private boolean isBindingData;
    private LinkedList<LocationMonitor> locMonitors;
    private boolean accessedByMain;
    private boolean isDeleted;

    public LogicalData(String name) {
        this.name = name;
        this.knownAlias.add(name);
        this.value = new Object[]{null};
        this.pscoId = new String[]{null};
        this.bindingId = new String[]{null};
        this.isBeingSaved = false;
        this.isBindingData = false;
        this.size = 0.0f;
        this.locMonitors = new LinkedList();
        this.accessedByMain = false;
        this.isDeleted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void link(LogicalData ld, LogicalData ld2) throws CommException {
        LogicalData logicalData = ld;
        synchronized (logicalData) {
            LogicalData logicalData2 = ld2;
            synchronized (logicalData2) {
                Collection<Object> collection;
                LogicalData master;
                LogicalData slave;
                Object valueContent = null;
                if (ld.isInMemory()) {
                    if (ld2.isInMemory()) {
                        if (ld2.getValue() != ld.getValue()) {
                            throw new CommException("Linking two LogicalData with different value in memory");
                        }
                    } else {
                        valueContent = ld.value[0];
                    }
                } else {
                    valueContent = ld2.value[0];
                }
                String[] pscoId = null;
                if (ld.getPscoId() != null) {
                    if (ld2.getPscoId() != null) {
                        if (ld2.getPscoId().compareTo(ld.getPscoId()) != 0) {
                            throw new CommException("Linking two LogicalData with different pscoId in memory");
                        }
                    } else {
                        pscoId = ld.pscoId;
                    }
                } else {
                    pscoId = ld2.pscoId;
                }
                String[] bindingId = null;
                if (ld.bindingId[0] != null) {
                    if (ld2.bindingId[0] != null) {
                        if (ld2.bindingId[0].compareTo(ld.bindingId[0]) != 0) {
                            throw new CommException("Linking two LogicalData with different value in memory");
                        }
                    } else {
                        bindingId = ld.bindingId;
                    }
                } else {
                    bindingId = ld2.bindingId;
                }
                if (ld.knownAlias.size() == 1) {
                    slave = ld;
                    master = ld2;
                } else if (ld2.knownAlias.size() == 1) {
                    slave = ld;
                    master = ld2;
                } else {
                    throw new CommException("Linking two LogicalData with multiple links");
                }
                if (master.isInMemory() && !slave.isInMemory()) {
                    collection = slave.knownAlias;
                    synchronized (collection) {
                        for (String alias : slave.getKnownAlias()) {
                            String targetPath = ProtocolType.OBJECT_URI.getSchema() + alias;
                            try {
                                SimpleURI uri = new SimpleURI(targetPath);
                                DataLocation loc = DataLocation.createLocation(Comm.getAppHost(), uri);
                                Set<DataLocation> set = master.locations;
                                synchronized (set) {
                                    master.locations.add(loc);
                                }
                            }
                            catch (Exception e) {
                                ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)e);
                            }
                        }
                    }
                }
                master.value[0] = valueContent;
                slave.value = master.value;
                slave.pscoId = master.pscoId = pscoId;
                slave.bindingId = master.bindingId = bindingId;
                collection = master.locMonitors;
                synchronized (collection) {
                    master.locMonitors.addAll(slave.locMonitors);
                }
                slave.locMonitors = master.locMonitors;
                collection = master.inProgress;
                synchronized (collection) {
                    master.inProgress.addAll(slave.inProgress);
                }
                slave.inProgress = master.inProgress;
                collection = master.locations;
                synchronized (collection) {
                    master.locations.addAll(slave.locations);
                }
                slave.locations = master.locations;
                collection = master.knownAlias;
                synchronized (collection) {
                    master.knownAlias.addAll(slave.knownAlias);
                }
                slave.knownAlias = master.knownAlias;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getKnownAlias() {
        return this.knownAlias;
    }

    public synchronized boolean isAlias(LogicalData data) {
        return data.knownAlias == this.knownAlias;
    }

    public synchronized int countKnownAlias() {
        return this.knownAlias.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addKnownAlias(String alias) {
        this.isDeleted = false;
        if (this.knownAlias.add(alias) && this.isInMemory()) {
            String targetPath = ProtocolType.OBJECT_URI.getSchema() + alias;
            try {
                SimpleURI uri = new SimpleURI(targetPath);
                DataLocation loc = DataLocation.createLocation(Comm.getAppHost(), uri);
                Set<DataLocation> set = this.locations;
                synchronized (set) {
                    this.locations.add(loc);
                }
            }
            catch (Exception e) {
                ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeKnownAlias(String alias, boolean asynch) {
        if (this.knownAlias.remove(alias)) {
            if (this.knownAlias.isEmpty()) {
                this.isDeleted = true;
                for (Resource res : this.getAllHosts()) {
                    res.addObsolete(this);
                }
                Set<DataLocation> set = this.locations;
                synchronized (set) {
                    LinkedList<DataLocation> removedLocations = new LinkedList<DataLocation>();
                    for (DataLocation dl : this.locations) {
                        if (!this.deleteIfLocal(dl, asynch)) continue;
                        removedLocations.add(dl);
                    }
                    this.locations.removeAll(removedLocations);
                }
                this.value[0] = null;
            } else {
                String targetPath = ProtocolType.OBJECT_URI.getSchema() + alias;
                SimpleURI uri = new SimpleURI(targetPath);
                if (this.isInMemory()) {
                    try {
                        DataLocation loc = DataLocation.createLocation(Comm.getAppHost(), uri);
                        Set<DataLocation> set = this.locations;
                        synchronized (set) {
                            this.locations.remove(loc);
                        }
                    }
                    catch (Exception e) {
                        ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)e);
                    }
                }
            }
        }
    }

    private boolean deleteIfLocal(DataLocation dl, boolean asynch) {
        MultiURI uri = dl.getURIInHost(Comm.getAppHost());
        if (!(uri == null || uri.getProtocol() != ProtocolType.ANY_URI && uri.getProtocol() != ProtocolType.FILE_URI && uri.getProtocol() != ProtocolType.DIR_URI || dl.isCheckpointing() && this.accessedByMain)) {
            File f = new File(uri.getPath());
            if (asynch) {
                FileOpsManager.deleteAsync((File)f);
            } else {
                try {
                    FileOpsManager.deleteSync((File)f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public final String getPscoId() {
        return this.pscoId[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<Resource> getAllHosts() {
        HashSet<Resource> list = new HashSet<Resource>();
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            for (DataLocation loc : this.locations) {
                List<Resource> hosts;
                List<Resource> list2 = hosts = loc.getHosts();
                synchronized (list2) {
                    list.addAll(hosts);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLocationMonitor(LocationMonitor monitor) {
        LinkedList<LocationMonitor> linkedList = this.locMonitors;
        synchronized (linkedList) {
            this.locMonitors.add(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLocationMonitor(LocationMonitor monitor) {
        LinkedList<LocationMonitor> linkedList = this.locMonitors;
        synchronized (linkedList) {
            this.locMonitors.remove(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addLocation(DataLocation loc) {
        if (loc.getProtocol() == ProtocolType.OBJECT_URI && loc.getHosts().contains(Comm.getAppHost())) {
            try {
                this.addLocationsForInMemoryObject();
                return;
            }
            catch (Exception e) {
                ErrorManager.error((String)("ERROR generating a new location for the object in memory for data " + this.name), (Exception)e);
            }
        }
        List<Resource> resources = loc.getHosts();
        Iterator<Resource> iterator = this.locMonitors;
        synchronized (iterator) {
            for (LocationMonitor readerData : this.locMonitors) {
                readerData.addedLocation(resources);
            }
        }
        this.isBeingSaved = false;
        iterator = this.locations;
        synchronized (iterator) {
            this.locations.add(loc);
        }
        switch (loc.getType()) {
            case PRIVATE: {
                for (Resource r : loc.getHosts()) {
                    r.addLogicalData(this);
                }
                break;
            }
            case BINDING: {
                for (Resource r : loc.getHosts()) {
                    this.isBindingData = true;
                    if (this.bindingId[0] == null) {
                        this.bindingId[0] = ((BindingObjectLocation)loc).getId();
                    }
                    r.addLogicalData(this);
                }
                break;
            }
            case SHARED: {
                SharedDisk disk = loc.getSharedDisk();
                disk.addLogicalData(this);
                break;
            }
            case PERSISTENT: {
                this.pscoId[0] = ((PersistentLocation)loc).getId();
            }
        }
        if (this.isDeleted) {
            this.deleteLocation(loc);
        }
    }

    private void deleteLocation(DataLocation loc) {
        List<Resource> resources = loc.getHosts();
        for (Resource res : resources) {
            res.addObsolete(this);
        }
        this.deleteIfLocal(loc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<MultiURI> getURIs() {
        LinkedList<MultiURI> list = new LinkedList<MultiURI>();
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            for (DataLocation loc : this.locations) {
                List<MultiURI> locationURIs = loc.getURIs();
                if (locationURIs == null) continue;
                list.addAll(locationURIs);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<MultiURI> getURIsInHost(Resource targetHost) {
        LinkedList<MultiURI> list = new LinkedList<MultiURI>();
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            for (DataLocation loc : this.locations) {
                MultiURI locationURI = loc.getURIInHost(targetHost);
                if (locationURI == null) continue;
                list.add(locationURI);
            }
        }
        return list;
    }

    public synchronized Set<DataLocation> getLocations() {
        return this.locations;
    }

    public synchronized void setSize(float size) {
        this.size = size;
    }

    public float getSize() {
        return this.size;
    }

    public final synchronized boolean isInMemory() {
        return this.value[0] != null;
    }

    public synchronized boolean isBindingData() {
        return this.isBindingData;
    }

    public final synchronized Object getValue() {
        return this.value[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeLocation(DataLocation loc) {
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            this.locations.remove(loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object removeValue() {
        for (String alias : this.getKnownAlias()) {
            DataLocation loc = null;
            String targetPath = ProtocolType.OBJECT_URI.getSchema() + alias;
            try {
                SimpleURI uri = new SimpleURI(targetPath);
                loc = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)e);
            }
            Set<DataLocation> set = this.locations;
            synchronized (set) {
                this.locations.remove(loc);
            }
        }
        Object val = this.value[0];
        this.value[0] = null;
        return val;
    }

    public synchronized void setValue(Object o) {
        this.value[0] = o;
    }

    public synchronized void setPscoId(String id) {
        this.pscoId[0] = id;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void writeToStorage() throws Exception {
        if (DEBUG) {
            LOGGER.debug("[LogicalData] Writting object " + this.name + " to storage");
        }
        if (this.isBindingData) {
            String targetPath = Comm.getAppHost().getWorkingDirectory() + this.name;
            String id = this.bindingId[0] != null ? this.bindingId[0] : (this.value[0] != null ? (String)this.value[0] : this.name);
            if (id.contains("#")) {
                id = BindingObject.generate((String)id).getName();
            }
            if (!BindingDataManager.isInBinding((String)id)) {
                LOGGER.error("[LogicalData]  Error " + id + " not found in binding");
                throw new Exception(" Error " + id + " not found in binding");
            }
            if (DEBUG) {
                LOGGER.debug("[LogicalData] Writting binding object " + id + " to file " + targetPath);
            }
            BindingDataManager.storeInFile((String)id, (String)targetPath);
            this.addWrittenObjectLocation(targetPath);
        } else if (this.pscoId[0] == null) {
            String targetPath = Comm.getAppHost().getWorkingDirectory() + this.name;
            if (DEBUG) {
                LOGGER.debug("[LogicalData] Writting object " + this.name + " to file " + targetPath);
            }
            Serializer.serialize((Object)this.value[0], (String)targetPath);
            this.addWrittenObjectLocation(targetPath);
        }
        if (DEBUG) {
            LOGGER.debug("[LogicalData] Object " + this.name + " written to storage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWrittenObjectLocation(String targetPath) throws IOException {
        String targetPathWithSchema = ProtocolType.FILE_URI.getSchema() + targetPath;
        SimpleURI targetURI = new SimpleURI(targetPathWithSchema);
        DataLocation loc = DataLocation.createLocation(Comm.getAppHost(), targetURI);
        this.isBeingSaved = false;
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            this.locations.add(loc);
        }
        for (Resource r : loc.getHosts()) {
            switch (loc.getType()) {
                case PRIVATE: 
                case BINDING: {
                    r.addLogicalData(this);
                    break;
                }
                case SHARED: {
                    SharedDisk disk = loc.getSharedDisk();
                    disk.addLogicalData(this);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object readFromStorage() throws CannotLoadException {
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            Iterator<DataLocation> iterator = this.locations.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw new CannotLoadException("Object has not any valid location available in the master");
                }
                DataLocation loc = iterator.next();
                switch (loc.getType()) {
                    case PRIVATE: 
                    case SHARED: {
                        String path;
                        MultiURI u = loc.getURIInHost(Comm.getAppHost());
                        if (u == null || !(path = u.getPath()).startsWith(File.separator)) break;
                        try {
                            return Serializer.deserialize((String)path);
                        }
                        catch (IOException | ClassNotFoundException e) {
                            this.value[0] = null;
                            break;
                        }
                    }
                    case PERSISTENT: {
                        PersistentLocation pLoc = (PersistentLocation)loc;
                        if (Tracer.isActivated()) {
                            Tracer.emitEvent((TraceEvent)TraceEvent.STORAGE_GETBYID);
                        }
                        try {
                            this.pscoId[0] = pLoc.getId();
                            Object object = StorageItf.getByID((String)this.pscoId[0]);
                            return object;
                        }
                        catch (StorageException se) {
                            break;
                        }
                        finally {
                            if (Tracer.isActivated()) {
                                Tracer.emitEventEnd((TraceEvent)TraceEvent.STORAGE_GETBYID);
                            }
                        }
                    }
                    case BINDING: {
                        throw new CannotLoadException("ERROR: Trying to load from storage a BINDING location");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadFromStorage() throws CannotLoadException {
        if (this.value[0] != null) {
            return;
        }
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            block19: for (DataLocation loc : this.locations) {
                switch (loc.getType()) {
                    case PRIVATE: 
                    case SHARED: {
                        MultiURI u = loc.getURIInHost(Comm.getAppHost());
                        if (u == null) continue block19;
                        String path = u.getPath();
                        if (path.startsWith(File.separator)) {
                            try {
                                this.value[0] = Serializer.deserialize((String)path);
                            }
                            catch (IOException | ClassNotFoundException e) {
                                this.value[0] = null;
                                continue block19;
                            }
                            try {
                                this.addLocationsForInMemoryObject();
                            }
                            catch (IOException e) {
                                this.value[0] = null;
                                continue block19;
                            }
                        }
                        return;
                    }
                    case PERSISTENT: {
                        PersistentLocation pLoc = (PersistentLocation)loc;
                        if (Tracer.isActivated()) {
                            Tracer.emitEvent((TraceEvent)TraceEvent.STORAGE_GETBYID);
                        }
                        try {
                            this.value[0] = StorageItf.getByID((String)pLoc.getId());
                            this.pscoId[0] = pLoc.getId();
                        }
                        catch (StorageException se) {}
                        continue block19;
                        finally {
                            if (!Tracer.isActivated()) continue block19;
                            Tracer.emitEventEnd((TraceEvent)TraceEvent.STORAGE_GETBYID);
                            continue block19;
                        }
                        try {
                            this.addLocationsForInMemoryObject();
                        }
                        catch (IOException e) {
                            this.value[0] = null;
                            continue block19;
                        }
                        return;
                    }
                    case BINDING: {
                        throw new CannotLoadException("ERROR: Trying to load from storage a BINDING location");
                    }
                }
            }
        }
        throw new CannotLoadException("Object has not any valid location available in the master");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsForInMemoryObject() throws IOException {
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            LinkedList<DataLocation> locations = new LinkedList<DataLocation>();
            for (String alias : this.knownAlias) {
                String targetPath = ProtocolType.OBJECT_URI.getSchema() + alias;
                SimpleURI uri = new SimpleURI(targetPath);
                DataLocation tgtLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
                locations.add(tgtLoc);
            }
            for (DataLocation loc : locations) {
                this.isBeingSaved = false;
                this.locations.add(loc);
                Comm.getAppHost().addLogicalData(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DataLocation removeHostAndCheckLocationToSave(Resource host, Map<SharedDisk, String> sharedMountPoints) {
        if (this.isBeingSaved) {
            return null;
        }
        DataLocation uniqueHostLocation = null;
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            Iterator<DataLocation> it = this.locations.iterator();
            block9: while (it.hasNext()) {
                DataLocation loc = it.next();
                switch (loc.getType()) {
                    case PRIVATE: 
                    case BINDING: {
                        if (loc.getURIInHost(host) == null) break;
                        this.isBeingSaved = true;
                        uniqueHostLocation = loc;
                        it.remove();
                        break;
                    }
                    case SHARED: {
                        String mountPoint;
                        if (!loc.getHosts().isEmpty()) break;
                        SharedDisk disk = loc.getSharedDisk();
                        if (disk == null || (mountPoint = sharedMountPoints.get(disk)) == null || uniqueHostLocation != null) continue block9;
                        this.isBeingSaved = true;
                        String targetPath = ProtocolType.FILE_URI.getSchema() + loc.getPath();
                        try {
                            SimpleURI uri = new SimpleURI(targetPath);
                            uniqueHostLocation = DataLocation.createLocation(host, uri);
                        }
                        catch (Exception e) {
                            ErrorManager.error((String)("ERROR: Invalid location URI " + targetPath), (Exception)e);
                        }
                        break;
                    }
                }
            }
            return uniqueHostLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<Copy> getCopiesInProgress() {
        LinkedList<Copy> copies = new LinkedList<Copy>();
        List<CopyInProgress> list = this.inProgress;
        synchronized (list) {
            for (CopyInProgress cp : this.inProgress) {
                copies.add(cp.getCopy());
            }
        }
        return copies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MultiURI alreadyAvailable(Resource targetHost) {
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            for (DataLocation loc : this.locations) {
                MultiURI u = loc.getURIInHost(targetHost);
                if (u == null) continue;
                return u;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Copy alreadyCopying(DataLocation target) {
        List<CopyInProgress> list = this.inProgress;
        synchronized (list) {
            for (CopyInProgress cip : this.inProgress) {
                if (!cip.hasTarget(target)) continue;
                return cip.getCopy();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startCopy(Copy c, DataLocation target) {
        List<CopyInProgress> list = this.inProgress;
        synchronized (list) {
            this.inProgress.add(new CopyInProgress(c, target));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DataLocation finishedCopy(Copy c) {
        DataLocation loc = null;
        List<CopyInProgress> list = this.inProgress;
        synchronized (list) {
            Iterator<CopyInProgress> it = this.inProgress.iterator();
            while (it.hasNext()) {
                CopyInProgress cip = it.next();
                if (cip.c != c) continue;
                it.remove();
                loc = cip.loc;
                break;
            }
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyToInProgressCopiesEnd(SafeCopyListener listener) {
        List<CopyInProgress> list = this.inProgress;
        synchronized (list) {
            for (CopyInProgress cip : this.inProgress) {
                listener.addOperation();
                cip.c.addEventListener(listener);
            }
        }
    }

    public void setAccessedByMain(boolean accessedByMain) {
        this.accessedByMain = accessedByMain;
    }

    public boolean isAccessedByMain() {
        return this.accessedByMain;
    }

    public synchronized String toString() {
        while (true) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("Logical Data name: ").append(this.name).append("\n");
                sb.append("Aliases:");
                for (String alias : this.knownAlias) {
                    sb.append(" ").append(alias);
                }
                sb.append("\n");
                sb.append("\t Value: ").append(this.value[0]).append("\n");
                sb.append("\t Id: ").append(this.pscoId[0]).append("\n");
                sb.append("\t Locations:\n");
                for (DataLocation dl : this.locations) {
                    sb.append("\t\t * ").append(dl).append("\n");
                }
                return sb.toString();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    private static class CopyInProgress {
        private final Copy c;
        private final DataLocation loc;

        public CopyInProgress(Copy c, DataLocation loc) {
            this.c = c;
            this.loc = loc;
        }

        public Copy getCopy() {
            return this.c;
        }

        private boolean hasTarget(DataLocation target) {
            return this.loc.isTarget(target);
        }

        public String toString() {
            return this.c.getName() + " to " + this.loc.toString();
        }
    }
}

