/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobImpl;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobDispatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.JobManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String SUBMISSION_ERROR = "Error submitting job ";
    public static final int POOL_SIZE = 1;
    public static final String POOL_NAME = "Job Submitter";
    protected static RequestQueue<JobImpl<?>> queue = new RequestQueue();
    private static ThreadPool pool = new ThreadPool(1, "Job Submitter", (RequestDispatcher)new JobSubmitter(queue));

    public static void dispatch(JobImpl<?> job) {
        queue.enqueue(job);
    }

    public static void shutdown() {
        pool.stopThreads();
    }

    static {
        pool.startThreads();
    }

    private static class JobSubmitter
    extends RequestDispatcher<JobImpl<?>> {
        public JobSubmitter(RequestQueue<JobImpl<?>> queue) {
            super(queue);
        }

        public void processRequests() {
            while (true) {
                JobImpl job;
                if (DEBUG) {
                    LOGGER.debug("Waiting for new jobs to submit...");
                }
                if ((job = (JobImpl)this.queue.dequeue()) == null) break;
                try {
                    job.submitJob();
                    if (!DEBUG) continue;
                    LOGGER.debug("Job " + job.getJobId() + " submitted");
                }
                catch (Exception ex) {
                    LOGGER.error(JobDispatcher.SUBMISSION_ERROR + job.getJobId(), (Throwable)ex);
                    System.err.println(JobDispatcher.SUBMISSION_ERROR + job.getJobId());
                    ex.printStackTrace();
                    job.failed(JobEndStatus.SUBMISSION_FAILED);
                }
            }
            LOGGER.debug("JobDispatcher finished");
        }
    }
}

