/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation.copy;

import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.OperationEndState;
import es.bsc.compss.types.data.operation.copy.CompletedCopyException;
import es.bsc.compss.util.FileOpsManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public abstract class Copy
extends DataOperation {
    protected final LogicalData srcData;
    protected final DataLocation srcLoc;
    protected final LogicalData tgtData;
    protected DataLocation tgtLoc;
    protected final Transferable reason;
    private final SiblingCopiesManager siblingHandler;

    public Copy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, EventListener listener) {
        super(srcData, listener);
        this.srcData = srcData;
        this.srcLoc = prefSrc;
        this.tgtData = tgtData;
        this.tgtLoc = prefTgt;
        this.reason = reason;
        this.siblingHandler = new SiblingCopiesManager();
    }

    public DataType getType() {
        return this.reason.getType();
    }

    public LogicalData getSourceData() {
        return this.srcData;
    }

    public DataLocation getPreferredSource() {
        return this.srcLoc;
    }

    public void setTargetLoc(DataLocation loc) {
        this.tgtLoc = loc;
    }

    public void setProposedSource(Object source) {
        this.reason.setDataSource(source);
    }

    public DataLocation getTargetLoc() {
        return this.tgtLoc;
    }

    public LogicalData getTargetData() {
        return this.tgtData;
    }

    public void setFinalTarget(String targetAbsolutePath) {
        if (DEBUG) {
            LOGGER.debug(" Setting StorageCopy final target to : " + targetAbsolutePath);
        }
        this.reason.setDataTarget(targetAbsolutePath);
    }

    public boolean isRegistered() {
        return this.tgtData != null;
    }

    public String getFinalTarget() {
        return this.reason.getDataTarget();
    }

    public void addSiblingCopy(String targetPath, DataLocation targetLocation, LogicalData targetData, Transferable reason, EventListener listener) throws CompletedCopyException {
        SiblingCopy c = new SiblingCopy(this.srcData, targetPath, targetLocation, targetData, reason, listener);
        this.siblingHandler.addSiblingCopy(c);
    }

    @Override
    public void end(OperationEndState state) {
        String endedPath = this.reason.getDataTarget();
        this.siblingHandler.finishOriginalCopy(endedPath, false, state, null);
    }

    @Override
    public void end(OperationEndState state, Exception e) {
        String endedPath = this.reason.getDataTarget();
        this.siblingHandler.finishOriginalCopy(endedPath, true, state, e);
    }

    private void superEnd(OperationEndState state) {
        super.end(state);
    }

    private void superEnd(OperationEndState state, Exception e) {
        super.end(state, e);
    }

    private final class SiblingCopiesManager {
        private final Collection<SiblingCopy> pendingSiblings = new LinkedList<SiblingCopy>();
        private int pendingSiblingCompletions = 0;
        private boolean originalCopyCompleted = false;
        private String endedPath;
        private boolean notifyWithException = false;
        private OperationEndState state;
        private Exception e;

        private SiblingCopiesManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishOriginalCopy(String endedPath, boolean notifyWithException, OperationEndState state, Exception e) {
            boolean noPendingOps;
            this.notifyWithException = notifyWithException;
            this.state = state;
            this.e = e;
            this.endedPath = endedPath;
            SiblingCopiesManager siblingCopiesManager = this;
            synchronized (siblingCopiesManager) {
                noPendingOps = this.pendingSiblings.isEmpty();
                for (SiblingCopy copy : this.pendingSiblings) {
                    this.orderSiblingCopy(copy);
                }
                this.pendingSiblings.clear();
                this.originalCopyCompleted = true;
            }
            if (noPendingOps) {
                this.notifyEnd();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void addSiblingCopy(SiblingCopy copy) throws CompletedCopyException {
            if (this.originalCopyCompleted) {
                if (this.pendingSiblingCompletions <= 0) throw new CompletedCopyException();
                this.orderSiblingCopy(copy);
                return;
            } else {
                this.pendingSiblings.add(copy);
            }
        }

        private void orderSiblingCopy(SiblingCopy c) {
            SiblingCopyListener siblingCopyListener = new SiblingCopyListener(this.endedPath, c, this);
            String targetPath = c.getTargetPath();
            if (DEBUG) {
                LOGGER.debug("Master local copy from " + this.endedPath + " to " + targetPath);
            }
            ++this.pendingSiblingCompletions;
            FileOpsManager.copyAsync((File)new File(this.endedPath), (File)new File(targetPath), (FileOpsManager.FileOpListener)siblingCopyListener);
        }

        private synchronized void finishedSiblingCopy(SiblingCopy copy) {
            EventListener finishedCopyListener = copy.getListener();
            Copy.this.addEventListener(finishedCopyListener);
            --this.pendingSiblingCompletions;
            if (this.pendingSiblingCompletions == 0) {
                this.notifyEnd();
            }
        }

        private synchronized void failedSiblingCopy(SiblingCopy copy, Exception e) {
            EventListener failedSiblingListener = copy.getListener();
            failedSiblingListener.notifyFailure(Copy.this, e);
            --this.pendingSiblingCompletions;
            if (this.pendingSiblingCompletions == 0) {
                this.notifyEnd();
            }
        }

        private void notifyEnd() {
            if (this.notifyWithException) {
                Copy.this.superEnd(this.state, this.e);
            } else {
                Copy.this.superEnd(this.state);
            }
        }
    }

    private static final class SiblingCopyListener
    implements FileOpsManager.FileOpListener {
        private final String sourcePath;
        private final SiblingCopy copy;
        private final SiblingCopiesManager groupListener;

        public SiblingCopyListener(String sourcePath, SiblingCopy c, SiblingCopiesManager groupListener) {
            this.sourcePath = sourcePath;
            this.copy = c;
            this.groupListener = groupListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed() {
            LogicalData tgtData = this.copy.getTargetData();
            DataLocation targetLoc = this.copy.getTargetLocation();
            String targetPath = this.copy.getTargetPath();
            Transferable reason = this.copy.getReason();
            if (DEBUG) {
                String name = this.copy.getSourceData().getName();
                LOGGER.debug("Master local copy " + name + " from " + this.sourcePath + " to " + targetPath + " done");
            }
            if (tgtData != null) {
                LogicalData logicalData = tgtData;
                synchronized (logicalData) {
                    tgtData.addLocation(targetLoc);
                }
            }
            reason.setDataTarget(targetPath);
            this.groupListener.finishedSiblingCopy(this.copy);
        }

        public void failed(IOException e) {
            if (DEBUG) {
                String name = this.copy.getSourceData().getName();
                String targetPath = this.copy.getTargetPath();
                LOGGER.debug("Master local copy " + name + " from " + this.sourcePath + " to " + targetPath + "failed");
            }
            this.groupListener.failedSiblingCopy(this.copy, e);
        }
    }

    private static final class SiblingCopy {
        private final LogicalData sourceData;
        private final String targetPath;
        private final DataLocation targetLoc;
        private final LogicalData targetData;
        private final Transferable reason;
        private final EventListener listener;

        public SiblingCopy(LogicalData sourceData, String targetPath, DataLocation targetLoc, LogicalData targetData, Transferable reason, EventListener listener) {
            this.sourceData = sourceData;
            this.targetPath = targetPath;
            this.targetLoc = targetLoc;
            this.targetData = targetData;
            this.reason = reason;
            this.listener = listener;
        }

        public LogicalData getSourceData() {
            return this.sourceData;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public DataLocation getTargetLocation() {
            return this.targetLoc;
        }

        public LogicalData getTargetData() {
            return this.targetData;
        }

        public Transferable getReason() {
            return this.reason;
        }

        public EventListener getListener() {
            return this.listener;
        }
    }
}

