/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.execution.utils;

import es.bsc.compss.types.execution.Execution;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobQueue {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.ThreadPool");
    private final BlockingQueue<Execution> queue = new LinkedBlockingQueue<Execution>();
    private BlockingDeque<Object> waitingLocks = new LinkedBlockingDeque<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Execution request) {
        if (request.getInvocation() == null) {
            LOGGER.debug("Enqueueing null");
        } else {
            LOGGER.debug("Enqueueing job " + request.getInvocation().getJobId());
        }
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            this.queue.add(request);
            if (!this.waitingLocks.isEmpty()) {
                Object lock;
                Object e = lock = this.waitingLocks.pop();
                synchronized (e) {
                    LOGGER.debug("Releasing lock " + lock.hashCode());
                    lock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Execution dequeue() {
        Execution exec = null;
        Object lock = new Object();
        while (exec == null) {
            Object object = lock;
            synchronized (object) {
                JobQueue jobQueue = this;
                synchronized (jobQueue) {
                    exec = (Execution)this.queue.poll();
                    if (exec != null) {
                        continue;
                    }
                    this.waitingLocks.push(lock);
                }
                try {
                    lock.wait();
                }
                catch (InterruptedException ie) {
                    LOGGER.error("ERROR: Job Thread was interrupted while waiting for next job", (Throwable)ie);
                    return null;
                }
            }
        }
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpAll() {
        LOGGER.info("Waking up " + this.waitingLocks.size() + " locks.");
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            while (!this.waitingLocks.isEmpty()) {
                Object lock;
                Object e = lock = this.waitingLocks.pop();
                synchronized (e) {
                    LOGGER.debug("Release lock" + lock.hashCode());
                    lock.notify();
                }
            }
        }
    }
}

