/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.util;

import es.bsc.compss.exceptions.ExternalPropertyException;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.util.ExternalStreamHandler;
import es.bsc.compss.util.StreamGobbler;
import es.bsc.distrostreamlib.api.DistroStream;
import es.bsc.distrostreamlib.api.files.FileDistroStream;
import es.bsc.distrostreamlib.api.objects.ObjectDistroStream;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.requests.CloseStreamRequest;
import es.bsc.distrostreamlib.requests.Request;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public class BinaryRunner {
    private static final String ERROR_PARAM_NOT_STRING = "ERROR: Binary parameter cannot be serialized to string";
    private static final String ERROR_STREAM = "ERROR: Object and PSCO streams are not supported in non-native tasks";
    private static final String ERROR_OUTPUTREADER = "ERROR: Cannot retrieve command output";
    private static final String ERROR_ERRORREADER = "ERROR: Cannot retrieve command error";
    private static final String ERROR_PROC_EXEC = "ERROR: Exception executing Binary command";
    private static final String ERROR_EXIT_VALUE = "ERROR: Exception exit value is not 0";
    private static final String ERROR_EXT_STREAM_BASE_DIR = "ERROR: Cannot retrieve base_dir from External Stream";
    private static final String ERROR_EXT_STREAM_CLOSURE = "ERROR: Cannot close External Stream due to internal error.";
    private static final String ERROR_EXT_STREAM_GET_ID = "ERROR: Cannot close External Stream due to innvalid Id";
    private static final String DEFAULT_PB_KILL_SIGNAL = "15";
    private static final int PB_KILL_SIGNAL = Integer.valueOf(System.getProperty("compss.worker.killSignal", "15"));
    private static final String APP_PARAMETER_OPEN_TOKEN = "\\{\\{";
    private static final String APP_PARAMETER_OPEN_TOKEN_ORIG = "{{";
    private static final String APP_PARAMETER_CLOSE_TOKEN = "}}";
    private static final String DUMMY_SEPARATOR = "<_<<>>_>";
    private static final String DUMMY_SPACE_REPLACE = "<___>";
    private Process process = null;

    public static ArrayList<String> createCMDParametersFromValues(List<? extends InvocationParam> parameters, InvocationParam target, es.bsc.compss.invokers.types.StdIOStream streamValues, String pythonInterpreter) throws InvokeExecutionException {
        ArrayList<String> binaryParams = new ArrayList<String>();
        for (InvocationParam invocationParam : parameters) {
            binaryParams.addAll(BinaryRunner.processParam(invocationParam, streamValues, pythonInterpreter));
        }
        if (target != null) {
            binaryParams.addAll(BinaryRunner.processParam(target, streamValues, pythonInterpreter));
        }
        return binaryParams;
    }

    public static String[] buildAppParams(List<? extends InvocationParam> parameters, String params, String pythonInterpreter) throws InvokeExecutionException {
        es.bsc.compss.invokers.types.StdIOStream streamValues = new es.bsc.compss.invokers.types.StdIOStream();
        String paramsString = String.join((CharSequence)DUMMY_SPACE_REPLACE, params.split(" "));
        for (InvocationParam invocationParam : parameters) {
            ArrayList<String> tmp = BinaryRunner.processParam(invocationParam, streamValues, pythonInterpreter);
            String value = String.join((CharSequence)DUMMY_SEPARATOR, tmp);
            String replacement = APP_PARAMETER_OPEN_TOKEN + invocationParam.getName().replaceFirst("#kwarg_", "") + APP_PARAMETER_CLOSE_TOKEN;
            paramsString = paramsString.replaceAll(replacement, value);
        }
        paramsString = String.join((CharSequence)DUMMY_SPACE_REPLACE, paramsString.split(DUMMY_SEPARATOR));
        return paramsString.split(DUMMY_SPACE_REPLACE);
    }

    public static File getUpdatedWorkingDir(List<? extends InvocationParam> parameters, String workingDir) {
        if (!workingDir.contains(APP_PARAMETER_OPEN_TOKEN_ORIG) || !workingDir.contains(APP_PARAMETER_CLOSE_TOKEN)) {
            return new File(workingDir);
        }
        block3: for (InvocationParam invocationParam : parameters) {
            if (invocationParam.getStdIOStream() != StdIOStream.UNSPECIFIED || invocationParam.getPrefix().equals("#") || invocationParam.getValue() != null && invocationParam.getValue().getClass().isArray() || invocationParam.getValue() != null && invocationParam.getValue() instanceof Collection) continue;
            switch (invocationParam.getType()) {
                case FILE_T: 
                case COLLECTION_T: 
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    continue block3;
                }
            }
            String pv = invocationParam.getPrefix() != null && !invocationParam.getPrefix().isEmpty() && !invocationParam.getPrefix().equals("null") ? invocationParam.getPrefix() + String.valueOf(invocationParam.getValue()) : String.valueOf(invocationParam.getValue());
            String replacement = APP_PARAMETER_OPEN_TOKEN + invocationParam.getName().replaceFirst("#kwarg_", "") + APP_PARAMETER_CLOSE_TOKEN;
            workingDir = workingDir.replaceAll(replacement, pv);
        }
        return new File(workingDir);
    }

    private static ArrayList<String> processParam(InvocationParam param, es.bsc.compss.invokers.types.StdIOStream streamValues, String pythonInterpreter) throws InvokeExecutionException {
        ArrayList<String> binaryParamFields = new ArrayList<String>();
        switch (param.getStdIOStream()) {
            case STDIN: {
                streamValues.setStdIn((String)param.getValue());
                break;
            }
            case STDOUT: {
                streamValues.setStdOut((String)param.getValue());
                break;
            }
            case STDERR: {
                streamValues.setStdErr((String)param.getValue());
                break;
            }
            case UNSPECIFIED: {
                if (param.getPrefix().equals("#")) break;
                if (param.getValue() != null && param.getValue().getClass().isArray()) {
                    BinaryRunner.addArrayParam(param, binaryParamFields);
                    break;
                }
                if (param.getValue() != null && param.getValue() instanceof Collection) {
                    BinaryRunner.addCollectionParam(param, binaryParamFields);
                    break;
                }
                BinaryRunner.addDirectParam(param, binaryParamFields, pythonInterpreter);
            }
        }
        return binaryParamFields;
    }

    private static void addArrayParam(InvocationParam param, ArrayList<String> binaryParamFields) throws InvokeExecutionException {
        try {
            if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
                binaryParamFields.add(param.getPrefix());
            }
            binaryParamFields.addAll(BinaryRunner.serializeArrayParam(param.getValue()));
        }
        catch (Exception e) {
            throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
        }
    }

    private static void addCollectionParam(InvocationParam param, ArrayList<String> binaryParamFields) throws InvokeExecutionException {
        try {
            if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
                binaryParamFields.add(param.getPrefix());
            }
            binaryParamFields.addAll(BinaryRunner.serializeCollectionParam((Collection)param.getValue()));
        }
        catch (Exception e) {
            throw new InvokeExecutionException(ERROR_PARAM_NOT_STRING, e);
        }
    }

    private static void addDirectParam(InvocationParam param, ArrayList<String> binaryParamFields, String pythonInterpreter) throws InvokeExecutionException {
        if (param.getPrefix() != null && !param.getPrefix().isEmpty() && !param.getPrefix().equals("null")) {
            block2 : switch (param.getType()) {
                case FILE_T: {
                    binaryParamFields.add(param.getPrefix() + param.getOriginalName());
                    break;
                }
                case COLLECTION_T: {
                    binaryParamFields.add(param.getPrefix() + String.valueOf(param.getValue()));
                    break;
                }
                case DICT_COLLECTION_T: {
                    binaryParamFields.add(param.getPrefix() + String.valueOf(param.getValue()));
                    break;
                }
                case STREAM_T: {
                    DistroStream ds = (DistroStream)param.getValue();
                    switch (ds.getStreamType()) {
                        case FILE: {
                            FileDistroStream fds = (FileDistroStream)ds;
                            binaryParamFields.add(param.getPrefix() + fds.getBaseDir());
                            break block2;
                        }
                        case OBJECT: {
                            ObjectDistroStream ods = (ObjectDistroStream)ds;
                            binaryParamFields.add(param.getPrefix() + ods.getAlias());
                            break block2;
                        }
                    }
                    throw new InvokeExecutionException(ERROR_STREAM);
                }
                case EXTERNAL_STREAM_T: {
                    String serializedFile = (String)param.getValue();
                    String baseDir = null;
                    try {
                        baseDir = ExternalStreamHandler.getExternalStreamProperty((String)pythonInterpreter, (String)serializedFile, (String)"base_dir");
                    }
                    catch (ExternalPropertyException epe) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR, (Exception)((Object)epe));
                    }
                    if (baseDir == null || baseDir.isEmpty()) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR);
                    }
                    binaryParamFields.add(param.getPrefix() + baseDir);
                    break;
                }
                default: {
                    binaryParamFields.add(param.getPrefix() + String.valueOf(param.getValue()));
                    break;
                }
            }
        } else {
            block13 : switch (param.getType()) {
                case FILE_T: {
                    binaryParamFields.add(param.getOriginalName());
                    break;
                }
                case COLLECTION_T: {
                    binaryParamFields.add(String.valueOf(param.getValue()));
                    break;
                }
                case DICT_COLLECTION_T: {
                    binaryParamFields.add(String.valueOf(param.getValue()));
                    break;
                }
                case STREAM_T: {
                    DistroStream ds = (DistroStream)param.getValue();
                    switch (ds.getStreamType()) {
                        case FILE: {
                            FileDistroStream fds = (FileDistroStream)ds;
                            binaryParamFields.add(fds.getBaseDir());
                            break block13;
                        }
                        case OBJECT: {
                            ObjectDistroStream ods = (ObjectDistroStream)ds;
                            binaryParamFields.add(ods.getAlias());
                            break block13;
                        }
                    }
                    throw new InvokeExecutionException(ERROR_STREAM);
                }
                case EXTERNAL_STREAM_T: {
                    String serializedFile = (String)param.getValue();
                    String baseDir = null;
                    try {
                        baseDir = ExternalStreamHandler.getExternalStreamProperty((String)pythonInterpreter, (String)serializedFile, (String)"base_dir");
                    }
                    catch (ExternalPropertyException epe) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR, (Exception)((Object)epe));
                    }
                    if (baseDir == null || baseDir.isEmpty()) {
                        throw new InvokeExecutionException(ERROR_EXT_STREAM_BASE_DIR);
                    }
                    binaryParamFields.add(baseDir);
                    break;
                }
                default: {
                    binaryParamFields.add(String.valueOf(param.getValue()));
                }
            }
        }
    }

    private static ArrayList<String> serializeArrayParam(Object value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        if (value instanceof int[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof boolean[]) {
            boolean[] arrayValues;
            for (boolean paramValue : arrayValues = (boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof byte[]) {
            byte[] arrayValues;
            for (byte paramValue : arrayValues = (byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof short[]) {
            short[] arrayValues;
            for (short paramValue : arrayValues = (short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof char[]) {
            int[] arrayValues;
            for (int paramValue : arrayValues = (int[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof long[]) {
            long[] arrayValues;
            for (long paramValue : arrayValues = (long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof float[]) {
            float[] arrayValues;
            for (float paramValue : arrayValues = (float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof double[]) {
            double[] arrayValues;
            for (double paramValue : arrayValues = (double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Integer[]) {
            Integer[] arrayValues;
            for (Integer paramValue : arrayValues = (Integer[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Boolean[]) {
            Boolean[] arrayValues;
            for (Boolean paramValue : arrayValues = (Boolean[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Character[]) {
            Character[] arrayValues;
            for (Character paramValue : arrayValues = (Character[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Byte[]) {
            Byte[] arrayValues;
            for (Byte paramValue : arrayValues = (Byte[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Short[]) {
            Short[] arrayValues;
            for (Short paramValue : arrayValues = (Short[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Long[]) {
            Long[] arrayValues;
            for (Long paramValue : arrayValues = (Long[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Float[]) {
            Float[] arrayValues;
            for (Float paramValue : arrayValues = (Float[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Double[]) {
            Double[] arrayValues;
            for (Double paramValue : arrayValues = (Double[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof String[]) {
            String[] arrayValues;
            for (String paramValue : arrayValues = (String[])value) {
                serializedValue.add(String.valueOf(paramValue));
            }
        } else if (value instanceof Object[]) {
            Object[] arrayValues;
            for (Object paramValue : arrayValues = (Object[])value) {
                serializedValue.addAll(BinaryRunner.serializeArrayParam(paramValue));
            }
        } else {
            serializedValue.add(String.valueOf(value));
        }
        return serializedValue;
    }

    private static ArrayList<String> serializeCollectionParam(Collection<?> value) throws Exception {
        ArrayList<String> serializedValue = new ArrayList<String>();
        Iterator<?> iterator = value.iterator();
        while (iterator.hasNext()) {
            serializedValue.add(String.valueOf(iterator.next()));
        }
        return serializedValue;
    }

    public Object executeCMD(String[] cmd, es.bsc.compss.invokers.types.StdIOStream stdIOStreamValues, File taskSandboxWorkingDir, PrintStream outLog, PrintStream errLog, String pythonPath, boolean failByEV) throws InvokeExecutionException {
        String fileErrPath;
        String fileOutPath;
        String theoreticalHostnames = System.getProperty("COMPSS_HOSTNAMES");
        int theoreticalNumNodes = Integer.valueOf(System.getProperty("COMPSS_NUM_NODES"));
        int theoreticalNumThreads = Integer.valueOf(System.getProperty("COMPSS_NUM_THREADS"));
        int theoreticalNumProcs = Integer.valueOf(System.getProperty("COMPSS_NUM_PROCS"));
        HashMap<String, Integer> hostnames2numThreads = new HashMap<String, Integer>();
        for (String hostname : theoreticalHostnames.split(",")) {
            int nt = hostnames2numThreads.containsKey(hostname) ? (Integer)hostnames2numThreads.get(hostname) + 1 : 1;
            hostnames2numThreads.put(hostname, nt);
        }
        int uniqueNumNodes = hostnames2numThreads.size();
        int maxNumProcsPerNode = (Integer)((Map.Entry)hostnames2numThreads.entrySet().stream().max((entry1, entry2) -> (Integer)entry1.getValue() > (Integer)entry2.getValue() ? 1 : -1).get()).getValue();
        maxNumProcsPerNode *= theoreticalNumProcs;
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(taskSandboxWorkingDir);
        outLog.println("[BINARY EXECUTION WRAPPER] CMD " + cmd[0]);
        builder.environment().remove("LD_PRELOAD");
        builder.environment().put("COMPSS_HOSTNAMES", theoreticalHostnames);
        builder.environment().put("COMPSS_NUM_NODES", String.valueOf(theoreticalNumNodes));
        builder.environment().put("COMPSS_NUM_THREADS", String.valueOf(theoreticalNumThreads));
        builder.environment().put("OMP_NUM_THREADS", String.valueOf(theoreticalNumThreads));
        if (pythonPath != null) {
            builder.environment().put("PYTHONPATH", pythonPath);
            builder.environment().put("SINGULARITYENV_PYTHONPATH", pythonPath);
        }
        String tasksPerNode = String.valueOf(maxNumProcsPerNode) + "(x" + String.valueOf(uniqueNumNodes) + ")";
        String hostnamesString = String.join((CharSequence)",", hostnames2numThreads.keySet());
        int totalProcs = uniqueNumNodes * theoreticalNumProcs;
        builder.environment().put("SLURM_NODELIST", hostnamesString);
        builder.environment().put("SLURM_JOB_NODELIST", hostnamesString);
        builder.environment().put("SLURM_NNODES", String.valueOf(uniqueNumNodes));
        builder.environment().put("SLURM_JOB_NUM_NODES", String.valueOf(uniqueNumNodes));
        builder.environment().put("SLURM_JOB_CPUS_PER_NODE", tasksPerNode);
        builder.environment().put("SLURM_NTASKS", String.valueOf(totalProcs));
        builder.environment().put("SLURM_NPROCS", String.valueOf(totalProcs));
        builder.environment().put("SLURM_TASKS_PER_NODE", tasksPerNode);
        builder.environment().remove("SLURM_STEP_NODELIST");
        builder.environment().remove("SLURM_STEP_CPUS_PER_NODE");
        builder.environment().remove("SLURM_STEP_NUM_TASKS");
        builder.environment().remove("SLURM_STEP_TASKS_PER_NODE");
        builder.environment().remove("SLURM_STEPID");
        builder.environment().remove("SLURM_STEP_ID");
        builder.environment().remove("SLURM_STEP_NUM_NODES");
        builder.environment().remove("SLURM_STEP_LAUNCHER_PORT");
        builder.environment().remove("SLURM_STEP_RESV_PORTS");
        builder.environment().remove("SLURM_NODEID");
        builder.environment().remove("SLURM_LOCALID");
        builder.environment().remove("SLURM_GTIDS");
        builder.environment().remove("SLURM_CPU_BIND");
        builder.environment().remove("SLURM_CPU_BIND_LIST");
        builder.environment().remove("SLURM_CPU_BIND_TYPE");
        builder.environment().remove("SLURM_LAUNCH_NODE_IPADDR");
        builder.environment().remove("SLURM_SRUN_COMM_PORT");
        builder.environment().remove("SLURM_SRUN_COMM_HOST");
        builder.environment().remove("SLURM_TASK_PID");
        builder.environment().remove("SLURM_DISTRIBUTION");
        builder.environment().remove("SLURM_PROCID");
        builder.environment().remove("SLURM_TOPOLOGY_ADDR");
        builder.environment().remove("SLURM_TOPOLOGY_ADDR_PATTERN");
        builder.environment().remove("SLURM_PRIO_PROCESS");
        builder.environment().remove("SLURMD_NODENAME");
        builder.environment().remove("SLURM_MEM_PER_CPU");
        builder.environment().remove("SLURM_MEM_PER_NODE");
        builder.environment().remove("SLURM_SUBMIT_HOST");
        String fileInPath = stdIOStreamValues.getStdIn();
        if (fileInPath != null) {
            builder.redirectInput(new File(fileInPath));
        }
        if ((fileOutPath = stdIOStreamValues.getStdOut()) != null) {
            builder.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(fileOutPath)));
        }
        if ((fileErrPath = stdIOStreamValues.getStdErr()) != null) {
            builder.redirectError(ProcessBuilder.Redirect.appendTo(new File(fileErrPath)));
        }
        int exitValue = -1;
        try {
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
            outLog.println("[BINARY EXECUTION WRAPPER] Executing binary command");
            this.process = builder.start();
            this.process.getOutputStream().close();
            this.logBinaryExecution(this.process, fileOutPath, fileErrPath, outLog, errLog);
            exitValue = this.process.waitFor();
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
            outLog.println("[BINARY EXECUTION WRAPPER] CMD EXIT VALUE: " + exitValue);
            outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        }
        catch (InvokeExecutionException | IOException | InterruptedException e) {
            errLog.println(ERROR_PROC_EXEC);
            throw new InvokeExecutionException(ERROR_PROC_EXEC, (Exception)e);
        }
        if (failByEV && exitValue != 0) {
            throw new InvokeExecutionException(ERROR_EXIT_VALUE);
        }
        return exitValue;
    }

    public void closeStreams(List<? extends InvocationParam> parameters, String pythonInterpreter) throws StreamCloseException {
        for (InvocationParam invocationParam : parameters) {
            if (!invocationParam.isWriteFinalValue()) continue;
            switch (invocationParam.getType()) {
                case STREAM_T: {
                    this.closeStream(invocationParam);
                    break;
                }
                case EXTERNAL_STREAM_T: {
                    this.closeExternalStream(invocationParam, pythonInterpreter);
                    break;
                }
            }
        }
    }

    public void cancelProcess() {
        if (this.process != null) {
            if (this.process.getClass().getName().equals("java.lang.UNIXProcess")) {
                try {
                    Field f = this.process.getClass().getDeclaredField("pid");
                    f.setAccessible(true);
                    int pid = f.getInt(this.process);
                    System.out.println("Killing process " + pid);
                    Runtime.getRuntime().exec("kill -" + PB_KILL_SIGNAL + " " + pid);
                }
                catch (Throwable e) {
                    System.err.println("Error geting pid." + e.getMessage());
                }
            } else {
                this.process.destroy();
            }
        }
    }

    private void logBinaryExecution(Process process, String fileOutPath, String fileErrPath, PrintStream outLog, PrintStream errLog) throws InvokeExecutionException {
        StreamGobbler errorGobbler = null;
        StreamGobbler outputGobbler = null;
        outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        outLog.println("[BINARY EXECUTION WRAPPER] CMD OUTPUT:");
        if (process != null) {
            if (fileOutPath == null) {
                outputGobbler = new StreamGobbler(process.getInputStream(), outLog, LogManager.getLogger((String)"es.bsc.compss.Worker"), false);
                outputGobbler.start();
            } else {
                try (FileInputStream outputStream = new FileInputStream(fileOutPath);){
                    outputGobbler = new StreamGobbler((InputStream)outputStream, outLog, LogManager.getLogger((String)"es.bsc.compss.Worker"), false);
                    outputGobbler.start();
                }
                catch (IOException ioe) {
                    errLog.println(ERROR_OUTPUTREADER);
                    ioe.printStackTrace(errLog);
                    throw new InvokeExecutionException(ERROR_OUTPUTREADER, (Exception)ioe);
                }
            }
        }
        errLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        errLog.println("[BINARY EXECUTION WRAPPER] CMD ERROR:");
        if (process != null) {
            if (fileErrPath == null) {
                errorGobbler = new StreamGobbler(process.getErrorStream(), errLog, LogManager.getLogger((String)"es.bsc.compss.Worker"), true);
                errorGobbler.start();
            } else {
                try (FileInputStream errStream = new FileInputStream(fileErrPath);){
                    errorGobbler = new StreamGobbler((InputStream)errStream, errLog, LogManager.getLogger((String)"es.bsc.compss.Worker"), true);
                    errorGobbler.start();
                }
                catch (IOException ioe) {
                    throw new InvokeExecutionException(ERROR_ERRORREADER, (Exception)ioe);
                }
            }
        }
        if (outputGobbler != null) {
            try {
                outputGobbler.join();
            }
            catch (InterruptedException e) {
                errLog.println("Error waiting for output gobbler to end");
                e.printStackTrace(errLog);
            }
        }
        outLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
        if (errorGobbler != null) {
            try {
                errorGobbler.join();
            }
            catch (InterruptedException e) {
                errLog.println("Error waiting for error gobbler to end");
                e.printStackTrace(errLog);
            }
        }
        errLog.println("[BINARY EXECUTION WRAPPER] ------------------------------------");
    }

    private void closeStream(InvocationParam p) {
        DistroStream ds = (DistroStream)p.getValue();
        ds.close();
    }

    private void closeExternalStream(InvocationParam p, String pythonInterpreter) throws StreamCloseException {
        String serializedFile = p.getValue().toString();
        String streamId = null;
        try {
            streamId = ExternalStreamHandler.getExternalStreamProperty((String)pythonInterpreter, (String)serializedFile, (String)"id");
        }
        catch (ExternalPropertyException epe) {
            throw new StreamCloseException(ERROR_EXT_STREAM_GET_ID);
        }
        if (streamId != null) {
            CloseStreamRequest req = new CloseStreamRequest(streamId);
            DistroStreamClient.request((Request)req);
            req.waitProcessed();
            int error = req.getErrorCode();
            if (error != 0) {
                String internalError = "ERROR CODE = " + error + " ERROR MESSAGE = " + req.getErrorMessage();
                throw new StreamCloseException(ERROR_EXT_STREAM_CLOSURE + internalError);
            }
        } else {
            throw new StreamCloseException(ERROR_EXT_STREAM_GET_ID);
        }
    }
}

