/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.util;

import es.bsc.compss.executor.types.Execution;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobQueue {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.ThreadPool");
    private final BlockingQueue<Execution> queue = new LinkedBlockingQueue<Execution>();
    private BlockingDeque<Object> waitingLocks = new LinkedBlockingDeque<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Execution request) {
        if (request.getInvocation() == null) {
            LOGGER.debug("Enqueueing null");
        } else {
            LOGGER.debug("Enqueueing job " + request.getInvocation().getJobId());
        }
        this.queue.add(request);
        if (!this.waitingLocks.isEmpty()) {
            Object lock;
            Object e = lock = this.waitingLocks.pop();
            synchronized (e) {
                LOGGER.debug("Releasing lock " + lock.hashCode());
                lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Execution dequeue() {
        Execution exec = null;
        while ((exec = (Execution)this.queue.poll()) == null) {
            Object lock = new Object();
            this.waitingLocks.push(lock);
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait();
                }
            }
            catch (InterruptedException ie) {
                LOGGER.error("ERROR: Job Thread was interrupted while waiting for next job", (Throwable)ie);
                return null;
            }
        }
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpAll() {
        LOGGER.info("Waking up " + this.waitingLocks.size() + " locks.");
        while (!this.waitingLocks.isEmpty()) {
            Object lock;
            Object e = lock = this.waitingLocks.pop();
            synchronized (e) {
                LOGGER.debug("Release lock" + lock.hashCode());
                lock.notify();
            }
        }
    }
}

