/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.types;

import es.bsc.compss.types.annotations.parameter.DataType;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalTaskStatus {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.Executor");
    private final Integer exitValue;
    private final List<DataType> updatedParameterTypes;
    private final List<String> updatedParameterValues;

    public ExternalTaskStatus(Integer exitValue) {
        this.exitValue = exitValue;
        this.updatedParameterTypes = new LinkedList<DataType>();
        this.updatedParameterValues = new LinkedList<String>();
    }

    public ExternalTaskStatus(String[] line) {
        this.updatedParameterTypes = new LinkedList<DataType>();
        this.updatedParameterValues = new LinkedList<String>();
        this.exitValue = Integer.parseInt(line[2]);
        if (line.length > 3) {
            int numParams = Integer.parseInt(line[3]);
            if (4 + 2 * numParams != line.length) {
                LOGGER.warn("WARN: Skipping endTask parameters because of malformation.");
                numParams = (line.length - 4) / 2;
            }
            for (int i = 0; i < numParams; ++i) {
                int paramTypeOrdinalIndex = 0;
                try {
                    paramTypeOrdinalIndex = Integer.parseInt(line[4 + 2 * i]);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("WARN: Number format exception on " + line[4 + 2 * i] + ". Setting type 0", (Throwable)nfe);
                }
                DataType paramType = DataType.values()[paramTypeOrdinalIndex];
                String paramValue = line[5 + 2 * i];
                if (paramValue.equalsIgnoreCase("null")) {
                    paramValue = null;
                }
                this.addParameter(paramType, paramValue);
            }
        } else {
            LOGGER.warn("WARN: endTask message does not have task result parameters");
        }
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public int getNumParameters() {
        return this.updatedParameterValues.size();
    }

    public List<DataType> getParameterTypes() {
        return this.updatedParameterTypes;
    }

    public List<String> getParameterValues() {
        return this.updatedParameterValues;
    }

    public DataType getParameterType(int i) {
        if (i >= 0 && i < this.updatedParameterTypes.size()) {
            return this.updatedParameterTypes.get(i);
        }
        return null;
    }

    public String getParameterValue(int i) {
        if (i >= 0 && i < this.updatedParameterValues.size()) {
            return this.updatedParameterValues.get(i);
        }
        return null;
    }

    public void addParameter(DataType type, String value) {
        this.updatedParameterTypes.add(type);
        this.updatedParameterValues.add(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalTaskStatus [ ");
        sb.append("ExitValue = ").append(this.exitValue).append(", ");
        sb.append("NumParameters = ").append(this.getNumParameters()).append(", ");
        sb.append("ParameterTypes = [");
        for (DataType type : this.updatedParameterTypes) {
            sb.append(type.ordinal()).append(" ");
        }
        sb.append("], ");
        sb.append("ParameterValues = [");
        for (String value : this.updatedParameterValues) {
            sb.append(value).append(" ");
        }
        sb.append("]");
        sb.append(" ]");
        return sb.toString();
    }
}

