/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.JavaInvoker;
import es.bsc.compss.invokers.util.ClassUtils;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.loader.LoaderUtils;
import es.bsc.compss.loader.total.ITAppEditor;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.util.parsers.ITFParser;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;

public class JavaNestedInvoker
extends JavaInvoker {
    private static final String ENGINE_PATH;
    private String ceiName;
    private Class<?> ceiClass;
    private final COMPSsRuntime runtimeAPI;
    private final LoaderAPI loaderAPI;

    public JavaNestedInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        this.runtimeAPI = context.getRuntimeAPI();
        this.loaderAPI = context.getLoaderAPI();
    }

    @Override
    protected Method findMethod() throws JobExecutionException {
        Method method;
        Class<?> ceiClass;
        this.ceiName = this.invocation.getParallelismSource();
        if (this.ceiName != null) {
            try {
                ceiClass = Class.forName(this.ceiName);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.warn("Requesting a Nested Invoker with not found CEI " + this.ceiName + " for Job " + this.invocation.getJobId() + ". Proxying invoker to a regular Java Invoker.");
                ceiClass = null;
            }
        } else {
            LOGGER.warn("Requesting a Nested Invoker with no CEI for Job " + this.invocation.getJobId() + ". Proxying invoker to a regular Java Invoker.");
            ceiClass = null;
        }
        this.ceiClass = ceiClass;
        if (ceiClass == null) {
            method = super.findMethod();
        } else {
            try {
                URLClassLoader myLoader = new URLClassLoader(new URL[]{new URL(ENGINE_PATH)});
                Thread.currentThread().setContextClassLoader(myLoader);
                ClassPool classPool = JavaNestedInvoker.getClassPool();
                CtClass appClass = classPool.get(this.className);
                appClass.defrost();
                String varName = LoaderUtils.randomName((int)5, (String)"compss");
                String itApiVar = varName + "Api";
                String itSRVar = varName + "SR";
                String itORVar = varName + "OR";
                String itAppIdVar = varName + "AppId";
                JavaNestedInvoker.addVariables(classPool, appClass, itApiVar, itSRVar, itORVar, itAppIdVar);
                JavaNestedInvoker.instrumentClass(classPool, appClass, ceiClass, itApiVar, itSRVar, itORVar, itAppIdVar);
                JavaNestedInvoker.addModifyVariablesMethod(appClass, itApiVar, itSRVar, itORVar, itAppIdVar);
                this.methodClass = appClass.toClass();
                appClass.defrost();
                method = ClassUtils.findMethod(this.methodClass, this.methodName, this.invocation.getParams());
            }
            catch (Exception e) {
                LOGGER.warn("Could not instrument the method to detect nested tasks.", (Throwable)e);
                method = super.findMethod();
            }
        }
        return method;
    }

    private static ClassPool getClassPool() {
        ClassPool cp = new ClassPool();
        cp.appendSystemPath();
        cp.importPackage("es.bsc.compss");
        cp.importPackage("es.bsc.compss.api");
        cp.importPackage("es.bsc.compss.api.impl");
        cp.importPackage("es.bsc.compss.loader");
        cp.importPackage("es.bsc.compss.loader.total");
        return cp;
    }

    private static void addVariables(ClassPool cp, CtClass appClass, String itApiVar, String itSRVar, String itORVar, String itAppIdVar) throws NotFoundException, CannotCompileException {
        CtClass itApiClass = cp.get(LoaderConstants.CLASS_COMPSSRUNTIME_API);
        CtField itApiField = new CtField(itApiClass, itApiVar, appClass);
        itApiField.setModifiers(10);
        appClass.addField(itApiField);
        CtClass itSRClass = cp.get(LoaderConstants.CLASS_STREAM_REGISTRY);
        CtField itSRField = new CtField(itSRClass, itSRVar, appClass);
        itSRField.setModifiers(10);
        appClass.addField(itSRField);
        CtClass itORClass = cp.get(LoaderConstants.CLASS_OBJECT_REGISTRY);
        CtField itORField = new CtField(itORClass, itORVar, appClass);
        itORField.setModifiers(10);
        appClass.addField(itORField);
        CtClass appIdClass = cp.get(LoaderConstants.CLASS_APP_ID);
        CtField appIdField = new CtField(appIdClass, itAppIdVar, appClass);
        appIdField.setModifiers(10);
        appClass.addField(appIdField);
    }

    private static void instrumentClass(ClassPool cp, CtClass appClass, Class<?> annotItf, String itApiVar, String itSRVar, String itORVar, String itAppIdVar) throws ClassNotFoundException, NotFoundException, CannotCompileException {
        Method[] remoteMethods = annotItf.getMethods();
        CtMethod[] instrCandidates = appClass.getDeclaredMethods();
        ITAppEditor itAppEditor = new ITAppEditor(remoteMethods, instrCandidates, itApiVar, itSRVar, itORVar, itAppIdVar, appClass);
        CodeConverter converter = new CodeConverter();
        CtClass arrayWatcher = cp.get(LoaderConstants.CLASS_ARRAY_ACCESS_WATCHER);
        CodeConverter.DefaultArrayAccessReplacementMethodNames names = new CodeConverter.DefaultArrayAccessReplacementMethodNames();
        converter.replaceArrayAccess(arrayWatcher, (CodeConverter.ArrayAccessReplacementMethodNames)names);
        for (CtMethod ctMethod : instrCandidates) {
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
        for (CtMethod ctMethod : appClass.getDeclaredConstructors()) {
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
    }

    private static void addModifyVariablesMethod(CtClass appClass, String itApiVar, String itSRVar, String itORVar, String itAppIdVar) throws CannotCompileException, NotFoundException {
        StringBuilder methodBody = new StringBuilder();
        methodBody.append("public static void printCOMPSsVariables() { ");
        methodBody.append("System.out.println(\"Api Var: \" + ").append(itApiVar).append(");");
        methodBody.append("System.out.println(\"SR Var: \" + ").append(itSRVar).append(");");
        methodBody.append("System.out.println(\"OR Var: \" + ").append(itORVar).append(");");
        methodBody.append("System.out.println(\"App Id: \" + ").append(itAppIdVar).append(");");
        methodBody.append("}");
        CtMethod m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static void setCOMPSsVariables( ").append(LoaderConstants.CLASS_COMPSSRUNTIME_API).append(" runtime, ").append(LoaderConstants.CLASS_LOADERAPI).append(" loader, ").append(LoaderConstants.CLASS_APP_ID).append(" appId) {");
        methodBody.append(itApiVar).append("= runtime;");
        methodBody.append(itSRVar).append("= loader.getStreamRegistry();");
        methodBody.append(itORVar).append("= loader.getObjectRegistry();");
        methodBody.append(itAppIdVar).append("= appId;");
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
    }

    @Override
    protected Object runMethod() throws JobExecutionException {
        if (this.ceiClass != null) {
            Method setter;
            long appId = this.runtimeAPI.registerApplication(this.ceiName);
            List ceds = ITFParser.parseITFMethods(this.ceiClass);
            for (CoreElementDefinition ced : ceds) {
                this.runtimeAPI.registerCoreElement(ced);
            }
            try {
                setter = this.methodClass.getDeclaredMethod("setCOMPSsVariables", Class.forName(LoaderConstants.CLASS_COMPSSRUNTIME_API), Class.forName(LoaderConstants.CLASS_LOADERAPI), Class.forName(LoaderConstants.CLASS_APP_ID));
            }
            catch (Exception e) {
                throw new JobExecutionException("Class not properly instrumented. Method setCOMPSsVariables not found!", (Throwable)e);
            }
            try {
                Object[] values = new Object[]{this.runtimeAPI, this.loaderAPI, appId};
                setter.invoke(null, values);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new JobExecutionException("Error setting Nested COMPSs variables", (Throwable)e);
            }
            try {
                Object internal;
                Object returnValue = super.runMethod();
                if (returnValue != null && (internal = this.context.getLoaderAPI().getObjectRegistry().getInternalObject(Long.valueOf(appId), returnValue)) != null) {
                    returnValue = internal;
                }
                for (InvocationParam p : this.invocation.getParams()) {
                    this.getLastValue(appId, p);
                }
                for (InvocationParam p : this.invocation.getResults()) {
                    this.getLastValue(appId, p);
                }
                this.runtimeAPI.noMoreTasks(Long.valueOf(appId));
                internal = returnValue;
                return internal;
            }
            catch (Throwable e) {
                throw new JobExecutionException("Error executing the instrumented method!", e);
            }
            finally {
                this.runtimeAPI.deregisterApplication(Long.valueOf(appId));
            }
        }
        Object returnValue = super.runMethod();
        return returnValue;
    }

    private void getLastValue(Long appId, InvocationParam p) {
        switch (p.getType()) {
            case OBJECT_T: 
            case PSCO_T: {
                this.context.getLoaderAPI().getObjectRegistry().newObjectAccess(appId, p.getValue(), false);
                Object internal = this.context.getLoaderAPI().getObjectRegistry().getInternalObject(appId, p.getValue());
                p.setValue(internal);
                break;
            }
            case FILE_T: {
                this.context.getRuntimeAPI().getFile(appId, p.getOriginalName());
                new File((String)p.getValue());
                new File(p.getOriginalName());
                break;
            }
        }
    }

    static {
        String compssHome = System.getenv("COMPSS_HOME");
        ENGINE_PATH = "file:" + compssHome + LoaderConstants.ENGINE_JAR_WITH_REL_PATH;
    }
}

