/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.MPIImplementation;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class MPIInvoker
extends Invoker {
    private static final int NUM_BASE_MPI_ARGS = 6;
    private static final String ERROR_MPI_RUNNER = "ERROR: Invalid mpiRunner";
    private static final String ERROR_MPI_BINARY = "ERROR: Invalid mpiBinary";
    private static final String ERROR_TARGET_PARAM = "ERROR: MPI Execution doesn't support target parameters";
    private final String mpiRunner;
    private final String mpiFlags;
    private final String mpiBinary;
    private final boolean scaleByCU;
    private final boolean failByEV;
    private BinaryRunner br;

    public MPIInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        MPIImplementation mpiImpl = null;
        try {
            mpiImpl = (MPIImplementation)this.invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + this.invocation.getMethodImplementation().getMethodType(), (Throwable)e);
        }
        this.mpiRunner = mpiImpl.getMpiRunner();
        this.mpiFlags = mpiImpl.getMpiFlags();
        this.mpiBinary = mpiImpl.getBinary();
        this.scaleByCU = mpiImpl.getScaleByCU();
        this.failByEV = mpiImpl.isFailByEV();
        this.br = null;
    }

    private void checkArguments() throws JobExecutionException {
        if (this.mpiRunner == null || this.mpiRunner.isEmpty()) {
            throw new JobExecutionException(ERROR_MPI_RUNNER);
        }
        if (this.mpiBinary == null || this.mpiBinary.isEmpty()) {
            throw new JobExecutionException(ERROR_MPI_BINARY);
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoked " + this.mpiBinary + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException((Throwable)iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (lp instanceof PythonParams) {
                    PythonParams pp = (PythonParams)lp;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException((Throwable)se);
        }
        for (InvocationParam np : this.invocation.getResults()) {
            if (np.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(np, retValue);
                continue;
            }
            np.setValue(retValue);
            np.setValueClass(retValue.getClass());
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        int i;
        String pythonInterpreter = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.getPythonInterpreter();
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
        String hostfile = null;
        int numMPIArgs = 6;
        hostfile = this.scaleByCU ? MPIInvoker.writeHostfile(this.taskSandboxWorkingDir, this.workers) : MPIInvoker.writeHostfile(this.taskSandboxWorkingDir, this.hostnames);
        int numMPIFlags = 0;
        String[] mpiflagsArray = null;
        if (this.mpiFlags != null && !this.mpiFlags.isEmpty() && !this.mpiFlags.equals("[unassigned]")) {
            mpiflagsArray = this.mpiFlags.split(" ");
            numMPIFlags = mpiflagsArray.length;
        }
        String[] cmd = new String[numMPIArgs + numMPIFlags + binaryParams.size()];
        int pos = 0;
        cmd[pos++] = this.mpiRunner;
        cmd[pos++] = "-hostfile";
        cmd[pos++] = hostfile;
        cmd[pos++] = "-n";
        cmd[pos++] = this.scaleByCU ? String.valueOf(this.numWorkers * this.computingUnits) : String.valueOf(this.numWorkers);
        for (i = 0; i < numMPIFlags; ++i) {
            cmd[pos++] = mpiflagsArray[i];
        }
        cmd[pos++] = this.mpiBinary;
        for (i = 0; i < binaryParams.size(); ++i) {
            cmd[pos++] = binaryParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[MPI INVOKER] Begin MPI call to " + this.mpiBinary);
            outLog.println("[MPI INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
            outLog.print("[MPI INVOKER] MPI CMD: ");
            for (int i2 = 0; i2 < cmd.length; ++i2) {
                outLog.print(cmd[i2] + " ");
            }
            outLog.println("");
            outLog.println("[MPI INVOKER] MPI STDIN: " + streamValues.getStdIn());
            outLog.println("[MPI INVOKER] MPI STDOUT: " + streamValues.getStdOut());
            outLog.println("[MPI INVOKER] MPI STDERR: " + streamValues.getStdErr());
        }
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, this.failByEV);
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling MPI process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

