/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.binders;

import es.bsc.compss.types.execution.ThreadBinder;
import es.bsc.compss.types.execution.exceptions.InvalidMapException;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableComputingUnitsException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BindToMap
implements ThreadBinder {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.ThreadBinder");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private ArrayList<ArrayList<Integer>> idList = new ArrayList();
    private int[] bindedComputingUnits;

    public BindToMap(int numThreads, String socketString) {
        String[] slots;
        ArrayList<ArrayList<Integer>> computingUnitsIds = new ArrayList<ArrayList<Integer>>();
        int realAmountThreads = 0;
        int maxThreadNum = 0;
        for (String availableCpus : slots = socketString.split("/")) {
            String[] intervals = availableCpus.split(",");
            ArrayList<Integer> currentIds = new ArrayList<Integer>();
            for (String currentInterval : intervals) {
                String[] bounds = currentInterval.split("-");
                int lowerBound = Integer.parseInt(bounds[0]);
                int upperBound = bounds.length == 2 ? Integer.parseInt(bounds[1]) : lowerBound;
                if (upperBound > maxThreadNum) {
                    maxThreadNum = upperBound;
                }
                realAmountThreads += upperBound - lowerBound + 1;
                for (int i = 0; i < upperBound - lowerBound + 1; ++i) {
                    currentIds.add(lowerBound + i);
                }
            }
            computingUnitsIds.add(currentIds);
        }
        this.auxiliarConstructor(numThreads, computingUnitsIds, realAmountThreads, maxThreadNum);
    }

    public static String getResourceCpuDescription() throws InvalidMapException {
        String cmdOutput = BindToMap.getLsCpuOutput();
        return BindToMap.processLsCpuOutput(cmdOutput);
    }

    private static String getLsCpuOutput() throws InvalidMapException {
        String cmdOutput = null;
        ProcessBuilder pb = new ProcessBuilder("lscpu");
        try {
            pb.environment().remove("LD_PRELOAD");
            Process process = pb.start();
            process.getOutputStream().close();
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                throw new InvalidMapException("ERROR: LSCPU command failed with exitValue " + exitValue);
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            catch (IOException ioe) {
                throw new InvalidMapException("ERROR: Cannot retrieve LSCPU command output", (Exception)ioe);
            }
            cmdOutput = sb.toString();
        }
        catch (IOException ioe) {
            throw new InvalidMapException("ERROR: Cannot start LSCPU ProcessBuilder", (Exception)ioe);
        }
        catch (InterruptedException ie) {
            throw new InvalidMapException("ERROR: LSCPU command interrupted", (Exception)ie);
        }
        return cmdOutput;
    }

    /*
     * WARNING - void declaration
     */
    public static String processLsCpuOutput(String cmdOutput) {
        String cpuMap;
        if (DEBUG) {
            LOGGER.debug("Parsing LSCPU Output : " + cmdOutput);
        }
        String[] cmdLines = cmdOutput.split("\n");
        Integer numSockets = null;
        Integer coresPerSocket = null;
        Integer threadsPerCore = null;
        Integer numCpus = null;
        ArrayList<String> numaDescription = new ArrayList<String>();
        for (String string : cmdLines) {
            String numCpusString;
            String[] lineValues;
            if (string.contains("Socket(s):")) {
                lineValues = string.split(" ");
                String numSocketsString = lineValues[lineValues.length - 1];
                if (numSocketsString == null || numSocketsString.isEmpty()) continue;
                numSockets = Integer.parseInt(numSocketsString);
                continue;
            }
            if (string.contains("Core(s) per socket:")) {
                lineValues = string.split(" ");
                String coresPerSocketString = lineValues[lineValues.length - 1];
                if (coresPerSocketString == null || coresPerSocketString.isEmpty()) continue;
                coresPerSocket = Integer.parseInt(coresPerSocketString);
                continue;
            }
            if (string.contains("Thread(s) per core:")) {
                lineValues = string.split(" ");
                String threadsPerCoreString = lineValues[lineValues.length - 1];
                if (threadsPerCoreString == null || threadsPerCoreString.isEmpty()) continue;
                threadsPerCore = Integer.parseInt(threadsPerCoreString);
                continue;
            }
            if (string.contains("NUMA node") && string.contains("CPU(s):")) {
                void var10_12;
                while (var10_12.contains("  ")) {
                    String string2 = var10_12.replaceAll("  ", " ");
                }
                lineValues = var10_12.split(" ");
                if (lineValues.length != 4) continue;
                String coresDescription = lineValues[lineValues.length - 1];
                numaDescription.add(coresDescription);
                continue;
            }
            if (!string.contains("CPU(s):") || (numCpusString = (lineValues = string.split(" "))[lineValues.length - 1]) == null || numCpusString.isEmpty()) continue;
            numCpus = Integer.parseInt(numCpusString);
        }
        if (numSockets == null || numSockets <= 0) {
            LOGGER.debug("CPU Map constructed by General Affinity");
            cpuMap = "0-" + String.valueOf(numCpus);
        } else if (!numaDescription.isEmpty()) {
            LOGGER.debug("CPU Map constructed by Affinity per Numa Node");
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String descr : numaDescription) {
                if (!first) {
                    sb.append("/");
                } else {
                    first = false;
                }
                sb.append(descr);
            }
            cpuMap = sb.toString();
        } else {
            void var10_17;
            LOGGER.debug("CPU Map constructed by Affinity per socket");
            StringBuilder sb = new StringBuilder();
            int cpusPerSocket = coresPerSocket * threadsPerCore;
            boolean bl = false;
            while (var10_17 < numSockets) {
                void low = var10_17 * cpusPerSocket;
                void high = (var10_17 + true) * cpusPerSocket - true;
                if (var10_17 != false) {
                    sb.append("/");
                }
                sb.append(String.valueOf((int)low)).append("-").append(String.valueOf((int)high));
                ++var10_17;
            }
            cpuMap = sb.toString();
        }
        LOGGER.info("CPU Map: " + cpuMap);
        return cpuMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] bindComputingUnits(int jobId, int numCUs, int[] previousAllocation) throws UnsufficientAvailableComputingUnitsException {
        int[] assignedCoreUnits = new int[numCUs];
        BindToMap bindToMap = this;
        synchronized (bindToMap) {
            if (previousAllocation != null && previousAllocation.length == numCUs && this.isAllocationAvailable(previousAllocation)) {
                this.assignAllocation(previousAllocation, jobId);
                return previousAllocation;
            }
            ArrayList<Integer> usedSockets = this.recursiveBindingComputingUnits(jobId, numCUs, 0);
            if (usedSockets == null) {
                throw new UnsufficientAvailableComputingUnitsException("Not enough available computing units for task execution " + jobId);
            }
            int numAssignedCores = 0;
            for (int socket : usedSockets) {
                ArrayList<Integer> currentSocketThreads = this.idList.get(socket);
                for (int i = 0; i < currentSocketThreads.size() && numAssignedCores < numCUs; ++i) {
                    int coreNum = currentSocketThreads.get(i);
                    if (this.bindedComputingUnits[coreNum] != -1) continue;
                    this.bindedComputingUnits[coreNum] = jobId;
                    assignedCoreUnits[numAssignedCores] = coreNum;
                    ++numAssignedCores;
                }
                if (numAssignedCores != numCUs) continue;
                break;
            }
            this.updateSocketPriority();
        }
        if (DEBUG) {
            StringBuilder sb = new StringBuilder("[ThreadBinderCPUs] Task " + jobId + " binded to cores ");
            if (assignedCoreUnits.length != 0) {
                sb.append(assignedCoreUnits[0]);
            }
            for (int i = 1; i < assignedCoreUnits.length; ++i) {
                sb.append(" ").append(assignedCoreUnits[i]);
            }
            LOGGER.debug(sb.toString());
        }
        return assignedCoreUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseComputingUnits(int jobId) {
        BindToMap bindToMap = this;
        synchronized (bindToMap) {
            for (int i = 0; i < this.bindedComputingUnits.length; ++i) {
                if (this.bindedComputingUnits[i] != jobId) continue;
                this.bindedComputingUnits[i] = -1;
            }
            this.updateSocketPriority();
        }
    }

    private void assignAllocation(int[] previousAllocation, int jobId) {
        for (int coreId : previousAllocation) {
            this.bindedComputingUnits[coreId] = jobId;
        }
    }

    private boolean isAllocationAvailable(int[] previousAllocation) {
        for (int coreId : previousAllocation) {
            if (this.bindedComputingUnits[coreId] == -1) continue;
            return false;
        }
        return true;
    }

    private void auxiliarConstructor(int numThreads, ArrayList<ArrayList<Integer>> computingUnitsIds, int totalAmountThreads, int maxThreadNum) {
        int i;
        this.bindedComputingUnits = new int[maxThreadNum + 1];
        for (i = 0; i <= maxThreadNum; ++i) {
            this.bindedComputingUnits[i] = -1;
        }
        this.idList = computingUnitsIds;
        for (i = 0; i < this.idList.get(0).size() && totalAmountThreads < numThreads; ++i) {
            for (int j = 0; j < this.idList.size() && totalAmountThreads < numThreads; ++j) {
                ArrayList<Integer> currentSocketIds = this.idList.get(j);
                currentSocketIds.add(this.idList.get(j).get(i));
                this.idList.set(j, currentSocketIds);
            }
        }
        if (DEBUG) {
            for (i = 0; i < this.idList.size(); ++i) {
                LOGGER.debug("[ThreadBinderCPUs] Socket " + i);
                StringBuilder sb = new StringBuilder("[ThreadBinderCPUs] Registered slots: ");
                StringBuilder sb2 = new StringBuilder("[ThreadBinderCPUs] Registered ids: ");
                for (int j = 0; j < this.idList.get(i).size(); ++j) {
                    int coreNum = this.idList.get(i).get(j);
                    sb.append(this.bindedComputingUnits[coreNum]).append(" ");
                    sb2.append(coreNum).append(" ");
                }
                LOGGER.debug(sb.toString());
                LOGGER.debug(sb2.toString());
            }
        }
    }

    private int getAvailableSlots(ArrayList<Integer> socket) {
        int counter = 0;
        for (int i : socket) {
            if (this.bindedComputingUnits[i] != -1) continue;
            ++counter;
        }
        return counter;
    }

    private ArrayList<Integer> recursiveBindingComputingUnits(int jobId, int amount, int index) {
        int newAmountThreads;
        ArrayList<Integer> nextSocketsUsed;
        int availableSlots = this.getAvailableSlots(this.idList.get(index));
        if (availableSlots >= amount) {
            ArrayList<Integer> socketUsed = new ArrayList<Integer>();
            socketUsed.add(index);
            return socketUsed;
        }
        if (availableSlots > 0 && (nextSocketsUsed = this.recursiveBindingComputingUnits(jobId, newAmountThreads = amount - availableSlots, index + 1)) != null) {
            nextSocketsUsed.add(index);
            return nextSocketsUsed;
        }
        return null;
    }

    private void updateSocketPriority() {
        ArrayList<Integer> sockets = new ArrayList<Integer>();
        final ArrayList<Integer> availableSlots = new ArrayList<Integer>();
        for (int i = 0; i < this.idList.size(); ++i) {
            sockets.add(i);
            availableSlots.add(this.getAvailableSlots(this.idList.get(i)));
        }
        Comparator<Integer> customComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer first, Integer second) {
                return Integer.compare((Integer)availableSlots.get(second), (Integer)availableSlots.get(first));
            }
        };
        Collections.sort(sockets, customComparator);
        ArrayList<ArrayList<Integer>> newComputingUnitsIds = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < this.idList.size(); ++i) {
            int currentSocketIndex = (Integer)sockets.get(i);
            newComputingUnitsIds.add(this.idList.get(currentSocketIndex));
        }
        this.idList = newComputingUnitsIds;
    }
}

