/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.types.StdIOStream;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.definition.JuliaDefinition;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class JuliaInvoker
extends Invoker {
    private static final int NUM_BASE_JULIA_ARGS = 8;
    private static final String ERROR_TARGET_PARAM = "ERROR: Julia execution doesn't support target parameters";
    JuliaDefinition juliaDef;
    private BinaryRunner br;

    public JuliaInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandbox, assignedResources);
        try {
            this.juliaDef = (JuliaDefinition)invocation.getMethodImplementation().getDefinition();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + invocation.getMethodImplementation().getMethodType(), (Throwable)e);
        }
        this.br = null;
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoked " + this.juliaDef.getJuliaScript() + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException((Throwable)iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (lp instanceof PythonParams) {
                    PythonParams pp = (PythonParams)lp;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException((Throwable)se);
        }
        for (InvocationParam np : this.invocation.getResults()) {
            if (np.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(np, retValue);
                continue;
            }
            np.setValue(retValue);
            np.setValueClass(retValue.getClass());
        }
    }

    private void checkArguments() throws JobExecutionException {
        try {
            this.juliaDef.checkArguments();
        }
        catch (IllegalArgumentException ie) {
            throw new JobExecutionException((Throwable)ie);
        }
        String dfScript = this.juliaDef.getJuliaScript();
        if (!dfScript.startsWith(File.separator)) {
            this.juliaDef.setJuliaScript(this.context.getAppDir() + File.separator + dfScript);
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String juliaRunner;
        String pythonInterpreter = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.getPythonInterpreter();
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
        String args = new String();
        for (int i = 0; i < binaryParams.size(); ++i) {
            args = i == 0 ? args.concat(binaryParams.get(i)) : args.concat(" " + binaryParams.get(i));
        }
        String[] cmd = args.isEmpty() ? new String[7] : new String[8];
        cmd[0] = juliaRunner = this.context.getInstallDir() + JuliaDefinition.SCRIPT_PATH;
        cmd[1] = this.juliaDef.getJuliaExecutor();
        cmd[2] = this.juliaDef.getJuliaScript();
        cmd[3] = this.juliaDef.getWorkingDir();
        cmd[4] = String.valueOf(this.juliaDef.getFailByEV());
        cmd[5] = String.valueOf(this.juliaDef.getComputingNodes());
        cmd[6] = String.valueOf(this.invocation.isDebugEnabled());
        if (!args.isEmpty()) {
            cmd[7] = args;
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[JULIA INVOKER] Begin JULIA call to " + this.juliaDef.getJuliaScript());
            outLog.println("[JULIA INVOKER] On WorkingDir : " + this.sandBox.getFolder().getAbsolutePath());
            outLog.print("[JULIA INVOKER] Julia CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[JULIA INVOKER] Julia STDIN: " + streamValues.getStdIn());
            outLog.println("[JULIA INVOKER] Julia STDOUT: " + streamValues.getStdOut());
            outLog.println("[JULIA INVOKER] Julia STDERR: " + streamValues.getStdErr());
        }
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.sandBox, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, this.juliaDef.getFailByEV());
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling Julia process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

