/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.types.StdIOStream;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class DecafInvoker
extends Invoker {
    private static final int NUM_BASE_DECAF_ARGS = 11;
    private static final String ERROR_TARGET_PARAM = "ERROR: MPI Execution doesn't support target parameters";
    DecafDefinition decafDef;
    private BinaryRunner br;

    public DecafInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandbox, assignedResources);
        try {
            this.decafDef = (DecafDefinition)invocation.getMethodImplementation().getDefinition();
            this.decafDef.setRunnerProperties(context.getInstallDir());
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + invocation.getMethodImplementation().getMethodType(), (Throwable)e);
        }
        this.br = null;
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoked " + this.decafDef.getDfScript() + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException((Throwable)iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (lp instanceof PythonParams) {
                    PythonParams pp = (PythonParams)lp;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException((Throwable)se);
        }
        for (InvocationParam np : this.invocation.getResults()) {
            if (np.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(np, retValue);
                continue;
            }
            np.setValue(retValue);
            np.setValueClass(retValue.getClass());
        }
    }

    private void checkArguments() throws JobExecutionException {
        try {
            this.decafDef.checkArguments();
        }
        catch (IllegalArgumentException ie) {
            throw new JobExecutionException((Throwable)ie);
        }
        String dfScript = this.decafDef.getDfScript();
        if (!dfScript.startsWith(File.separator)) {
            this.decafDef.setDfScript(this.context.getAppDir() + File.separator + dfScript);
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String dfRunner;
        String pythonInterpreter = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.getPythonInterpreter();
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
        String args = new String();
        for (int i = 0; i < binaryParams.size(); ++i) {
            args = i == 0 ? args.concat(binaryParams.get(i)) : args.concat(" " + binaryParams.get(i));
        }
        String[] cmd = args.isEmpty() ? new String[9] : new String[11];
        cmd[0] = dfRunner = this.context.getInstallDir() + DecafDefinition.SCRIPT_PATH;
        cmd[1] = this.decafDef.getDfScript();
        cmd[2] = this.decafDef.getDfExecutor();
        cmd[3] = this.decafDef.getDfLib();
        cmd[4] = this.decafDef.getMpiRunner();
        String numProcs = String.valueOf(this.numWorkers * this.computingUnits);
        cmd[5] = "-n";
        cmd[6] = numProcs;
        cmd[7] = this.decafDef.getHostsFlag();
        try {
            cmd[8] = this.decafDef.generateHostsDefinition(this.sandBox.getFolder(), this.hostnames, this.computingUnits);
        }
        catch (IOException ioe) {
            throw new InvokeExecutionException("ERROR: writting hostfile", (Exception)ioe);
        }
        if (!args.isEmpty()) {
            cmd[9] = "--args=\"";
            cmd[10] = args;
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[DECAF INVOKER] Begin DECAF call to " + this.decafDef.getDfScript());
            outLog.println("[DECAF INVOKER] On WorkingDir : " + this.sandBox.getFolder().getAbsolutePath());
            outLog.print("[DECAF INVOKER] Decaf CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[DECAF INVOKER] Decaf STDIN: " + streamValues.getStdIn());
            outLog.println("[DECAF INVOKER] Decaf STDOUT: " + streamValues.getStdOut());
            outLog.println("[DECAF INVOKER] Decaf STDERR: " + streamValues.getStdErr());
        }
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.sandBox, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, this.decafDef.isFailByEV());
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling Decaf process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

