/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external;

import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.external.commands.ExecuteTaskExternalCommand;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class ExternalInvoker
extends Invoker {
    private static final String ERROR_UNSUPPORTED_JOB_TYPE = "Bindings don't support non-native tasks";
    protected static final String SUFFIX_OUT = ".out";
    protected static final String SUFFIX_ERR = ".err";
    protected final ExecuteTaskExternalCommand command;

    public ExternalInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandbox, assignedResources);
        String sandboxPath = sandbox.getFolder().getAbsolutePath();
        this.command = this.getTaskExecutionCommand(context, invocation, sandboxPath, assignedResources);
    }

    protected void appendOtherExecutionCommandArguments() throws JobExecutionException {
        this.command.appendAllArguments(this.getExternalCommand(this.invocation, this.context, this.assignedResources));
        String streamsName = this.context.getStandardStreamsPath(this.invocation);
        this.command.prependArgument(streamsName + SUFFIX_ERR);
        this.command.prependArgument(streamsName + SUFFIX_OUT);
    }

    protected abstract ExecuteTaskExternalCommand getTaskExecutionCommand(InvocationContext var1, Invocation var2, String var3, InvocationResources var4);

    private ArrayList<String> getExternalCommand(Invocation invocation, InvocationContext context, InvocationResources assignedResources) throws JobExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.addArguments(context, invocation));
        args.addAll(this.addThreadAffinity(assignedResources));
        args.addAll(this.addGPUAffinity(assignedResources));
        args.addAll(this.addHostlist(context, invocation));
        return args;
    }

    private ArrayList<String> addArguments(InvocationContext context, Invocation invocation) throws JobExecutionException {
        String methodName;
        String methodClass;
        if (invocation.getMethodImplementation().getMethodType() != MethodType.METHOD && invocation.getMethodImplementation().getMethodType() != MethodType.MULTI_NODE && invocation.getMethodImplementation().getMethodType() != MethodType.PYTHON_MPI) {
            throw new JobExecutionException(ERROR_UNSUPPORTED_JOB_TYPE);
        }
        ArrayList<String> lArgs = new ArrayList<String>();
        lArgs.add(Boolean.toString(Tracer.isActivated()));
        lArgs.add(Integer.toString(invocation.getTaskId()));
        lArgs.add(Boolean.toString(invocation.isDebugEnabled()));
        lArgs.add(context.getStorageConf());
        MethodType methodType = invocation.getMethodImplementation().getMethodType();
        switch (methodType) {
            case METHOD: {
                MethodDefinition methodImpl = (MethodDefinition)invocation.getMethodImplementation().getDefinition();
                methodClass = methodImpl.getDeclaringClass();
                methodName = methodImpl.getAlternativeMethodName();
                break;
            }
            case PYTHON_MPI: {
                PythonMPIDefinition pythonMPIImpl = (PythonMPIDefinition)invocation.getMethodImplementation().getDefinition();
                methodClass = pythonMPIImpl.getDeclaringClass();
                methodName = pythonMPIImpl.getAlternativeMethodName();
                break;
            }
            case MULTI_NODE: {
                MultiNodeDefinition multiNodeImpl = (MultiNodeDefinition)invocation.getMethodImplementation().getDefinition();
                methodClass = multiNodeImpl.getDeclaringClass();
                methodName = multiNodeImpl.getMethodName();
                break;
            }
            default: {
                throw new JobExecutionException(ERROR_UNSUPPORTED_JOB_TYPE);
            }
        }
        lArgs.add(String.valueOf(methodType));
        lArgs.add(methodClass);
        lArgs.add(methodName);
        lArgs.add(String.valueOf(invocation.getTimeOut()));
        List<String> nodeNames = this.getNodeNames(context, invocation);
        lArgs.add(String.valueOf(nodeNames.size()));
        lArgs.addAll(nodeNames);
        MethodResourceDescription requirements = (MethodResourceDescription)invocation.getRequirements();
        lArgs.add(String.valueOf(this.getNumThreads(context, invocation)));
        lArgs.add(Boolean.toString(invocation.getTarget() != null));
        if (!invocation.getResults().isEmpty()) {
            DataType returnType = ((InvocationParam)invocation.getResults().get(0)).getType();
            lArgs.add(Integer.toString(returnType.ordinal()));
        } else {
            lArgs.add("null");
        }
        lArgs.add(Integer.toString(invocation.getResults().size()));
        ArrayList<String> invArgs = new ArrayList<String>();
        int numParams = invocation.getParams().size();
        for (InvocationParam np : invocation.getParams()) {
            invArgs.addAll(ExternalInvoker.convertParameter(np));
        }
        if (invocation.getTarget() != null) {
            ++numParams;
            invArgs.addAll(ExternalInvoker.convertParameter(invocation.getTarget()));
        }
        for (InvocationParam np : invocation.getResults()) {
            ++numParams;
            invArgs.addAll(ExternalInvoker.convertParameter(np));
        }
        lArgs.add(Integer.toString(numParams));
        lArgs.addAll(invArgs);
        return lArgs;
    }

    protected List<String> getNodeNames(InvocationContext context, Invocation invocation) {
        return invocation.getSlaveNodesNames();
    }

    protected int getNumThreads(InvocationContext context, Invocation invocation) {
        MethodResourceDescription requirements = (MethodResourceDescription)invocation.getRequirements();
        return requirements.getTotalCPUComputingUnits();
    }

    private static ArrayList<String> convertParameter(InvocationParam np) {
        ArrayList<String> paramArgs = new ArrayList<String>();
        DataType type = np.getType();
        paramArgs.add(Integer.toString(type.ordinal()));
        paramArgs.add(Integer.toString(np.getStdIOStream().ordinal()));
        paramArgs.add(np.getPrefix());
        String name = np.getName();
        if (name == null || name.isEmpty()) {
            paramArgs.add("null");
        } else {
            paramArgs.add(name);
        }
        if (name == null || name.isEmpty()) {
            paramArgs.add("null");
        } else {
            paramArgs.add(np.getContentType());
        }
        switch (type) {
            case FILE_T: {
                String destFile;
                String originalFile = "null";
                if (np.getSourceDataId() != null) {
                    originalFile = np.getOriginalName();
                }
                if (!ExternalInvoker.isRuntimeRenamed(destFile = new File(np.getRenamedName()).getName())) {
                    destFile = originalFile;
                }
                paramArgs.add(originalFile + ":" + destFile + ":" + np.isPreserveSourceData() + ":" + np.isWriteFinalValue() + ":" + np.getOriginalName());
                break;
            }
            case OBJECT_T: 
            case PSCO_T: 
            case STREAM_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: {
                paramArgs.add(np.getValue().toString());
                paramArgs.add(np.isWriteFinalValue() ? "W" : "R");
                break;
            }
            case BINDING_OBJECT_T: {
                String destData;
                String extObjValue = np.getValue().toString();
                LOGGER.debug("Generating command args for Binding_object " + extObjValue);
                BindingObject bo = BindingObject.generate((String)extObjValue);
                String originalData = "";
                if (np.getSourceDataId() != null) {
                    originalData = np.getSourceDataId();
                }
                if (!ExternalInvoker.isRuntimeRenamed(destData = bo.getName())) {
                    destData = originalData;
                }
                paramArgs.add(originalData + ":" + destData + ":" + np.isPreserveSourceData() + ":" + np.isWriteFinalValue() + ":" + np.getOriginalName());
                paramArgs.add(Integer.toString(bo.getType()));
                paramArgs.add(Integer.toString(bo.getElements()));
                break;
            }
            case STRING_64_T: 
            case STRING_T: {
                String value = np.getValue().toString();
                String[] vals = value.split(" ");
                int numSubStrings = vals.length;
                paramArgs.add(Integer.toString(numSubStrings));
                for (String v : vals) {
                    paramArgs.add(v);
                }
                break;
            }
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                InvocationParamCollection ipc = (InvocationParamCollection)np;
                ExternalInvoker.writeCollection((InvocationParamCollection<InvocationParam>)ipc);
                paramArgs.add(np.getValue().toString());
                break;
            }
            default: {
                paramArgs.add(np.getValue().toString());
            }
        }
        return paramArgs;
    }

    private static void writeCollection(InvocationParamCollection<InvocationParam> ipc) {
        String pathToWrite = (String)ipc.getValue();
        LOGGER.debug("Writting Collection file " + pathToWrite + " ");
        if (new File(pathToWrite).exists()) {
            LOGGER.debug("Collection file " + pathToWrite + " already written");
        } else {
            try (PrintWriter writer = new PrintWriter(pathToWrite, "UTF-8");){
                for (InvocationParam subParam : ipc.getCollectionParameters()) {
                    int subParamType = subParam.getType().ordinal();
                    Object subParamValue = subParam.getValue();
                    String subParamContentType = subParam.getContentType();
                    writer.println(subParamType + " " + subParamValue + " " + subParamContentType);
                    if (!subParam.isCollective()) continue;
                    ExternalInvoker.writeCollection((InvocationParamCollection<InvocationParam>)((InvocationParamCollection)subParam));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error writting collection to file", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private static boolean isRuntimeRenamed(String filename) {
        return filename.startsWith("d") && filename.endsWith(".IT");
    }

    private ArrayList<String> addThreadAffinity(InvocationResources assignedResources) {
        String computingUnits;
        ArrayList<String> args = new ArrayList<String>();
        int[] assignedCoreUnits = assignedResources.getAssignedCPUs();
        if (assignedCoreUnits.length == 0) {
            computingUnits = "-";
        } else {
            computingUnits = String.valueOf(assignedCoreUnits[0]);
            for (int i = 1; i < assignedCoreUnits.length; ++i) {
                computingUnits = computingUnits + "," + assignedCoreUnits[i];
            }
        }
        args.add(computingUnits);
        return args;
    }

    private ArrayList<String> addGPUAffinity(InvocationResources assignedResources) {
        String computingUnits;
        ArrayList<String> args = new ArrayList<String>();
        int[] assignedGPUs = assignedResources.getAssignedGPUs();
        if (assignedGPUs.length == 0) {
            computingUnits = "-";
        } else {
            computingUnits = String.valueOf(assignedGPUs[0]);
            for (int i = 1; i < assignedGPUs.length; ++i) {
                computingUnits = computingUnits + "," + assignedGPUs[i];
            }
        }
        args.add(computingUnits);
        return args;
    }

    private ArrayList<String> addHostlist(InvocationContext context, Invocation invocation) {
        ArrayList<String> args = new ArrayList<String>();
        ResourceDescription rd = invocation.getRequirements();
        int computingUnits = invocation.getTaskType() == TaskType.METHOD ? ((MethodResourceDescription)rd).getTotalCPUComputingUnits() : 0;
        boolean firstElement = true;
        StringBuilder hostnamesSTR = new StringBuilder();
        for (String hostname : this.hostnames) {
            int i;
            if (hostname.endsWith("-ib0")) {
                hostname = hostname.substring(0, hostname.lastIndexOf("-ib0"));
            }
            if (firstElement) {
                firstElement = false;
                hostnamesSTR.append(hostname);
                for (i = 1; i < computingUnits; ++i) {
                    hostnamesSTR.append(",").append(hostname);
                }
                continue;
            }
            for (i = 0; i < computingUnits; ++i) {
                hostnamesSTR.append(",").append(hostname);
            }
        }
        String workers = hostnamesSTR.toString();
        if (workers != null && !workers.isEmpty()) {
            args.add(workers);
        } else {
            args.add("-");
        }
        return args;
    }

    @Override
    public final void invokeMethod() throws JobExecutionException, COMPSsException {
        this.invokeExternalMethod();
        for (InvocationParam np : this.invocation.getParams()) {
            ExternalInvoker.deleteParameter(np);
        }
        if (this.invocation.getTarget() != null) {
            ExternalInvoker.deleteParameter(this.invocation.getTarget());
        }
        for (InvocationParam np : this.invocation.getResults()) {
            ExternalInvoker.deleteParameter(np);
        }
    }

    protected abstract void invokeExternalMethod() throws JobExecutionException, COMPSsException;

    private static void deleteParameter(InvocationParam np) {
        if (np.isCollective()) {
            InvocationParamCollection ipc = (InvocationParamCollection)np;
            ExternalInvoker.deleteCollection((InvocationParamCollection<InvocationParam>)ipc);
        }
    }

    private static void deleteCollection(InvocationParamCollection<InvocationParam> ipc) {
        String pathToWrite = (String)ipc.getValue();
        LOGGER.debug("Removing Collection file " + pathToWrite + " ");
        new File(pathToWrite).delete();
        for (InvocationParam subParam : ipc.getCollectionParameters()) {
            if (!subParam.isCollective()) continue;
            ExternalInvoker.deleteCollection((InvocationParamCollection<InvocationParam>)((InvocationParamCollection)subParam));
        }
    }
}

