/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.executor.external.piped.ControlPipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PythonMirror
extends PipedMirror {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.Executor.Invoker");
    private static final String BINDINGS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "bindings-common" + File.separator + "lib";
    public static final String PYCOMPSS_RELATIVE_PATH = File.separator + "Bindings" + File.separator + "python";
    private static final String WORKER_PY_RELATIVE_PATH = File.separator + "pycompss" + File.separator + "worker" + File.separator + "piper" + File.separator + "piper_worker.py";
    private static final String MPI_WORKER_PY_RELATIVE_PATH = File.separator + "pycompss" + File.separator + "worker" + File.separator + "piper" + File.separator + "mpi_piper_worker.py";
    private static final String ENV_LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String ENV_PYTHONPATH = "PYTHONPATH";
    private final PythonParams pyParams;
    private final String pyCOMPSsHome;

    public PythonMirror(InvocationContext context, int size) {
        super(context, size);
        this.pyParams = (PythonParams)context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        String installDir = context.getInstallDir();
        this.pyCOMPSsHome = installDir + PYCOMPSS_RELATIVE_PATH + File.separator + this.pyParams.getPythonVersion();
        this.init(context);
    }

    @Override
    public String getMirrorName() {
        return "python";
    }

    @Override
    public String getPipeBuilderContext() {
        StringBuilder cmd = new StringBuilder();
        cmd.append(COMPSsConstants.Lang.PYTHON).append(" ");
        cmd.append(this.pyParams.getPythonVirtualEnvironment()).append(" ");
        cmd.append(this.pyParams.getPythonPropagateVirtualEnvironment()).append(" ");
        cmd.append(this.pyParams.usePythonMpiWorker()).append(" ");
        cmd.append(this.size + 1).append(" ");
        cmd.append(this.pyParams.getPythonInterpreter()).append(" ");
        cmd.append(this.pyParams.getPythonExtraeFile()).append(" ");
        return cmd.toString();
    }

    @Override
    public String getLaunchWorkerCommand(InvocationContext context, ControlPipePair pipe) {
        int i;
        String profilePath;
        StringBuilder cmd = new StringBuilder();
        if (this.pyParams.usePythonMpiWorker().booleanValue()) {
            cmd.append("mpirun").append(" ");
            cmd.append("-np").append(" ").append(this.size + 1).append(" ");
            cmd.append("-x").append(" ").append("LD_PRELOAD=$LATER_MPI_LD_PRELOAD").append(" ");
            cmd.append("-x").append(" ").append("EXTRAE_CONFIG_FILE=$LATER_MPI_EXTRAE_CONFIG_FILE").append(" ");
            cmd.append("-x").append(" ").append("EXTRAE_USE_POSIX_CLOCK=0").append(" ");
            cmd.append("-x").append(" ").append("PYTHONPATH=$LATER_MPI_PYTHONPATH:$PYTHONPATH").append(" ");
        }
        cmd.append(this.pyParams.getPythonInterpreter()).append(" ").append("-u").append(" ");
        if (!LOGGER.isDebugEnabled()) {
            cmd.append("-O").append(" ");
        }
        if ((profilePath = System.getenv("COMPSS_WORKER_PROFILE_PATH")) != null) {
            cmd.append("-m").append(" ").append("mprof").append(" ").append("run").append(" ");
            cmd.append("--multiprocess").append(" ").append("--include-children").append(" ");
            String profileFile = profilePath + "/";
            try {
                profileFile = profileFile + InetAddress.getLocalHost().getHostName() + ".dat";
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            cmd.append("--output").append(" ").append(profileFile).append(" ");
        }
        if (this.pyParams.usePythonMpiWorker().booleanValue()) {
            cmd.append(this.pyCOMPSsHome).append(MPI_WORKER_PY_RELATIVE_PATH).append(" ");
        } else {
            cmd.append(this.pyCOMPSsHome).append(WORKER_PY_RELATIVE_PATH).append(" ");
        }
        cmd.append(context.getWorkingDir()).append(" ");
        cmd.append(context.getLogDir()).append(" ");
        cmd.append(context.getAnalysisDir()).append(" ");
        cmd.append(context.getRuntimeAPI() != null).append(" ");
        cmd.append(LOGGER.isDebugEnabled()).append(" ");
        cmd.append(Tracer.isActivated()).append(" ");
        cmd.append(context.getStorageConf()).append(" ");
        cmd.append(context.getStreamingBackend().name()).append(" ");
        cmd.append(context.getStreamingMasterName()).append(" ");
        cmd.append(context.getStreamingMasterPort()).append(" ");
        cmd.append(this.pyParams.getPythonWorkerCache()).append(" ");
        cmd.append(this.pyParams.getPythonCacheProfiler()).append(" ");
        cmd.append(this.size).append(" ");
        for (int i2 = 0; i2 < this.size; ++i2) {
            cmd.append(i2).append(" ");
        }
        String executorPipes = this.basePipePath + "executor";
        for (i = 0; i < this.size; ++i) {
            cmd.append(executorPipes).append(i).append(".outbound").append(" ");
        }
        for (i = 0; i < this.size; ++i) {
            cmd.append(executorPipes).append(i).append(".inbound").append(" ");
        }
        cmd.append(pipe.getOutboundPipe()).append(" ");
        cmd.append(pipe.getInboundPipe());
        return cmd.toString();
    }

    @Override
    public Map<String, String> getEnvironment(InvocationContext context) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PYCOMPSS_HOME", this.pyCOMPSsHome);
        String pythonPath = System.getenv(ENV_PYTHONPATH);
        pythonPath = pythonPath == null ? this.pyCOMPSsHome + ":" + this.pyParams.getPythonPath() + ":" + context.getAppDir() : this.pyCOMPSsHome + ":" + this.pyParams.getPythonPath() + ":" + context.getAppDir() + pythonPath;
        env.put(ENV_PYTHONPATH, pythonPath);
        String ldLibraryPath = System.getenv(ENV_LD_LIBRARY_PATH);
        String bindingsHome = context.getInstallDir() + BINDINGS_RELATIVE_PATH;
        ldLibraryPath = ldLibraryPath != null ? ldLibraryPath.concat(":" + bindingsHome) : bindingsHome;
        env.put(ENV_LD_LIBRARY_PATH, ldLibraryPath);
        return env;
    }

    @Override
    protected String getPBWorkingDir(InvocationContext context) {
        String workingDir = super.getPBWorkingDir(context);
        if (Tracer.isActivated()) {
            File wdpath = new File(workingDir = workingDir + "python");
            if (!wdpath.exists()) {
                if (!wdpath.mkdirs()) {
                    ErrorManager.error((String)("Could not create working dir for python tracefiles, path: " + workingDir));
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Working directorty for python trace files: " + workingDir + " already exists!.. Skipping!");
            }
        }
        return workingDir;
    }
}

