/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.external.piped.commands;

import es.bsc.compss.executor.external.commands.CompssExceptionExternalCommand;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;

public class CompssExceptionPipeCommand
extends CompssExceptionExternalCommand
implements PipeCommand {
    public final Integer jobId;
    public final String message;

    public CompssExceptionPipeCommand(Integer jobId, String message) {
        this.jobId = jobId;
        this.message = message;
    }

    public CompssExceptionPipeCommand(String[] line) {
        this.jobId = Integer.parseInt(line[1]);
        this.message = line[2].replaceAll("_", " ");
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public int compareTo(PipeCommand t) {
        int value = Integer.compare(this.getType().ordinal(), t.getType().ordinal());
        if (value != 0) {
            value = Integer.compare(this.jobId, ((CompssExceptionPipeCommand)t).jobId);
        }
        return value;
    }

    @Override
    public void join(PipeCommand receivedCommand) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getAsString() {
        StringBuilder sb = new StringBuilder(super.getAsString());
        sb.append(" ");
        sb.append(this.jobId);
        sb.append(" ");
        sb.append(this.message.replace(" ", "_"));
        return sb.toString();
    }
}

