/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.utils.execution;

import es.bsc.compss.execution.ExecutionPlatform;
import es.bsc.compss.execution.ExecutionPlatformConfiguration;
import es.bsc.compss.execution.utils.ResourceManager;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationExecutionRequest;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.InvalidMapException;
import es.bsc.compss.util.ErrorManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.ExecManager");
    private final ExecutionPlatform cpuExecutors;
    private final ExecutionPlatform ioExecutors;

    public ExecutionManager(InvocationContext context, int computingUnitsCPU, String cpuMap, boolean reuseCPUsOnBlock, int computingUnitsGPU, String gpuMap, int computingUnitsFPGA, String fpgaMap, int ioExecNum, int limitOfTasks) {
        ResourceManager rm = null;
        try {
            rm = new ResourceManager(computingUnitsCPU, cpuMap, computingUnitsGPU, gpuMap, computingUnitsFPGA, fpgaMap);
        }
        catch (InvalidMapException ime) {
            ErrorManager.fatal((Exception)((Object)ime));
        }
        ExecutionPlatformConfiguration cpuConf = new ExecutionPlatformConfiguration(computingUnitsCPU, reuseCPUsOnBlock);
        this.cpuExecutors = new ExecutionPlatform("CPUThreadPool", context, cpuConf, rm);
        ExecutionPlatformConfiguration ioConf = new ExecutionPlatformConfiguration(ioExecNum, false);
        this.ioExecutors = new ExecutionPlatform("IOThreadPool", context, ioConf, rm);
    }

    public void init() throws InitializationException {
        LOGGER.info("Init Execution Manager");
        this.cpuExecutors.start();
        if (this.ioExecutors.getSize() > 0) {
            this.ioExecutors.start();
        }
    }

    public void startMirror() {
        LOGGER.info("Init Python Mirror");
        this.cpuExecutors.startMirror();
    }

    public void enqueue(InvocationExecutionRequest exec) {
        if (exec.isIOExecution()) {
            if (this.ioExecutors.getSize() == 0) {
                ErrorManager.error((String)("No available IO executors to execute: " + exec.getInvocationSignature()));
            } else {
                this.ioExecutors.execute(exec);
            }
        } else {
            this.cpuExecutors.execute(exec);
        }
    }

    public void stop() {
        LOGGER.info("Stopping Threads...");
        this.cpuExecutors.stop();
        if (this.ioExecutors.getSize() > 0) {
            this.ioExecutors.stop();
        }
    }

    public void increaseCapabilities(int cpuCount, int gpuCount, int fpgaCount, int otherCount) {
        this.cpuExecutors.addWorkerThreads(cpuCount);
    }

    public void reduceCapabilities(int cpuCount, int gpuCount, int fpgaCount, int otherCount) {
        this.cpuExecutors.removeWorkerThreads(cpuCount);
    }

    public void cancelJob(int jobId) {
        this.cpuExecutors.cancelJob(jobId);
    }
}

