/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.execution.utils;

import es.bsc.compss.types.execution.ExecutorRequest;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobQueue {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.ThreadPool");
    private final BlockingQueue<ExecutorRequest> queue = new LinkedBlockingQueue<ExecutorRequest>();
    private BlockingDeque<Object> waitingLocks = new LinkedBlockingDeque<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(ExecutorRequest request) {
        LOGGER.debug("Enqueueing " + request.toString());
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            this.queue.add(request);
            if (!this.waitingLocks.isEmpty()) {
                Object lock = request.hasAgePriority() ? this.waitingLocks.removeLast() : this.waitingLocks.removeFirst();
                Object e = lock;
                synchronized (e) {
                    LOGGER.debug("Releasing lock " + lock.hashCode());
                    lock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorRequest dequeue() {
        ExecutorRequest exec = null;
        Object lock = new Object();
        while (exec == null) {
            Object object = lock;
            synchronized (object) {
                JobQueue jobQueue = this;
                synchronized (jobQueue) {
                    exec = (ExecutorRequest)this.queue.poll();
                    if (exec != null) {
                        break;
                    }
                    this.waitingLocks.push(lock);
                }
                try {
                    lock.wait();
                }
                catch (InterruptedException ie) {
                    LOGGER.error("ERROR: Job Thread was interrupted while waiting for next job", (Throwable)ie);
                    return null;
                }
            }
        }
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorRequest newThreadDequeue() {
        ExecutorRequest exec = null;
        Object lock = new Object();
        while (exec == null) {
            Object object = lock;
            synchronized (object) {
                JobQueue jobQueue = this;
                synchronized (jobQueue) {
                    exec = (ExecutorRequest)this.queue.poll();
                    if (exec != null) {
                        break;
                    }
                    this.waitingLocks.addLast(lock);
                }
                try {
                    lock.wait();
                }
                catch (InterruptedException ie) {
                    LOGGER.error("ERROR: Job Thread was interrupted while waiting for next job", (Throwable)ie);
                    return null;
                }
            }
        }
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpAll() {
        LOGGER.info("Waking up " + this.waitingLocks.size() + " locks.");
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            while (!this.waitingLocks.isEmpty()) {
                Object lock;
                Object e = lock = this.waitingLocks.pop();
                synchronized (e) {
                    LOGGER.debug("Release lock" + lock.hashCode());
                    lock.notify();
                }
            }
        }
    }
}

