/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.types.StdIOStream;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.MPIProgram;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.definition.ContainerDescription;
import es.bsc.compss.types.implementations.definition.MpmdMPIDefinition;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class MpmdMPIInvoker
extends Invoker {
    private static final int NUM_BASE_MPI_ARGS = 6;
    private static final String ERROR_TARGET_PARAM = "ERROR: MPI Execution doesn't support target parameters";
    private MpmdMPIDefinition definition;
    private BinaryRunner br;

    public MpmdMPIInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandbox, assignedResources);
        try {
            this.definition = (MpmdMPIDefinition)this.invocation.getMethodImplementation().getDefinition();
            this.definition.setRunnerProperties(context.getInstallDir());
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + this.invocation.getMethodImplementation().getMethodType(), (Throwable)e);
        }
        this.br = null;
    }

    private void checkArguments() throws JobExecutionException {
        try {
            this.definition.checkArguments();
        }
        catch (IllegalArgumentException e) {
            throw new JobExecutionException((Throwable)e);
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoking MPMDMPI " + this.definition + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException | IOException iee) {
            throw new JobExecutionException(iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (lp instanceof PythonParams) {
                    PythonParams pp = (PythonParams)lp;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException((Throwable)se);
        }
        for (InvocationParam np : this.invocation.getResults()) {
            if (np.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(np, retValue);
                continue;
            }
            np.setValue(retValue);
            np.setValueClass(retValue.getClass());
        }
    }

    private Object runInvocation() throws InvokeExecutionException, IOException {
        ContainerDescription container = this.definition.getContainer();
        if (container != null) {
            String optionsStr = container.getOptions();
            String[] options = BinaryRunner.buildAppParams(this.invocation.getParams(), optionsStr, null);
            StringBuilder stringBuilder = new StringBuilder();
            for (String option : options) {
                stringBuilder.append(option);
            }
            container.setOptions(stringBuilder.toString());
        }
        String pythonInterpreter = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.checkCoverageAndGetPythonInterpreter();
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
        for (MPIProgram program : this.definition.getPrograms()) {
            if (!program.hasParamsString()) continue;
            CharSequence[] tmp = BinaryRunner.buildAppParams(this.invocation.getParams(), program.getParams(), pythonInterpreter);
            program.setParams(String.join((CharSequence)" ", tmp));
            program.setParamsArray((String[])tmp);
        }
        String[] cmd = this.definition.generateCMD(this.sandBox.getFolder(), this.hostnames, this.computingUnits, container);
        this.br = new BinaryRunner();
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[MPMD MPI INVOKER] On WorkingDir : " + this.sandBox.getFolder().getAbsolutePath());
            outLog.print("[MPMD MPI INVOKER] BINARY CMD: ");
            for (String s : cmd) {
                outLog.print(s + " ");
            }
            outLog.println("");
            outLog.println("[MPMD MPI INVOKER] Binary STDIN: " + streamValues.getStdIn());
            outLog.println("[MPMD MPI INVOKER] Binary STDOUT: " + streamValues.getStdOut());
            outLog.println("[MPMD MPI INVOKER] Binary STDERR: " + streamValues.getStdErr());
        }
        return this.br.executeCMD(cmd, streamValues, this.sandBox, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, this.definition.isFailByEV());
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling MPI process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }

    @Override
    protected void setEnvironmentVariables() {
        super.setEnvironmentVariables();
        int ppn = this.definition.getPPN();
        if (LOGGER.isDebugEnabled()) {
            System.out.println("[MPMD MPI INVOKER] OVERWRITING COMPSS_NUM_PROCS: " + this.computingUnits);
        }
        System.setProperty("COMPSS_NUM_PROCS", String.valueOf(this.computingUnits));
        if (ppn > 1) {
            int threads = this.computingUnits / ppn;
            System.setProperty("COMPSS_NUM_THREADS", String.valueOf(threads));
            System.setProperty("OMP_NUM_THREADS", String.valueOf(threads));
            if (LOGGER.isDebugEnabled()) {
                System.out.println("[MPMD MPI INVOKER] OVERWRITING COMPSS_NUM_THREADS: " + threads);
            }
        }
    }
}

